<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	add_filter('gdlr_core_use_font_icons', 'mediz_gdlr_core_use_font_icons');
	if( !function_exists('mediz_gdlr_core_use_font_icons') ){
		function mediz_gdlr_core_use_font_icons( $icons ){
			return mediz_get_option('plugin', 'font-icon', $icons);
		}
	} 

	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'mediz_page_builder_body_class');
	if( !function_exists('mediz_page_builder_body_class') ){
		function mediz_page_builder_body_class( $classes ) {
			return $classes . ' mediz-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'mediz_gdlr_core_sidebar_class');
	if( !function_exists('mediz_gdlr_core_sidebar_class') ){
		function mediz_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' mediz-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'mediz_goodlayers_core_setup');
	if( !function_exists( 'mediz_goodlayers_core_setup' ) ){
		function mediz_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'mediz_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'mediz_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'mediz_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'mediz_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'mediz_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'mediz_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'mediz_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_nav_middle_link', 'mediz_gdlr_core_portfolio_single_nav_middle_link');
			add_filter('gdlr_core_portfolio_single_related', 'mediz_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'mediz_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'mediz_gdlr_core_portfolio_hover_icon_class');

			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'mediz_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('mediz_gdlr_core_privacy_settings') ){
		function mediz_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = mediz_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}

	add_filter('gdlr_core_google_font_display', 'mediz_gdlr_core_google_font_display');
	if( !function_exists('mediz_gdlr_core_google_font_display') ){
		function mediz_gdlr_core_google_font_display( $display ){
			return mediz_get_option('typography', 'google-font-display', '');
		}
	}
	

	// portfolio hover icon class
	if( !function_exists('mediz_gdlr_core_portfolio_hover_icon_class') ){
		function mediz_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return mediz_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return mediz_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return mediz_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('mediz_gdlr_core_enable_srcset') ){
		function mediz_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = mediz_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('mediz_gdlr_core_pagination_style') ){
		function mediz_gdlr_core_pagination_style( $style ) {
			return mediz_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('mediz_gdlr_core_pagination_align') ){
		function mediz_gdlr_core_pagination_align( $align ) {
			return mediz_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('mediz_gdlr_core_custom_post_slug') ){
		function mediz_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = mediz_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = mediz_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = mediz_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = mediz_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = mediz_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('mediz_gdlr_core_portfolio_single_nav') ){
		function mediz_gdlr_core_portfolio_single_nav( $check ) {
			return mediz_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('mediz_gdlr_core_portfolio_single_nav_same_term') ){
		function mediz_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return mediz_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('mediz_gdlr_core_portfolio_single_nav_middle_link') ){
		function mediz_gdlr_core_portfolio_single_nav_middle_link( $check ) {
			return mediz_get_option('general', 'single-portfolio-navigation-middle-link', $check);
		}
	}
	if( !function_exists('mediz_gdlr_core_portfolio_single_related') ){
		function mediz_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = mediz_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = mediz_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = mediz_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = mediz_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = mediz_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = mediz_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = mediz_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('mediz_gdlr_core_social_share_list') ){
		function mediz_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = mediz_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = mediz_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['google-plus'] = mediz_get_option('general', 'blog-social-google-plus', $social['google-plus']);
			$social['pinterest'] = mediz_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = mediz_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = mediz_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = mediz_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'mediz_register_custom_uploaded_font');
	if( !function_exists('mediz_register_custom_uploaded_font') ){
		function mediz_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = mediz_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$font_option['name'] = str_replace('+', '', $font_option['name']);
					while( !empty($custom_fonts[$font_option['name']]) ){
						$font_option['name'] = $font_option['name'] . '+';
					}

					$custom_fonts[$font_option['name']] = array(
						'eot' => empty($font_option['eot'])? '': $font_option['eot'],
						'ttf' => empty($font_option['ttf'])? '': $font_option['ttf'],
						'woff' => empty($font_option['woff'])? '': $font_option['woff'],
						'font-weight' => empty($font_option['font-weight'])? 'normal': $font_option['font-weight'],
						'font-style' => empty($font_option['font-style'])? 'normal': $font_option['font-style']
					);
				}
			}		
			
			return $custom_fonts;
			
		} // mediz_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('mediz_gdlr_core_widget_title_nav') ){
		function mediz_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'mediz_gdlr_core_page_builder_post_type');
	if( !function_exists('mediz_gdlr_core_page_builder_post_type') ){
		function mediz_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'mediz_gdlr_core_lightbox_type');
	if( !function_exists('mediz_gdlr_core_lightbox_type') ){
		function mediz_gdlr_core_lightbox_type(){
			$lightbox_type = mediz_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = mediz_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'mediz_lightbox_body_class');
	if( !function_exists('mediz_lightbox_body_class') ){
		function mediz_lightbox_body_class($class){
			$link_to_lightbox = mediz_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}

	add_filter('gdlr_core_lightbox_video_autoplay', 'mediz_lightbox_video_autoplay');
	if( !function_exists('mediz_lightbox_video_autoplay') ){
		function mediz_lightbox_video_autoplay($autoplay){
			$video_autoplay = mediz_get_option('plugin', 'lightbox-video-autoplay', 'enable');
			return ($video_autoplay == 'enable')? true: false;
		}
	}
	
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'mediz_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'mediz_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('mediz_gdlr_core_page_builder_page_template_list') ){
		function mediz_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['home-clinic'] = array(
				'title' => esc_html__('Home - Clinic', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['home-hospital'] = array(
				'title' => esc_html__('Home - Hospital', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['home-dentist'] = array(
				'title' => esc_html__('Home - Dentist', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['home-dentist2'] = array(
				'title' => esc_html__('Home - Dentist 2', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['about-us'] = array(
				'title' => esc_html__('About Us', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['about-us2'] = array(
				'title' => esc_html__('About Us 2', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['about-us3'] = array(
				'title' => esc_html__('About Us 3', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['our-services'] = array(
				'title' => esc_html__('Our Services', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['our-services2'] = array(
				'title' => esc_html__('Our Services 2', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['our-services3'] = array(
				'title' => esc_html__('Our Services 3', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['our-doctor'] = array(
				'title' => esc_html__('Our Doctor', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['our-doctor2'] = array(
				'title' => esc_html__('Our Doctor 2', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['department'] = array(
				'title' => esc_html__('Department', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['sub-department'] = array(
				'title' => esc_html__('Sub Department', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['timetable'] = array(
				'title' => esc_html__('Time Table (Hospital)', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['timetable2'] = array(
				'title' => esc_html__('Time Table (Dentist)', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['contact2'] = array(
				'title' => esc_html__('Contact 2', 'mediz'),
				'type' => 'wrapper',
			);
			$templates['contact3'] = array(
				'title' => esc_html__('Contact 3', 'mediz'),
				'type' => 'wrapper',
			);
			return $templates;
		} // mediz_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('mediz_gdlr_core_page_builder_get_page_template') ){
		function mediz_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'home-clinic': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8082","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"200px","right":"0px","bottom":"200px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8084","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"200px","right":"100px","bottom":"170px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"I am a Chiropractor","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"21px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#9ac8ff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"5px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Dr. John Newman","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"60px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9ac8ff","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#b7cfff","margin-left":"","margin-right":"","padding-bottom":"28px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"8083","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8052","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"45px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon-phone","icon-hover":"","title":"+1-2345-3455-33","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-envelope","icon-hover":"","title":"contact@mediztheme.co","caption":"","link-url":"","link-target":"_self"}],"columns":"60","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","caption-color":"","border-color":"","icon-size":"20px","content-size":"17px","content-font-weight":"","content-text-transform":"","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"5px","padding-bottom":"19px"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"#","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"left","icon-size":"19px","with-text":"disable","text-size":"15px","icon-color":"#ffffff","icon-space":"20px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f2","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8095","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"110px","right":"85px","bottom":"100px","left":"95px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"90px","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"col-clinic"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Professional Chiropractor","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"30px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8092","character":"","title":"Chiropractic BioPhysics","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my life.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"300","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"13px","right":"25px","bottom":"","left":"10px"},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8093","character":"","title":"Certified Professional","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my life.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"300","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"12px","right":"25px","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8094","character":"","title":"Modern Technology","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my life.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"300","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"12px","right":"25px","bottom":"","left":"-5px"},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Make an appointment","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#17449e","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f2","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8091","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"200px","right":"0px","bottom":"200px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8154","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"20px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"32px","divider-border-radius":"25px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"25px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#597cc4"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Chiropracitc Treatment","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"3px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#17449e","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.10","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8179","thumbnail-size":"Portfolio Thumbnail","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"5px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Neck and middle back pain","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#2c2c2c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.10","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8180","thumbnail-size":"Portfolio Thumbnail","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"5px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Hip, knee and ankle injury","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#2c2c2c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.10","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8181","thumbnail-size":"Portfolio Thumbnail","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"5px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Arm, shoulder and hand problems","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#2c2c2c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.10","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8182","thumbnail-size":"Portfolio Thumbnail","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"5px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Disc Injury","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#2c2c2c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.10","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8183","thumbnail-size":"Portfolio Thumbnail","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"5px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Poor posture and flexibility","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#2c2c2c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.10","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8184","thumbnail-size":"Portfolio Thumbnail","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"5px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Neck and middle back pain","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#2c2c2c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"960px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"32px","divider-border-radius":"25px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"25px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#dcdcdc"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Accreditation Agency","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"3px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#17449e","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Certified by the Joint Commission ","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"29px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>One of the first major discoveries relevant to the field of pulmonology was the discovery of pulmonary circulation. Originally, it was thought that blood reaching the right side of the heart passed through small</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7297","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"","t-right":"","b-right":"","b-left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.27","padding":{"top":"110px","right":"220px","bottom":"115px","left":"220px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"85px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz A2 Counter"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"200","animation-time":"","suffix":"","divider":"disable","bottom-text":"Doctors","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"29000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Happy Patients","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Medical Beds","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"150","animation-time":"","suffix":"","divider":"disable","bottom-text":"Winning Awards","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f3","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8111","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.02","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f3","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8138","background-image-style":"no-repeat","background-image-position":"center-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"115px","right":"90px","bottom":"100px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"75px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Biography","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"30px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#282828","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9ac8ff","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Chiropractic is a form of alternative medicine that is concerned with the diagnosis and treatment of mechanical disorders of the musculoskeletal system, especially the spine.Chiropractors have proposed, especially those in the field\'s early history, that such</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"15px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#575757","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Cardio-oncology","icon":"","percent":"100","bar-text":""},{"heading-text":"Heart assessment","icon":"","percent":"90","bar-text":""},{"heading-text":"Heart surgery","icon":"","percent":"80","bar-text":""}],"heading-text-color":"#181818","icon-color":"","percent-color":"#8e8e8e","bar-filled-color":"#17449e","bar-background-color":"#dcdcdc","padding-bottom":"45px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"11px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"25px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#16449f","background-hover-color":"","background-gradient-color":"#2c67c2","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f4","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8214","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"90px","bottom":"95px","left":"95px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"65px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"acc-ourdoc"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Frequently Asked Questions","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"30px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"How much will my hospital stay cost?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."},{"head-text":"","title":"What if I have difficulty paying for my expenses?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."},{"head-text":"","title":"What happens to my admission?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."},{"head-text":"","title":"How do I use my Medisave to pay the hospital bill?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."}],"active":"1","allow-closing-all-tabs":"disable","style":"icon","with-divider":"enable","align":"left","icon-position":"left","padding-bottom":"15px","title-font-size":"17px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","title-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All FAQ","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"12px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"25px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#16449f","background-hover-color":"","background-gradient-color":"#2c67c2","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"f4","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8140","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"150px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8169","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"144px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":"","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8097","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"120px","right":"","bottom":"90px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"900px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What do chiropractors do?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"41px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"22px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"115px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"27px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#6095ff"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Chiropractic is a form of alternative medicine that is concerned with the diagnosis and treatment of mechanical disorders of the musculoskeletal system, especially the spine.Chiropractors.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#bedbff","margin-left":"","margin-right":"","padding-bottom":"50px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"+1-2345-3455-33","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"icon-phone","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"24px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#ffffff","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Or","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"41px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Book Now!","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"13px","right":"40px","bottom":"15px","left":"40px","settings":"unlink"},"border-radius":"25px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#15439e","background-hover-color":"","background-gradient-color":"#2c67c2","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"700","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8102","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"32px","divider-border-radius":"25px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"25px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#597cc4"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Chiropractors","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"3px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#17449e","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"5px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Personnel"},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"6","filterer":"disable","filterer-color":"","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid-with-background","always-show-overlay-content":"enable","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"enable","thumbnail-opacity":"","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-hover-title":"disable","enable-hover-social":"disable","enable-hover-excerpt":"disable","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"45px","personnel-title-font-size":"20px","personnel-title-font-weight":"700","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"15px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"shadow-color":"#0a0a0a","shadow-opacity":"0.09","personnel-border-radius":"5px","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","padding-bottom":"40px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8104","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"inner-border","border-pre-spaces":{"top":"60px","right":"60px","bottom":"60px","left":"60px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#5d7ca1","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"155px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonial","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"850px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Mildred Payne","position":"Allergist","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7969","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-1.jpg","rating":""},{"title":"Mary Jane","position":"Patient","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7929","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-2.jpg","rating":""},{"title":"Paul Smith","position":"Patient","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7931","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-4.jpg","rating":""}],"style":"center","with-frame":"disable","column":"1","thumbnail-size":"thumbnail","enable-quote":"enable","left-quote-position":"left","quote-position":"top","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":" fa fa-long-arrow-left","carousel-navigation-right-icon":"fa fa-long-arrow-right","carousel-navigation-size":"40px","carousel-navigation-icon-color":"#17449e","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"-150px","carousel-nav-style":"gdlr-core-rectangle-style","carousel-bullet-style":"default","quote-size":"160px","quote-font-weight":"800","quote-height":"","quote-top-margin":"70px","quote-bottom-margin":"0px","title-size":"36px","title-text-transform":"none","title-font-weight":"700","title-letter-spacing":"0px","content-size":"21px","content-font-style":"italic","content-font-weight":"400","content-letter-spacing":"0px","name-size":"20px","name-font-weight":"700","name-letter-spacing":"0px","name-text-transform":"none","caption-size":"15px","position-font-style":"normal","position-font-weight":"400","rating-font-size":"","frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-border-radius":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-color":"#020202","caption-color":"","quote-color":"#688fde","content-color":"#ffffff","name-color":"#ffffff","position-color":"#aad0ff","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"20px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"g1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8189","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"114px","right":"80px","bottom":"80px","left":"87px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"letterbgwhite"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Make an appointment","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"30px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Complete the form and we will send you a confirmation within 24 hours.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#8e8e8e","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"5826","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.05","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"g1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8215","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"114px","right":"160px","bottom":"80px","left":"87px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Clinic Contact Newsletter"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Info","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"5px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"115px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"40px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#17449e"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon-map","icon-hover":"","title":"Box 323 1810 Kings Way King Street, New York","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-phone","icon-hover":"","title":"+1-2345-3455-33","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-envelope-open","icon-hover":"","title":"contact@mediztheme.co","caption":"","link-url":"","link-target":"_self"}],"columns":"60","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#17449e","icon-background-color":"","content-color":"#17449e","caption-color":"","border-color":"","icon-size":"20px","content-size":"18px","content-font-weight":"","content-text-transform":"","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"14px","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Opening Hours","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h2","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#323232","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"opening-hours","value":{"id":"","class":"","tabs":[{"title":"Monday-Tuesday","time":"09:00 - 20:00","open":"enable"},{"title":"Friday","time":"09:00 - 19:00","open":"enable"},{"title":"Saturday","time":"09:00 - 18:00","open":"enable"},{"title":"Sunday","time":"09:00 - 18:00","open":"enable"}],"divider-style":"solid","icon-position":"left","icon-style":"","icon":"","day-text-color":"#17449e","time-color":"#17449e","close-color":"","icon-color":"#17449e","divider-color":"#dddddd","padding-bottom":"45px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"gradient-v","background-color":"#1948a1","background-color-opacity":"1","background-gradient-color":"#3278cb","background-gradient-color-opacity":"1","background-image":"8110","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"115px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"75px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8216","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":"","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8106","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"9px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8107","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"5px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8108","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"7px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8109","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"6px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]}]';
				case 'home-hospital': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#17449e","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"2","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1240px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"9","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7692","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"-63px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"-10px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height Mediz Top BG","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Emergency Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"7690","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"-4px","right":"15px","bottom":"","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>An emergency department (ED), also known as an accident &amp; emergency department (A&amp;E), emergency room (ER), emergency ward (EW) or casualty department, is a medical treatment.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#abcbff","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Call : +1-2345-3455-33","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"21px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height Mediz Top BG","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"45px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Opening hours","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"7691","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"-2px","right":"12px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#abcbff","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"opening-hours","value":{"id":"","class":"","tabs":[{"title":"Mon - Fri","time":"08:00 - 21:00","open":"enable"},{"title":"Sat - Sun","time":"08:00 - 19:00","open":"enable"}],"divider-style":"solid","icon-position":"right","icon-style":"none","icon":"","day-text-color":"#ffffff","time-color":"#ffffff","close-color":"#ffffff","icon-color":"","divider-color":"#5a7ec6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7257","background-image-top-offset":"70px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz HP Column SVC"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"fixed","side-border-alignment":"lower-right","side-border-width":"44px","side-border-size":"4px","side-border-spaces":"15px","side-border-radius":"2px","side-border-style":"solid","side-border-divider-color":"#d8d8d8","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#1c4ca5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"20px","bottom":"20px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7252","character":"","title":"Lung Diseases","caption":"","caption-position":"bottom","content":"<p>One of the key classifications is between traditio nal small molecule drugs; usually derived from chemical synthesis.</p>","read-more-text":"Learn More","read-more-link":"/mediz/hospital/our-services/lung-diseases/","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"23px","icon-color":"#748ec4","icon-background":"","background-color":"","media-margin":{"top":"3px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"20px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7253","character":"","title":"Heart Diseases","caption":"","caption-position":"bottom","content":"<p>One of the key classifications is between traditio nal small molecule drugs; usually derived from chemical synthesis.</p>","read-more-text":"Learn More","read-more-link":"/mediz/hospital/our-services/heart/","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"23px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"11px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"20px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7254","character":"","title":"Orthopaedic","caption":"","caption-position":"bottom","content":"<p>One of the key classifications is between traditio nal small molecule drugs; usually derived from chemical synthesis.</p>","read-more-text":"Learn More","read-more-link":"/mediz/hospital/our-services/orthopaedic/","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"23px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"6px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"20px","bottom":"20px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7693","character":"","title":"General Surgery","caption":"","caption-position":"bottom","content":"<p>One of the key classifications is between traditio nal small molecule drugs; usually derived from chemical synthesis.</p>","read-more-text":"Learn More","read-more-link":"/mediz/hospital/our-services/general-surgery/","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"23px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"20px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7694","character":"","title":"Pharmacy","caption":"","caption-position":"bottom","content":"<p>One of the key classifications is between traditio nal small molecule drugs; usually derived from chemical synthesis.</p>","read-more-text":"Learn More","read-more-link":"/mediz/hospital/our-services/pharmacy/","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"23px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"3px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"20px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7695","character":"","title":"Sports Injury","caption":"","caption-position":"bottom","content":"<p>One of the key classifications is between traditio nal small molecule drugs; usually derived from chemical synthesis.</p>","read-more-text":"Learn More","read-more-link":"/mediz/hospital/our-services/sport-injury/","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"23px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"0px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1240px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"9","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7297","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"45px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.27","padding":{"top":"70px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"-80px","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz A2 Counter"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"200","animation-time":"","suffix":"","divider":"disable","bottom-text":"Doctors","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"29000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Happy Patients","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Medical Beds","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"150","animation-time":"","suffix":"","divider":"disable","bottom-text":"Winning Awards","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f5f5f5","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz HP Column SVS MId"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"175px","right":"60px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Expertise","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"fixed","side-border-alignment":"lower-right","side-border-width":"44px","side-border-size":"4px","side-border-spaces":"15px","side-border-radius":"2px","side-border-style":"solid","side-border-divider-color":"#d8d8d8","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"600","caption-font-style":"normal","caption-font-letter-spacing":"4px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7427","character":"","title":"Immune system","caption":"","caption-position":"bottom","content":"<p class=\"p1\">Drug discovery and drug development are complex and expensive endeavors undertaken</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"24px","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"7px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7428","character":"","title":"Antimalarial","caption":"","caption-position":"bottom","content":"<p class=\"p1\">Drug discovery and drug development are complex and expensive endeavors undertaken</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"24px","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"7px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7429","character":"","title":"Nutrition","caption":"","caption-position":"bottom","content":"<p class=\"p1\">Drug discovery and drug development are complex and expensive endeavors undertaken</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"arrow_right","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"24px","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"7px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"right","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7963","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"175px","right":"0px","bottom":"55px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"35px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Make an appointment","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We will send you a confirmation within 24 hours.<br /><strong><span style=\"color: #ffffff;\">Emergency?</span></strong> Call 1-2554-2356-33</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#9ebeff","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"5826","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#113989","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tab-feature3","value":{"id":"","class":"","tabs":[{"title":"Hospital Introduction","caption":"See Video Introduction","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo","content-background":"7933","content-background-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-1-1.jpg","content-left-title":"About Us","content-left-image":"7934","content-left-image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-1-2.jpg","content-right":"Historically, drugs were discovered through identifying the active ingredient from traditional remedies or by serendipitous discovery. Later chemical libraries of synthetic small molecules.\n[gdlr_core_space height=\"20px\"]\n<div style=\"color: #C4D8FF; font-size: 18px; line-height: 1.7;\">\nModern drug discovery involves the identification of screening hits, medicinal chemistry and optimization of those hits to increase the affinity, selectivity (to reduce the potential of side effects), efficacy/potency, metabolic stability (to increase the half-life), and oral bioavailability. Once a compound that fulfills all of these requirements.\n</div>\n[gdlr_core_space height=\"35px\"]\n[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_blank\" margin-right=\"20px\"  background-color=\"#4D93E9\" border-radius=\"3px\" icon-position=\"right\" icon=\"arrow_right\" icon-size=\"23px\" text-transform=\"none\" text-size=\"16px\" text-font-weight=\"600\" text-letter-spacing=\"0px\" padding=\"12px 24px 15px 30px\"]"},{"title":"Why Choose Us","caption":"Listen from real patients","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo","content-background":"7944","content-background-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-2-1.jpg","content-left-title":"Why Us","content-left-image":"7945","content-left-image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-2-2.jpg","content-right":"Historically, drugs were discovered through identifying the active ingredient from traditional remedies or by serendipitous discovery. Later chemical libraries of synthetic small molecules.\n[gdlr_core_space height=\"20px\"]\n<div style=\"color: #C4D8FF; font-size: 18px; line-height: 1.7;\">\nModern drug discovery involves the identification of screening hits, medicinal chemistry and optimization of those hits to increase the affinity, selectivity (to reduce the potential of side effects), efficacy/potency, metabolic stability (to increase the half-life), and oral bioavailability. Once a compound that fulfills all of these requirements.\n</div>\n[gdlr_core_space height=\"35px\"]\n[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_blank\" margin-right=\"20px\"  background-color=\"#4D93E9\" border-radius=\"3px\" icon-position=\"right\" icon=\"arrow_right\" icon-size=\"23px\" text-transform=\"none\" text-size=\"16px\" text-font-weight=\"600\" text-letter-spacing=\"0px\" padding=\"12px 24px 15px 30px\"]"},{"title":"Our innovation","caption":"Our dedicated research team","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo","content-background":"7946","content-background-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-3-1.jpg","content-left-title":"Our innovation","content-left-image":"7957","content-left-image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-3-2-1.jpg","content-right":"Historically, drugs were discovered through identifying the active ingredient from traditional remedies or by serendipitous discovery. Later chemical libraries of synthetic small molecules.\n[gdlr_core_space height=\"20px\"]\n<div style=\"color: #C4D8FF; font-size: 18px; line-height: 1.7;\">\nModern drug discovery involves the identification of screening hits, medicinal chemistry and optimization of those hits to increase the affinity, selectivity (to reduce the potential of side effects), efficacy/potency, metabolic stability (to increase the half-life), and oral bioavailability. Once a compound that fulfills all of these requirements.\n</div>\n[gdlr_core_space height=\"35px\"]\n[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_blank\" margin-right=\"20px\"  background-color=\"#4D93E9\" border-radius=\"3px\" icon-position=\"right\" icon=\"arrow_right\" icon-size=\"23px\" text-transform=\"none\" text-size=\"16px\" text-font-weight=\"600\" text-letter-spacing=\"0px\" padding=\"12px 24px 15px 30px\"]"},{"title":"Give Back","caption":"Donation programme","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo","content-background":"7950","content-background-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-4-1.jpg","content-left-title":"Give Back","content-left-image":"7956","content-left-image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/video-featured-4-2.jpg","content-right":"Historically, drugs were discovered through identifying the active ingredient from traditional remedies or by serendipitous discovery. Later chemical libraries of synthetic small molecules.\n[gdlr_core_space height=\"20px\"]\n<div style=\"color: #C4D8FF; font-size: 18px; line-height: 1.7;\">\nModern drug discovery involves the identification of screening hits, medicinal chemistry and optimization of those hits to increase the affinity, selectivity (to reduce the potential of side effects), efficacy/potency, metabolic stability (to increase the half-life), and oral bioavailability. Once a compound that fulfills all of these requirements.\n</div>\n[gdlr_core_space height=\"35px\"]\n[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_blank\" margin-right=\"20px\"  background-color=\"#4D93E9\" border-radius=\"3px\" icon-position=\"right\" icon=\"arrow_right\" icon-size=\"23px\" text-transform=\"none\" text-size=\"16px\" text-font-weight=\"600\" text-letter-spacing=\"0px\" padding=\"12px 24px 15px 30px\"]"}],"thumbnail-size":"full","height-before-content":"500px","height-before-bottom-gradient":"","tab-title-text":"","tab-caption":"","tab-title-background":"","tab-title-border":"","content-background":"#113989","video-icon":"","content-left-title":"","content-left-divider":"","content-right":"","tab-title-text-active":"","tab-caption-active":"","tab-title-background-active":"","tab-title-background-active-gradient":"","content-left-title-font-size":"","content-left-title-font-weight":"","content-font-size":"","content-font-weight":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"9","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7739","background-image-top-offset":"65px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"#7a7a7a","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"-202px","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Personnel"},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"33px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Doctors","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"fixed","side-border-alignment":"lower-right","side-border-width":"44px","side-border-size":"4px","side-border-spaces":"15px","side-border-radius":"2px","side-border-style":"solid","side-border-divider-color":"#d8d8d8","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#1c4ca5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See All Doctors","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"3px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#17449e","icon-color":"#17449e","text-hover-color":"","icon-hover-color":"","background-color":"#17449e","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"0px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"24px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"6","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid-with-background","always-show-overlay-content":"enable","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"enable","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","personnel-title-font-size":"20px","personnel-title-font-weight":"700","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"15px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"shadow-color":"#000000","shadow-opacity":"0.1","personnel-border-radius":"5px","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","padding-bottom":"40px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f5f5f5","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"150px","right":"0px","bottom":"215px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"130px","right":"","bottom":"165px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Certificates & Standards","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#1c4ca5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"12px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"44px","divider-border-radius":"2px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"50px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d8d8d8"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"1200px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"50px","bottom":"","left":"50px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"8000","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-1-2-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8001","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-2-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8002","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-3-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8003","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-4-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8004","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-5-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","border-radius":"","image-bottom-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1240px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"0px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-130px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Blockqoute"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"mobile","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"Height Qoute","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7740","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"unlink"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"-130px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height Qoute","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"5px","b-right":"0px","b-left":"0px","settings":"unlink"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"120px","right":"20px","bottom":"110px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"40px","bottom":"60px","left":"40px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"blockquote","value":{"id":"","class":"","content":"<p>Historically, drugs were discovered through identifying the active ingredient from traditional remedies or by serendipitous discovery. Later chemical libraries of synthetic small molecules.</p>","author":"Mildred Payne","author-position":"Allergist","text-align":"left","size":"medium","quote-size":"135px","quote-font-weight":"800","quote-height":"95px","content-size":"18px","content-font-weight":"400","content-font-style":"normal","content-letter-spacing":"0px","content-text-transform":"","author-size":"20px","author-font-weight":"700","author-font-style":"normal","position-size":"15px","position-font-weight":"400","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1240px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7765","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"0px","t-right":"0px","b-right":"5px","b-left":"5px","settings":"unlink"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"15px","bottom":"","left":"15px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height title","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"20px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Subscribe to our newsletter","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Community Memorial Hospital is the ONLY hospital in the state of New York to achieve One of Healthgrades America’s 100 Best Hospitals for Joint Replacement in 2016.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#9ebeff","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"90px","right":"20px","bottom":"50px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Blog Featured"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"4","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-widget","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-1","blog-image-style":"style-1","blog-widget-style":"style-2","blog-widget-with-feature":"enable","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Portfolio Side Description Large","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-size":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","blog-widget-column":"30","blog-widget-bottom-divider":"disable","item-size":"large","excerpt":"specify-number","excerpt-number":"55","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","tag"],"show-read-more":"enable","read-more-button-text":"","filterer-bottom-margin":"","blog-title-font-size":"","blog-title-font-weight":"","blog-title-letter-spacing":"","blog-title-text-transform":"none","category-background-color":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","blog-border-radius":"4px","blog-frame-border-size":"","blog-frame-border-color":"","blog-frame-hover-border-color":"","blog-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"17px","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"Recent News","caption":"","caption-position":"top","read-more-style":"with-border","read-more-text":"Read All News","read-more-link":"/mediz/hospital/blog-full-right-sidebar-with-frame/","read-more-target":"_self","title-size":"27px","title-font-weight":"700","title-letter-spacing":"0px","title-line-height":"","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#1c4ca5","caption-color":"","read-more-color":"#4d93e9","read-more-divider":"none","read-more-divider-color":"","title-wrap-bottom-margin":"40px","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Quick Links","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"fixed","side-border-alignment":"lower-right","side-border-width":"41px","side-border-size":"4px","side-border-spaces":"15px","side-border-radius":"2px","side-border-style":"solid","side-border-divider-color":"#d8d8d8","heading-tag":"h3","icon-font-size":"30px","title-font-size":"25px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#1c4ca5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Lumbar Discectomy","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/orthopaedic/lumbar-discectomy/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Endoscopy","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Elbow Arthroscopy","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/orthopaedic/knee-arthroscopy-2/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Colorectal","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/general-surgery/colorectal/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Knee Arthroscopy","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/orthopaedic/knee-arthroscopy/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Hemorrhoids","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/general-surgery/hemorrhoids/","link-target":"_self"}],"columns":"60","align":"left","enable-divider":"enable","icon-background":"none","icon-position":"right","icon-color":"#4d93e9","icon-background-color":"","content-color":"#4d93e9","caption-color":"","border-color":"#dedede","icon-size":"16px","content-size":"16px","content-font-weight":"400","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"14px","caption-font-weight":"","caption-text-transform":"none","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"5px","icon-right-margin":"","list-bottom-margin":"14px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Column SVC Bottom"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#113377","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"70px","bottom":"60px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7966","character":"","title":"Best Monitoring System","caption":"","caption-position":"bottom","content":"<p>Despite advances in technology and understanding of biological systems, drug discovery is still a lengthy, expensive.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"92px","character-width":"","title-top-padding":"10px","title-bottom-margin":"15px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#113377","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7829","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"70px","bottom":"60px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7967","character":"","title":"Advanced Operating Room","caption":"","caption-position":"bottom","content":"<p>Despite advances in technology and understanding of biological systems, drug discovery is still a lengthy, expensive.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"92px","character-width":"","title-top-padding":"10px","title-bottom-margin":"15px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#17449e","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"70px","bottom":"60px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7968","character":"","title":"Only Best Doctors","caption":"","caption-position":"bottom","content":"<p>Despite advances in technology and understanding of biological systems, drug discovery is still a lengthy, expensive.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"92px","character-width":"","title-top-padding":"10px","title-bottom-margin":"15px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7851","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"105px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonial","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#020202","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"850px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Mildred Payne","position":"Allergist","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7969","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-1.jpg","rating":""},{"title":"Mary Jane","position":"Patient","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7929","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-2.jpg","rating":""},{"title":"Paul Smith","position":"Patient","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7931","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-4.jpg","rating":""}],"style":"center","with-frame":"disable","column":"1","thumbnail-size":"thumbnail","enable-quote":"enable","left-quote-position":"left","quote-position":"top","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":" fa fa-long-arrow-left","carousel-navigation-right-icon":"fa fa-long-arrow-right","carousel-navigation-size":"40px","carousel-navigation-icon-color":"#17449e","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"-150px","carousel-nav-style":"gdlr-core-rectangle-style","carousel-bullet-style":"default","quote-size":"160px","quote-font-weight":"800","quote-height":"","quote-top-margin":"70px","quote-bottom-margin":"0px","title-size":"36px","title-text-transform":"none","title-font-weight":"700","title-letter-spacing":"0px","content-size":"21px","content-font-style":"italic","content-font-weight":"400","content-letter-spacing":"0px","name-size":"20px","name-font-weight":"700","name-letter-spacing":"0px","name-text-transform":"none","caption-size":"15px","position-font-style":"normal","position-font-weight":"400","rating-font-size":"","frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-border-radius":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-color":"#020202","caption-color":"","quote-color":"#17449e","content-color":"#7a7a7a","name-color":"#17449e","position-color":"#a2a2a2","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"20px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz A1 Column SVC"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp-2","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7592","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7593","character":"","title":"Get directions","caption":"Find us on map","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-font-weight":"600","caption-font-style":"italic","caption-text-transform":"","content-size":"19px","content-font-weight":"600","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp-2","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#113989","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7592","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7594","character":"","title":"Contact & Appointment","caption":"Send us an email","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-font-weight":"600","caption-font-style":"italic","caption-text-transform":"","content-size":"19px","content-font-weight":"600","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp-2","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7596","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7595","character":"","title":"Emergency Service","caption":"Call : +1-2345-3455-33","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-font-weight":"600","caption-font-style":"italic","caption-text-transform":"","content-size":"19px","content-font-weight":"600","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":"0px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]}]';
				case 'home-hospital2':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"2","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"9","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-210px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"unlink"},"hover-border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"border-color":"#efefef","hover-border-color":"#4cd4ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#111111","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"0px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#111111","frame-hover-shadow-opacity":"0.1","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8353","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Family Care","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our hospitals and physicians are bringing the best of community and academic medicine together as one.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"unlink"},"hover-border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"border-color":"#efefef","hover-border-color":"#4cd4ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#1111111","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"0px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#111111","frame-hover-shadow-opacity":"0.1","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8354","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Family Care","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our hospitals and physicians are bringing the best of community and academic medicine together as one.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"unlink"},"hover-border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"border-color":"#efefef","hover-border-color":"#4cd4ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#111111","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"0px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#111111","frame-hover-shadow-opacity":"0.1","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8355","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Family Care","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our hospitals and physicians are bringing the best of community and academic medicine together as one.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8388","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"60px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Hospital top liberty – free choice of doctors","caption":"Working together for a healthy life","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#4cd4ca","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>If you’re looking for a reliable health insurer with outstanding services and insurance solutions tailored to your require- ments,you need look no further than Medikal.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8397","character":"","title":"Hospital Private","caption":"Treatment by doctors and chiropractors.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"3px","bottom":"","left":"-31px"},"media-image-max-width":"","character-width":"","title-top-padding":"24px","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8398","character":"","title":"Health Insurance","caption":"Treatment by doctors and chiropractors.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"3px","bottom":"","left":"-31px"},"media-image-max-width":"","character-width":"","title-top-padding":"24px","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"0px","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8400","character":"","title":"Medical Private","caption":"Treatment by doctors and chiropractors.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"3px","bottom":"","left":"-31px"},"media-image-max-width":"","character-width":"","title-top-padding":"24px","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"-50px","bottom":"0px","left":"-50px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8395","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8371","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8389","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"170px","right":"0px","bottom":"145px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"120","animation-time":"4000","suffix":"+","divider":"disable","bottom-text":"Health Sections","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"","bottom-text-size":"24px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"400","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Professionals","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"","bottom-text-size":"24px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"2200","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Satisfied Patients","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"","bottom-text-size":"24px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"100","animation-time":"4000","suffix":"+","divider":"disable","bottom-text":"Health Plans","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"","bottom-text-size":"24px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"600px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Whatever your healthcare needs, we are here to help","caption":"We can provide health insurance certificates","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#4cd4ca","item-left-margin":"","caption-spaces":"15px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"3","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"load-more","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"modern","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","thumbnail-size":"Personnel Square","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"masonry","carousel-overflow":"","carousel-autoslide":"enable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"none","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","carousel-bullet-top-margin":"","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"uppercase","portfolio-tag-font-size":"","portfolio-tag-font-style":"","portfolio-tag-text-transform":"","portfolio-hover-title-font-size":"24px","portfolio-hover-title-font-weight":"600","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"portfolio-border-radius":"3px","portfolio-frame-border-size":"","portfolio-frame-border-color":"","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"0px","overlay-color":"","overlay-opacity":"","frame-shadow-size":{"x":"0px","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"#030f27","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f8faff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"600px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We make it faster, easier, and more enjoyable to get care","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We’ve positioned our beautiful offices near where you live, work, and travel. You can schedule same- or next-day appointments that start on time. Our appointments are longer, and you\'ll spend the whole time with an exceptional provider who really listens.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"50px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Medical Private","icon":"","percent":"90","bar-text":"90%"},{"heading-text":"Family Doctor","icon":"","percent":"70","bar-text":"70%"},{"heading-text":"Mental Health","icon":"","percent":"80","bar-text":"80%"},{"heading-text":"Cover Abroad","icon":"","percent":"90","bar-text":"90%"}],"heading-text-color":"","icon-color":"","percent-color":"","bar-filled-color":"#4cd4ca","bar-background-color":"#dddddd","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8388","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"-50px","bottom":"0px","left":"-50px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8410","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8371","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"icon green"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We’ll connect you to world-class specialists","caption":"We’ll help you manage a range of conditions","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#4cd4ca","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Wellness and prevention","content":"We’ll help you get healthy and stay that way with state-of-the art screening, disease prevention, and lifestyle advice.\n[gdlr_core_space height=\"15px\"]\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Sports medicine and exercise counseling\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Diet and nutrition counseling\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Contraception and family planning\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Cardiovascular disease screening\n"},{"head-text":"","title":"Everyday care","content":"We’ll help you get healthy and stay that way with state-of-the art screening, disease prevention, and lifestyle advice.\n[gdlr_core_space height=\"15px\"]\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Sports medicine and exercise counseling\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Diet and nutrition counseling\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Contraception and family planning\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Cardiovascular disease screening\n"},{"head-text":"","title":"Chronic conditions","content":"We’ll help you get healthy and stay that way with state-of-the art screening, disease prevention, and lifestyle advice.\n[gdlr_core_space height=\"15px\"]\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Sports medicine and exercise counseling\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Diet and nutrition counseling\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Contraception and family planning\n[gdlr_core_icon icon=\"icon-check\" size=\"16px\" color=\"8fe2db\" margin-left=\"\" margin-right=\"10px\" ] Cardiovascular disease screening\n"}],"active":"1","allow-closing-all-tabs":"disable","style":"icon","with-divider":"enable","align":"left","icon-position":"right","padding-bottom":"30px","title-font-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","title-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8412","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet our health professionals","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"6","filterer":"disable","filterer-color":"","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid","always-show-overlay-content":"enable","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","thumbnail-opacity":"","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","hover-content":"center","enable-hover-title":"disable","enable-hover-social":"disable","social-hover-color":"","enable-hover-excerpt":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"","personnel-title-font-size":"21px","personnel-title-font-weight":"700","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"18px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"shadow-size":{"x":"0px","y":"20px","size":"40px","settings":"unlink"},"shadow-color":"#030f27","shadow-opacity":"0.2","personnel-border-radius":"3px","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8391","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get started with <strong>Mediz today!</strong>","caption":"See how much better going to the doctor can be","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","mobile-title-font-size":"","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"#ffffff","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ffffff","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Sign Up Now","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"18px","right":"36px","bottom":"20px","left":"36px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#4cd4ca","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"","text-font-weight":"","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We have a variety of health plan types to meet your needs and budget","caption":"Know our plans and prices and choose the best option","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#4cd4ca","item-left-margin":"","caption-spaces":"15px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-table","value":{"id":"","class":"","style":"style-2","tabs":[{"price-tab":"","icon":"","image":"","image-img":"","title":"Personal","caption":"1 User","price":"29","content":"[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Primary care\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Emergency room\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] PHospital services\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-times\" size=\"16px\" color=\"#cccccc\" margin-left=\"\" margin-right=\"12px\" ] Annual eye exams\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-times\" size=\"16px\" color=\"#cccccc\" margin-left=\"\" margin-right=\"12px\" ] Dental implant\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-times\" size=\"16px\" color=\"#cccccc\" margin-left=\"\" margin-right=\"12px\" ] Diagnostic imaging\n\n\n","button-text":"Learn More","button-link":"#","button-link-target":"_self","feature-price":"disable"},{"price-tab":"","icon":"","image":"","image-img":"","title":"Business","caption":"2-3 Users","price":"59","content":"[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Primary care\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Emergency room\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] PHospital services\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Annual eye exams\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-times\" size=\"16px\" color=\"#cccccc\" margin-left=\"\" margin-right=\"12px\" ] Dental implant\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-times\" size=\"16px\" color=\"#cccccc\" margin-left=\"\" margin-right=\"12px\" ] Diagnostic imaging\n\n\n","button-text":"Learn More","button-link":"#","button-link-target":"_self","feature-price":"disable"},{"price-tab":"","icon":"","image":"","image-img":"","title":"Premium","caption":"6+ Users","price":"97","content":"[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Primary care\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Emergency room\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] PHospital services\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Annual eye exams\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Dental implant\n[gdlr_core_space height=\"12px\"]\n[gdlr_core_icon icon=\"fa fa-check\" size=\"16px\" color=\"#2ed47d\" margin-left=\"\" margin-right=\"12px\" ] Diagnostic imaging\n\n\n","button-text":"Learn More","button-link":"#","button-link-target":"_self","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","button-style":"","filter-border":"","filter-text":"","filter-active-bg":"","header-color":"","header-gradient-color":"","icon-color":"","title-color":"#4cd4ca","caption-color":"#7a7a7a","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"#ffffff","button-background-color":"#4cd4ca","button-background-gradient-color":"","shadow-size":{"x":"","y":"10px","size":"35px","settings":"unlink"},"shadow-color":"#0a0a0a","shadow-opacity":"0.09","a-header-color":"","a-header-gradient-color":"","a-icon-color":"","a-title-color":"","a-caption-color":"","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"","a-button-background-gradient-color":"","a-shadow-size":"","a-shadow-color":"","a-shadow-opacity":"0.2","button-align":"center","title-size":"27px","title-font-weight":"400","caption-size":"","caption-font-weight":"","padding-bottom":"30px"}}]},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See additional examples that may help you pick your plan","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]'; 
				case 'home-dentist': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#4d93e9","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"0","full-height":"disable","decrease-height":"0px","sync-height":"Height Mediz A1 Top","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7888","background-image-style":"no-repeat","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"35px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"90px","bottom":"120px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Story about our hospital","caption":"And how we get to this point","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#171717","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#4d93e9","item-left-margin":"","caption-spaces":"5px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>One of the first major discoveries relevant to the field of pulmonology was the discovery of pulmonary circulation. Originally, it was thought that blood reaching the right side of the heart passed through small \'pores\' in the septum.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#606060","margin-left":"","margin-right":"","padding-bottom":"33px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"7979","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"7453","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"195px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"5px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Founder of Mediz Hospital","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#505050","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"0","full-height":"disable","decrease-height":"0px","sync-height":"Height Mediz A1 Top","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7889","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"200px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f4f4f4","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"enable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"7892","container-background-image-opacity":"","container-padding":{"top":"55px","right":"50px","bottom":"105px","left":"50px","settings":"unlink"},"container-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"container-border-radius":{"t-left":"0px","t-right":"0px","b-right":"5px","b-left":"5px","settings":"unlink"},"container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"9","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"0px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"","bottom":"0px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"","bottom":"0px","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Dentist Column SVC"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"0","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8005","character":"","title":"General Dentistry","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as Dental and Oral Medicine, is a branch of medicine that consists.</p>","read-more-text":"Lear More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa5s fa5-long-arrow-alt-right","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"media-image-max-width":"65px","character-width":"","title-top-padding":"","title-bottom-margin":"13px","caption-top-margin":"","read-more-top-margin":"-5px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"0","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8006","character":"","title":"Orthodontics","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as Dental and Oral Medicine, is a branch of medicine that consists.</p>","read-more-text":"Lear More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa5s fa5-long-arrow-alt-right","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"media-image-max-width":"65px","character-width":"","title-top-padding":"","title-bottom-margin":"13px","caption-top-margin":"","read-more-top-margin":"-5px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"0","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8007","character":"","title":"Emergency","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as Dental and Oral Medicine, is a branch of medicine that consists.</p>","read-more-text":"Lear More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa5s fa5-long-arrow-alt-right","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"media-image-max-width":"65px","character-width":"","title-top-padding":"","title-bottom-margin":"13px","caption-top-margin":"","read-more-top-margin":"-5px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f4f4f4","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz A2 contact form"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8116","background-image-style":"no-repeat","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"30px","right":"60px","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Make an appointment","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#363636","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Complete the form and we will send you a confirmation within 24 hours.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#8e8e8e","margin-left":"","margin-right":"","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Or Call Us 1-2554-2356-33</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"20px","content-font-weight":"500","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#4d93e9","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Opening Hours","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#323232","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"opening-hours","value":{"id":"","class":"","tabs":[{"title":"Monday - Thursday","time":"08:00 - 20:00","open":"enable"},{"title":"Friday","time":"09:00 - 19:00","open":"enable"},{"title":"Saturday","time":"09:00 - 18:00","open":"enable"},{"title":"Sunday","time":"09:00 - 18:00","open":"enable"}],"divider-style":"solid","icon-position":"left","icon-style":"","icon":"","day-text-color":"#4d93e9","time-color":"#4d93e9","close-color":"","icon-color":"","divider-color":"#d0d0d0","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"5826","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7257","background-image-top-offset":"65px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz A2 Lung Diseases"},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Dental Services Provided","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"fixed","side-border-alignment":"lower-right","side-border-width":"44px","side-border-size":"4px","side-border-spaces":"15px","side-border-radius":"2px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d8d8d8","title-color":"#4d93e9","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"1px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/mediz/hospital/our-services/","button-link-target":"_self","icon-position":"none","icon":"arrow_right","text-align":"right","full-width-button":"disable","button-padding":{"top":"12px","right":"30px","bottom":"14px","left":"30px","settings":"unlink"},"border-radius":"31px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#4d93e9","background-hover-color":"","background-gradient-color":"#64c5ff","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"23px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"","bottom":"50px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8127","character":"","title":"General Dentistry","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as dental medicine and \'oral medicine, is a branch of medicine that consists of the study, diagnosis, prevention, and treatment.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"left_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"15px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"0px","right":"","bottom":"13px","left":""},"media-image-max-width":"90px","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"0px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#4d93e9","icon-color":"#4d93e9","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"14px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"","bottom":"50px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8128","character":"","title":"Orthodontics","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as dental medicine and \'oral medicine, is a branch of medicine that consists of the study, diagnosis, prevention, and treatment.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"left_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"15px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"0px","right":"","bottom":"13px","left":""},"media-image-max-width":"90px","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"0px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#4d93e9","icon-color":"#4d93e9","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"14px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"","bottom":"50px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8129","character":"","title":"Dental Implants ","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as dental medicine and \'oral medicine, is a branch of medicine that consists of the study, diagnosis, prevention, and treatment.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"left_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"15px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"0px","right":"","bottom":"13px","left":""},"media-image-max-width":"90px","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"0px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#4d93e9","icon-color":"#4d93e9","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"14px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"","bottom":"0px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8133","character":"","title":"Teeth Whitening","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as dental medicine and \'oral medicine, is a branch of medicine that consists of the study, diagnosis, prevention, and treatment.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"left_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"15px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"0px","right":"","bottom":"13px","left":""},"media-image-max-width":"90px","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"0px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#4d93e9","icon-color":"#4d93e9","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"14px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"","bottom":"0px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8134","character":"","title":"Cosmetic Dentistry","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as dental medicine and \'oral medicine, is a branch of medicine that consists of the study, diagnosis, prevention, and treatment.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"left_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"15px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"0px","right":"","bottom":"13px","left":""},"media-image-max-width":"90px","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"0px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#4d93e9","icon-color":"#4d93e9","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"14px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"","bottom":"0px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8132","character":"","title":"Gum Treatment","caption":"","caption-position":"bottom","content":"<p>Dentistry, also known as dental medicine and \'oral medicine, is a branch of medicine that consists of the study, diagnosis, prevention, and treatment.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"left_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"14px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"700","read-more-font-style":"normal","read-more-icon-font-size":"15px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"0px","right":"","bottom":"13px","left":""},"media-image-max-width":"90px","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"0px","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#4d93e9","icon-color":"#4d93e9","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"14px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7257","background-image-top-offset":"58px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"140px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Personal HP Dentist"},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Doctors","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"fixed","side-border-alignment":"lower-right","side-border-width":"44px","side-border-size":"4px","side-border-spaces":"15px","side-border-radius":"2px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d8d8d8","title-color":"#4d93e9","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"1px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Doctors","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/mediz/dentist/our-doctor/","button-link-target":"_self","icon-position":"none","icon":"arrow_right","text-align":"right","full-width-button":"disable","button-padding":{"top":"10px","right":"30px","bottom":"13px","left":"30px","settings":"unlink"},"border-radius":"31px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#4d93e9","background-hover-color":"","background-gradient-color":"#64c5ff","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"23px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"6","filterer":"disable","filterer-color":"","orderby":"date","order":"desc","text-align":"left","personnel-style":"grid","always-show-overlay-content":"enable","enable-position":"enable","disable-link":"disable","enable-divider":"enable","enable-excerpt":"disable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"enable","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-hover-title":"disable","enable-hover-social":"disable","enable-hover-excerpt":"disable","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"","personnel-title-font-size":"20px","personnel-title-font-weight":"700","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"15px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"shadow-color":"","shadow-opacity":"0.09","personnel-border-radius":"0px","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","padding-bottom":"40px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1240px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"9","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8207","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"45px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.27","padding":{"top":"70px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"-100px","right":"","bottom":"-100px","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Dentist Counter"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"200","animation-time":"","suffix":"","divider":"disable","bottom-text":"Doctors","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"29000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Happy Patients","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Medical Beds","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"150","animation-time":"","suffix":"","divider":"disable","bottom-text":"Winning Awards","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"39px","number-font-weight":"700","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f5f5f5","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"190px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"30px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Best of the best</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"14px","content-font-weight":"600","content-letter-spacing":"3px","content-text-transform":"uppercase","text-color":"#4d93e9","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"High End Equipments","caption":"Surgery of the respiratory tract is generally performed by specialists in cardiothoracic surgery (or thoracic surgery) though minor procedures may be performed by pulmonologists. Pulmonology is closely.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#171717","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#5f5f5f","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"rectangle","tabs":[{"heading-text":"Cardio-oncology","icon":"","percent":"100","bar-text":""},{"heading-text":"Heart assessment","icon":"","percent":"90","bar-text":""},{"heading-text":"Heart surgery","icon":"","percent":"80","bar-text":""},{"heading-text":"Rehabilitation and therapies","icon":"","percent":"80","bar-text":""}],"heading-text-color":"#181818","icon-color":"","percent-color":"#8e8e8e","bar-filled-color":"#4d93e9","bar-background-color":"#dcdcdc","padding-bottom":"50px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"11px","right":"30px","bottom":"13px","left":"30px","settings":"unlink"},"border-radius":"31px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"0px","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8157","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"7248","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f5f5f5","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"140px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"1200px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"55px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Certificates & Standards","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#4d93e9","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"12px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"44px","divider-border-radius":"2px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"50px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d8d8d8"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"1200px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"50px","bottom":"","left":"50px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"8000","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-1-2-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8001","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-2-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8002","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-3-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8003","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-4-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"8004","thumbnail":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/banner-5-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","border-radius":"","image-bottom-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Dentist Accordion"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"FAQ Height","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8170","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"240px","right":"340px","bottom":"240px","left":"340px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8169","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo","page-id":"8081","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"enable","max-width":"145px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"50px","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"FAQ Height","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8171","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"85px","right":"120px","bottom":"40px","left":"77px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Frequently Asked Questions","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"How much will my hospital stay cost?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."},{"head-text":"","title":"What if I have difficulty paying for my expenses?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."},{"head-text":"","title":"What happens to my admission?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."},{"head-text":"","title":"How do I use my Medisave to pay the hospital bill?","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar ksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows."}],"active":"1","allow-closing-all-tabs":"disable","style":"icon","with-divider":"enable","align":"left","icon-position":"left","padding-bottom":"0px","title-font-size":"17px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","title-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8172","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"70px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Services are internationally certified by the Joint Commission ","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"23px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"50px","divider-border-radius":"2px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"23px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#99c7ff"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>One of the first major discoveries relevant to the field of pulmonology was the discovery of pulmonary circulation. Originally, it was thought that blood reaching the right side of the heart passed through small</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#deedff","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Book Online","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"icon-note","text-align":"left","full-width-button":"enable","button-padding":{"top":"21px","right":"33px","bottom":"25px","left":"25px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#25478b","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"14px","text-font-weight":"600","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"15px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"5px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Send Us A Message","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"icon-paper-plane","text-align":"left","full-width-button":"enable","button-padding":{"top":"21px","right":"33px","bottom":"25px","left":"25px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#2f62c7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"14px","text-font-weight":"600","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"15px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"5px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Emergency","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"icon-phone","text-align":"left","full-width-button":"enable","button-padding":{"top":"21px","right":"33px","bottom":"25px","left":"25px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ba261f","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"14px","text-font-weight":"600","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"15px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-news","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"left","background-color":"#f6f6f6","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"25px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Quick Links","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"fixed","side-border-alignment":"lower-right","side-border-width":"41px","side-border-size":"4px","side-border-spaces":"15px","side-border-radius":"2px","side-border-style":"solid","side-border-divider-color":"#d8d8d8","heading-tag":"h3","icon-font-size":"30px","title-font-size":"25px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#212121","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Critical care and anaesthesia","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/orthopaedic/lumbar-discectomy/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Cancer services","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Rehabilitation and therapies","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/orthopaedic/knee-arthroscopy-2/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Laboratories","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/orthopaedic/knee-arthroscopy/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Non-clinical teams","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/general-surgery/colorectal/","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-long-arrow-right","icon-hover":"","title":"Heart assessment","caption":"","link-url":"https://demo.goodlayers.com/mediz/hospital/our-services/general-surgery/hemorrhoids/","link-target":"_self"}],"columns":"60","align":"left","enable-divider":"enable","icon-background":"none","icon-position":"right","icon-color":"#4d93e9","icon-background-color":"","content-color":"#4d93e9","caption-color":"","border-color":"#dedede","icon-size":"16px","content-size":"16px","content-font-weight":"400","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"14px","caption-font-weight":"","caption-text-transform":"none","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"5px","icon-right-margin":"","list-bottom-margin":"14px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-news","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"50px","left":"34px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Blog Featured"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"4","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-widget","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-1","blog-image-style":"style-1","blog-widget-style":"style-2","blog-widget-with-feature":"enable","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Portfolio Side Description Large","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-size":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","carousel-bullet-top-margin":"","blog-widget-column":"30","blog-widget-bottom-divider":"disable","item-size":"large","excerpt":"specify-number","excerpt-number":"55","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","tag"],"show-read-more":"enable","read-more-button-text":"","filterer-bottom-margin":"","blog-title-font-size":"","blog-title-font-weight":"","blog-title-letter-spacing":"","blog-title-text-transform":"none","category-background-color":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","blog-border-radius":"4px","blog-frame-border-size":"","blog-frame-border-color":"","blog-frame-hover-border-color":"","blog-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"17px","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"Recent News","caption":"","caption-position":"top","read-more-style":"with-border","read-more-text":"Read All News","read-more-link":"/mediz/hospital/blog-full-right-sidebar-with-frame/","read-more-target":"_self","title-size":"27px","title-font-weight":"700","title-letter-spacing":"0px","title-line-height":"","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#212121","caption-color":"","read-more-color":"#4d93e9","read-more-divider":"none","read-more-divider-color":"","title-wrap-bottom-margin":"40px","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8173","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"inner-border","border-pre-spaces":{"top":"55px","right":"52px","bottom":"55px","left":"52px","settings":"unlink"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#5d7ca1","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"105px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonial","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"850px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Mildred Payne","position":"Allergist","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7969","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-1.jpg","rating":""},{"title":"Mary Jane","position":"Patient","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7929","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-2.jpg","rating":""},{"title":"Paul Smith","position":"Patient","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.","image":"7931","image-img":"https://demo.goodlayers.com/mediz/hospital/wp-content/uploads/sites/2/2019/12/testimonial-4.jpg","rating":""}],"style":"center","with-frame":"disable","column":"1","thumbnail-size":"thumbnail","enable-quote":"enable","left-quote-position":"left","quote-position":"top","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":" fa fa-long-arrow-left","carousel-navigation-right-icon":"fa fa-long-arrow-right","carousel-navigation-size":"40px","carousel-navigation-icon-color":"#4d93e9","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"-150px","carousel-nav-style":"gdlr-core-rectangle-style","carousel-bullet-style":"default","carousel-bullet-top-margin":"","quote-size":"0px","quote-font-weight":"800","quote-height":"","quote-top-margin":"70px","quote-bottom-margin":"0px","title-size":"36px","title-text-transform":"none","title-font-weight":"700","title-letter-spacing":"0px","content-size":"21px","content-font-style":"italic","content-font-weight":"400","content-letter-spacing":"0px","name-size":"20px","name-font-weight":"700","name-letter-spacing":"0px","name-text-transform":"none","caption-size":"15px","position-font-style":"normal","position-font-weight":"400","rating-font-size":"","frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-border-radius":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-color":"#ffffff","caption-color":"","quote-color":"","content-color":"#ffffff","name-color":"#ffffff","position-color":"#aad0ff","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"20px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Mediz A1 Column SVC"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp-2","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8176","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7593","character":"","title":"Get directions","caption":"121 King St. Bermington New York","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-font-weight":"600","caption-font-style":"italic","caption-text-transform":"","content-size":"19px","content-font-weight":"600","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp-2","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#4d93e9","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7592","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7594","character":"","title":"Contact & Appointment","caption":"Send us an email","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-font-weight":"600","caption-font-style":"italic","caption-text-transform":"","content-size":"19px","content-font-weight":"600","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"col-features-hp-2","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8177","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"7595","character":"","title":"Emergency Service","caption":"Call : +1-2345-3455-33","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-font-weight":"600","caption-font-style":"italic","caption-text-transform":"","content-size":"19px","content-font-weight":"600","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":"0px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"1","wpgmap2-id":"","padding-bottom":"0px"}}]}]';
				case 'home-dentist2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#2b2b2b","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"645px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our waiting rooms and treatment areas are kid-friendly","caption":"We respect each and every patient","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8281","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.12","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"4px","left":"","settings":"unlink"},"border-color":"#ffffff","hover-border-color":"#5170ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"0px","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8271","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Dental Implants","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We treat our patients like family. We do everything we can to make your visit comfortable and hassle-free.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"4px","left":"","settings":"unlink"},"border-color":"#ffffff","hover-border-color":"#5170ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8272","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"General Dentistry","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We treat our patients like family. We do everything we can to make your visit comfortable and hassle-free.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"border-color":"#ffffff","hover-border-color":"#5170ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8273","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Cosmetic Dentistry","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We treat our patients like family. We do everything we can to make your visit comfortable and hassle-free.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"border-color":"#ffffff","hover-border-color":"#5170ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8276","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Teeth Whitening","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We treat our patients like family. We do everything we can to make your visit comfortable and hassle-free.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"border-color":"#ffffff","hover-border-color":"#5170ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8277","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Orthodontics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We treat our patients like family. We do everything we can to make your visit comfortable and hassle-free.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"0px","right":"0px","bottom":"4px","left":"0px","settings":"unlink"},"border-color":"#ffffff","hover-border-color":"#5170ca","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"45px","right":"20px","bottom":"35px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8278","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Gum Treatment","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We treat our patients like family. We do everything we can to make your visit comfortable and hassle-free.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"15px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f8faff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"about-height","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8282","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"350px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"about-height","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"50px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"65px","right":"","bottom":"15px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Your guide to a healthy and beautiful smile","caption":"More than ever, a beautiful smile opens doors","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We offer custom care for every patient. We equip our patients with the knowledge and tools they need to create healthy habits and prevent decay and other complications.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8284","character":"","title":"Comfortable Facilities","caption":"We understand every aspect of your care.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"3px","bottom":"","left":"-31px"},"media-image-max-width":"","character-width":"","title-top-padding":"24px","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8284","character":"","title":"Comprehensive Care","caption":"We understand every aspect of your care.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"3px","bottom":"","left":"-31px"},"media-image-max-width":"","character-width":"","title-top-padding":"24px","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8284","character":"","title":"Healthy Smiles","caption":"We understand every aspect of your care.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"3px","bottom":"","left":"-31px"},"media-image-max-width":"","character-width":"","title-top-padding":"24px","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"about-height","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"120px","right":"90px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We accept most insurance, including private plans","caption":"A lifetime of dental health begins now","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We believe that everyone should have access to affordable dental care. Our staff will help you address any financial concerns. Contact our office to learn more about payment options. We accept most insurance, including private plans, Medicare, and more.</p><p>We help patients of all ages take charge of their health, but we are especially committed to helping young patients learn about and practice proper dental hygiene for a lifetime of smiles.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"18px","right":"36px","bottom":"20px","left":"36px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"","text-font-weight":"","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"about-height","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"-70px","bottom":"0px","left":"-70px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8286","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8287","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Creating the <strong>healthy smile</strong> you want","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","mobile-title-font-size":"30px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"25px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"skill-circle","value":{"id":"","class":"","item-size":"custom","item-width":"200px","line-width":"18","heading-text":"","percent":"60","bar-text":"","item-align":"center","skill-circle-width":"","side-description-title":"","side-description-text":"","heading-text-color":"#ffffff","text-color":"#ffffff","bar-filled-color":"#4cd4ca","bar-background-color":"#748dd3","circle-background-color":"","side-description-title-color":"","side-description-text-color":"","heading-text-font-size":"40px","heading-text-font-weight":"400","bar-text-font-size":"","bar-text-font-weight":"","side-description-title-font-size":"","side-description-title-font-weight":"","side-description-text-font-size":"","side-description-text-font-weight":"","side-description-title-top-margin":"","side-description-title-bottom-margin":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Implants","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"25px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"skill-circle","value":{"id":"","class":"","item-size":"custom","item-width":"200px","line-width":"18","heading-text":"","percent":"70","bar-text":"","item-align":"center","skill-circle-width":"","side-description-title":"","side-description-text":"","heading-text-color":"#ffffff","text-color":"#ffffff","bar-filled-color":"#4cd4ca","bar-background-color":"#748dd3","circle-background-color":"","side-description-title-color":"","side-description-text-color":"","heading-text-font-size":"40px","heading-text-font-weight":"400","bar-text-font-size":"","bar-text-font-weight":"","side-description-title-font-size":"","side-description-title-font-weight":"","side-description-text-font-size":"","side-description-text-font-weight":"","side-description-title-top-margin":"","side-description-title-bottom-margin":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Whitening","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"25px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"skill-circle","value":{"id":"","class":"","item-size":"custom","item-width":"200px","line-width":"18","heading-text":"","percent":"80","bar-text":"","item-align":"center","skill-circle-width":"","side-description-title":"","side-description-text":"","heading-text-color":"#ffffff","text-color":"#ffffff","bar-filled-color":"#4cd4ca","bar-background-color":"#748dd3","circle-background-color":"","side-description-title-color":"","side-description-text-color":"","heading-text-font-size":"40px","heading-text-font-weight":"400","bar-text-font-size":"","bar-text-font-weight":"","side-description-title-font-size":"","side-description-title-font-weight":"","side-description-text-font-size":"","side-description-text-font-weight":"","side-description-title-top-margin":"","side-description-title-bottom-margin":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Cosmetic","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"skill-circle","value":{"id":"","class":"","item-size":"custom","item-width":"200px","line-width":"18","heading-text":"","percent":"90","bar-text":"","item-align":"center","skill-circle-width":"","side-description-title":"","side-description-text":"","heading-text-color":"#ffffff","text-color":"#ffffff","bar-filled-color":"#4cd4ca","bar-background-color":"#748dd3","circle-background-color":"","side-description-title-color":"","side-description-text-color":"","heading-text-font-size":"40px","heading-text-font-weight":"400","bar-text-font-size":"","bar-text-font-weight":"","side-description-title-font-size":"","side-description-title-font-weight":"","side-description-text-font-size":"","side-description-text-font-weight":"","side-description-title-top-margin":"","side-description-title-bottom-margin":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Brackets","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"650px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"15px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We provide quality dental care for the entire family","caption":"We accept all forms of payment including most insurance plans","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"load-more","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"modern-desc","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"fitrows","carousel-overflow":"","carousel-autoslide":"enable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","carousel-bullet-top-margin":"","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"uppercase","portfolio-tag-font-size":"","portfolio-tag-font-style":"","portfolio-tag-text-transform":"","portfolio-hover-title-font-size":"24px","portfolio-hover-title-font-weight":"500","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"portfolio-border-radius":"5px","portfolio-frame-border-size":"","portfolio-frame-border-color":"","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"30px","overlay-color":"","overlay-opacity":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f8faff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8289","background-image-top-offset":"30px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.08","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"85px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8288","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo&feature=emb_title","page-id":"4","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom-image","overlay-icon-style":"always-show-2","overlay-icon":"fa fa-android","overlay-image":"8290","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"custom","overlay-icon-size-custom":"120px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"30px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Call us today to schedule an appointment","caption":"Excellent smiles happen here","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We help patients of all ages take charge of their health, but we are especially committed to helping young patients learn about and practice proper dental hygiene for a lifetime of smiles. Convenient payment options are also available.</p><p>With our financing and payment options, you can get the dental care you need even when you don\'t have the necessary funds.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#545454","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Request an Appointment","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"#7489c9","icon-hover-color":"#7489c9","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"","text-font-weight":"600","text-letter-spacing":"","text-transform":"","icon-size":"19px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"6px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8291","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.08","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get started with <strong>Mediz today!</strong>","caption":"Meet the professional dental team","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","mobile-title-font-size":"","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"#ffffff","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ffffff","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Contact Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"18px","right":"36px","bottom":"20px","left":"36px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#5170ca","icon-color":"#5170ca","text-hover-color":"","icon-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"","text-font-weight":"","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"80px"}},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"#","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#f45674","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Emergency","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"18px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"#","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#4cd4ca","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Doctors Timetable","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"18px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"#","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#8a89c0","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Opening Hours","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"18px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"1 800 946 2700","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon-screen-smartphone","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"div","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#f45674","title-color":"#f45674","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"-3px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Most oral emergencies relate to pain, bleeding, or orofacial trauma and should be attended by a dental practitioner.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"212-946-2707","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon-screen-smartphone","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"div","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#5170ca","title-color":"#5170ca","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"-3px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our doctors usually work on regular days and <a href=\"#\" style=\"color: #5170ca; text-decoration: underline; \">here</a> is a timetable showing when they are usually available.</p>\n","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"opening-hours","value":{"id":"","class":"","tabs":[{"title":"Monday - Friday","time":"8.00am - 6.00pm","open":"enable"},{"title":"Saturday","time":"9.00am - 5.00pm","open":"enable"},{"title":"Sunday","time":"9.00am - 3.00pm","open":"enable"}],"divider-style":"solid","icon-position":"right","icon-style":"none","icon":"","day-text-color":"#222222","time-color":"#5170ca","close-color":"","icon-color":"","divider-color":"#ebebeb","padding-bottom":"30px"}}]}]}]';
				case 'home-beauty-clinic':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8402","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"240px","right":"","bottom":"150px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-padding":{"top":"100px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"100px","bottom":"200px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"8403","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=KAvQsRL-jeo","page-id":"8371","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"120px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"High-quality skin care products","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We use the most efficacious, natural and innovative active ingredients from around the world.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"500","content-letter-spacing":"","content-text-transform":"none","text-color":"#0a2f53","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-arrow-right-c","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"2px","border-on-text-top-margin":"0px","text-color":"#d87290","icon-color":"#d87290","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"13px","button2-left-margin":"0px","item-top-margin":"0px","padding-bottom":"5px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"40px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d87290"}}]},{"template":"wrapper","type":"column","column":"30"},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"custom","custom-shape":"8439","inverted":"disable","flip":"disable","vflip":"disable","opacity":"","color":"","width":"110","height":"","hide-this-item-in":"none"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"A blessing of water for every skin","caption":"Clinically proven results","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"300px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"with-icon","icon-type":"image","image":"8381","icon":"fa fa-bath","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"icon-emotsmile","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"","divider-border-radius":"0px","margin-top":"0px","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"40px","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d87290"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"65px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Medikal was created in 1989 with a focus on France’s hydration driven beauty rituals. Medikal concentrates on the core elements of skincare to combine an authentically French minimalist philosophy and powerful ingredients backed by science. Our own patented fermentation technology to produce hyaluronic acid from lactic acid bacteria.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>In 1989, we applied our own science to skin care to create Medikal using D.P.H.A.™ as the core ingredient to hydrate skin for a healthy, luminous complexion. Every product contains D.P.H.A.™ as a potent source of hydration and to make your skin softer and more supple.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"8374","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"8371","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"140px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"10px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Stella Smith","caption":"CEO & Co-Founder","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"divider","left-icon":"fa fa-gear","left-image":"","left-divider-size":"3px","left-divider-margin":"8px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column SVC  Skin Care"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"beauty height","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8375","background-image-style":"cover","background-image-position":"center-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"beauty height","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#fdf5f4","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"95px","right":"200px","bottom":"80px","left":"110px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Relieving dryness with a gentle touch","caption":"Bring balance to your skin and life","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#636363","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8396","character":"","title":"Our Philosophy","caption":"","caption-position":"bottom","content":"<p>A blessing of water for every skin. Relieving dryness with a gentle touch.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"0px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"-18px","right":"-7px","bottom":"","left":"-30px"},"media-image-max-width":"134px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8397","character":"","title":"Our History","caption":"","caption-position":"bottom","content":"<p>A blessing of water for every skin. Relieving dryness with a gentle touch.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"-18px","right":"-10px","bottom":"","left":"-30px"},"media-image-max-width":"134px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8398","character":"","title":"Our Ingredients","caption":"","caption-position":"bottom","content":"<p>A blessing of water for every skin. Relieving dryness with a gentle touch.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"30px","title-size":"20px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"-18px","right":"-10px","bottom":"","left":"-30px"},"media-image-max-width":"134px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"An ethical and natural skincare brand","caption":"Our products are free of synthetic fragrances","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"300px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"with-icon","icon-type":"image","image":"8381","icon":"fa fa-bath","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"icon-emotsmile","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"","divider-border-radius":"0px","margin-top":"0px","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"40px","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d87290"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Product Skin"},"items":[{"template":"element","type":"product","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","stock-status":"all","orderby":"date","order":"desc","product-style":"grid-2","button-style":"plain","button-border-color":"","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"carousel","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-bullet-style":"round gdlr-core-color-bullet","pagination":"none","pagination-style":"default","pagination-align":"default","product-title-font-size":"18px","product-title-font-weight":"600","product-title-letter-spacing":"0px","product-title-text-transform":"none","frame-border-size":"","frame-border-color":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#fdf5f4","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height  macro beauty","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#fdf5f4","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"95px","right":"100px","bottom":"145px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Inspired by the authentic japanese philosophy","caption":"Macro molecule sodium hyaluronate processed","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>High-quality and high-purity macro molecule sodium hyaluronate processed with our own patented technology. Since its proprietary, our products are formulated with generous amount of hyaluronic acid to make your skin truly hydrated.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"","icon-hover":"","title":"01. Glycerin","caption":"Similar to our skin’s natural sebum.","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"02. Jojoba","caption":"Similar to our skin’s natural sebum.","link-url":"","link-target":"_self"}],"columns":"30","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"","icon-background-color":"","content-color":"#0a2f53","caption-color":"#373737","border-color":"","icon-size":"14px","content-size":"18px","content-font-weight":"600","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"18px","caption-font-weight":"400","caption-text-transform":"none","caption-letter-spacing":"0px","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#d87290","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height  macro beauty","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"right","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8387","background-image-style":"cover","background-image-position":"center-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"The most gentle skin care ingredients","caption":"Clinically proven results","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"300px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"with-icon","icon-type":"image","image":"8381","icon":"fa fa-bath","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"icon-emotsmile","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"","divider-border-radius":"0px","margin-top":"0px","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"40px","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d87290"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column SVCn Line"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"1px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"15px","right":"10px","bottom":"40px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8389","character":"","title":"Natural Ingredients","caption":"","caption-position":"bottom","content":"<p>Cleansing of the skin is of great importance and an integral part of the daily process of care.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"50","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"media-image-max-width":"50px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"1px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"15px","right":"10px","bottom":"40px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8390","character":"","title":"Organic Products","caption":"","caption-position":"bottom","content":"<p>Cleansing of the skin is of great importance and an integral part of the daily process of care.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"50px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"media-image-max-width":"50px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"1px","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"15px","right":"10px","bottom":"40px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8391","character":"","title":"Safe Formulations","caption":"","caption-position":"bottom","content":"<p>Cleansing of the skin is of great importance and an integral part of the daily process of care.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"50px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"media-image-max-width":"50px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"10px","bottom":"10px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8392","character":"","title":"Cosmeceutical Result","caption":"","caption-position":"bottom","content":"<p>Cleansing of the skin is of great importance and an integral part of the daily process of care.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"50px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"media-image-max-width":"50px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"1px","bottom":"","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"10px","bottom":"10px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8393","character":"","title":"Bioactive Ingredients","caption":"","caption-position":"bottom","content":"<p>Cleansing of the skin is of great importance and an integral part of the daily process of care.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"50px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"media-image-max-width":"50px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"","left":"0px","settings":"unlink"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"10px","bottom":"10px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"8394","character":"","title":"All-natural Skincare","caption":"","caption-position":"bottom","content":"<p>Cleansing of the skin is of great importance and an integral part of the daily process of care.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-arrow-right","style":"left_icon-left","icon-size":"50px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"20px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"media-image-max-width":"50px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#fdf5f4","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"220px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"100% naturally derived and packed full of innovative, tropical ingredients","caption":"Give yourself the gift of glowing skin","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a1a1a1","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"22px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our skincare range is tailor-made so that, whatever your complexion, nourishing plant extracts work in harmony to feed, protect and rejuvenate your skin.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-185px","right":"","bottom":"-185px","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#dddddd","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8399","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.05","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"170px","right":"0px","bottom":"175px","left":"0px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Certified Nontoxic","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#dddddd","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8400","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.05","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"170px","right":"0px","bottom":"175px","left":"0px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Clinically Proven","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#dddddd","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"8401","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"40px","settings":"unlink"},"background-shadow-color":"#030f27","background-shadow-opacity":"0.05","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"170px","right":"0px","bottom":"175px","left":"0px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Sustainably Made","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"270px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"The only natural skincare that actually works","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#0a2f53","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Whether you\'re seeking skincare advice, need help tracking an order, or just have a quick question, the True Team is here to help—every step of the way.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"500","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Contact Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#d87290","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]}]';
				case 'about-us': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7978","background-image-top-offset":"","background-image-bottom-offset":"40px","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"155px","right":"0px","bottom":"225px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"95px","right":"","bottom":"165px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Us","caption":"Story about our hospital","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"65px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#bbd1ff","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1240px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"-112px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"Height Mediz A1 Top","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"7461","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"4px","t-right":"0px","b-right":"0px","b-left":"4px","settings":"unlink"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"Height Mediz A1 Top","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"4px","b-right":"4px","b-left":"0px","settings":"unlink"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"73px","right":"45px","bottom":"70px","left":"50px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"30px","bottom":"55px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Story about our hospital","caption":"And how we get to this point","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#171717","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#17449e","item-left-margin":"","caption-spaces":"5px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>One of the first major discoveries relevant to the field of pulmonology was the discovery of pulmonary circulation. Originally, it was thought that blood reaching the right side of the heart passed through small \'pores\' in the septum.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"15px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#606060","margin-left":"","margin-right":"","padding-bottom":"33px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"7979","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"7453","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"195px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"5px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Founder of Mediz Hospital","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#5e5e5e","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-ima