<?php 
	/*	
	*	Goodlayers Getting Start Page
	*	---------------------------------------------------------------------
	*	This file that creates getting start page
	*	---------------------------------------------------------------------
	*/	

	if( class_exists('gdlr_core_getting_start') ){
		new gdlr_core_getting_start(array(
			'parent-slug' => 'goodlayers_main_menu',
			'page-title' => esc_html__('Getting Start / Import', 'mediz'),
			'menu-title' => esc_html__('Getting Start / Import', 'mediz'),
			'capability' => 'edit_theme_options'
		));
	}

	add_filter('gdlr_core_getting_start_option', 'mediz_gdlr_core_getting_start_option', 10, 2);
	if( !function_exists('mediz_gdlr_core_getting_start_option') ){
		function mediz_gdlr_core_getting_start_option( $options, $slug ){
			if( $slug == 'gdlr_core_getting_start' ){

				$content = array();

				// install plugins link
				$plugins_complete = mediz_tgmpa_complete();
				if( !$plugins_complete ){
					$content['required-plugins'] = array(
						'title' => esc_html__('Required Plugins', 'mediz'),
						'type' => 'page',
						'content' => '<p>' . wp_kses(__('<strong>Before moving on, please make sure that all required plugins are installed and activated</strong><br>This is very important step to make the theme run properly.', 'mediz'), array('strong'=>array(), 'br'=>array()) ) . 
							'</p><a class="gdlr-core-button" href="' . esc_attr(admin_url('themes.php?page=tgmpa-install-plugins')) . '" >' . esc_html__('Install Required Plugins', 'mediz') . '</a>' .
							'<h3>' . esc_html__('1. Install plugins then click on \'Return To Require Plugins Installer', 'mediz') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin1.jpg') . '" alt="mediz" />' .
							'<h3>' . esc_html__('2. Activate plugins', 'mediz') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin2.jpg') . '" alt="' . esc_attr__('Required Plugin', 'mediz') . '" />'
					);
				}

				// guidelines
				$content['guidelines'] = array(
					'title' => esc_html__('Guidelines', 'mediz'),
					'type' => 'page',
					'content' => 
						wp_kses(__('<h4>1.) Installation</h4>', 'mediz'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/q5RxycDNzX8" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>' .
						wp_kses(__('<h4>2.) Importing Demo</h4>', 'mediz'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/Lr990xdavHk" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>' .
						wp_kses(__('<h4>3.) Creating Portfolio</h4>', 'mediz'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/XFrtHJuPW_4" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>4.) Creating Personnel</h4>', 'mediz'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/MwFxxSlYuAA" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>5.) Creating Blog</h4>', 'mediz'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/fqcdMzTjvrE" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>6.) Goodlayers Page Builder</h4>', 'mediz'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/N0haJbDM8ac" frameborder="0" allowfullscreen></iframe>'
				);

				// import demo
				$content['import-demo'] = array(
					'title' => esc_html__('Import Demo', 'mediz'),
					'type' => 'demo',
					'content' => wp_kses(__('<strong>Get import error?</strong> Please make sure that your server has PHP max_execution_time at least 300, memory_limit at least 512MB. You may set these values temporaly and change it back after finish importing.<br><strong>If you\'re importing main demo (Full Version), PHP max_input_vars is recommended to be at least 4000</strong>', 'mediz'), array('strong'=>array(), 'br'=>array())),
					'demo-content' => wp_kses(
						__('<strong>Main demo (Full verion)</strong> - include all pages shown in demo such as elements, features, about us, services contact, all portfolio pages, all blog pages. It\'s 100+ pages and 170+ images in total.', 'mediz') . '<br><br>' . 
						__('<strong>Main demo (Lite verion)</strong> - include about us, services, few portfolios, few blog pages. Element and feature page are not included.', 'mediz') . '<br><br>' . 
						__('Please also be cautious that over 1000+ images will be generated in main demo.', 'mediz'), 
						array('strong'=>array(), 'br'=>array())),
				);

				// system status
				$content['system-status'] = array(
					'title' => esc_html__('System Status', 'mediz'),
					'type' => 'system-status',
					'content' => wp_kses(__('<strong>To import demo content</strong>, PHP max_execution_time at least 300 secs and  memory_limit at least 512MB is recommended. <strong><br>If you\'re importing main demo (Full Version)</strong>, PHP max_input_vars is recommended to be at least 4000.', 'mediz'), array('strong'=>array(), 'br'=>array()))
				);

				// obtain product validation link
				if( !empty($GLOBALS['tgmpa']) ){
					$plugin_slug = 'envato-market';
					$plugin_url = 'admin.php?page=envato-market';
					$product_validation_url = mediz_tgmpa_auto_install_url($plugin_slug,  $plugin_url);

					$tgmpa = call_user_func(array(get_class($GLOBALS['tgmpa']), 'get_instance'));
					if( !$tgmpa->is_plugin_installed($plugin_slug) ){
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'mediz'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates, you need to install and activate the plugin \'Envato Market\'</strong>.<br>You\'ll also need API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'mediz'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Get envato market plugin now!', 'mediz') . '</a>'
						);
					}else{
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'mediz'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates</strong>, you need to fill the infomation in \'Envato Market\' plugin page.<br>You need to retrieve API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'mediz'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Go to plugin settings!', 'mediz') . '</a>'
						);
					}
				}

				// support
				$content['support'] = array(
					'title' => esc_html__('Support', 'mediz'),
					'type' => 'page',
					'content' => wp_kses(__('<p><strong>Have questions about how to use the theme?</strong></p><p>Make sure that you read all through the document we provided. The document is contained in main package that you downloaded from Themeforest. It\'s in the folder \'Document-Instruction\', open the file \'index.html\' with your browser. Or you can view online document here.</p>', 'mediz'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
						'<a class="gdlr-core-button" target="_blank" href="#" >' . esc_html__('View Online Document', 'mediz') . '</a><br><br>' .
						wp_kses(__('<p><strong>Have problems or can\'t find answer in the document?</strong></p><p>1. Make sure that you are running the latest version of the theme.<br>2. Make sure that you deeply checked theme\'s instruction and try to search for public tickets in case of someone else asked the same question before. <br> 3. Try to deactivate all plugins (Except Goodlayers plugins) and see if the problem resolved or not.</p>', 'mediz'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) .
						wp_kses(sprintf(__('<p>After doing these steps and still see the problem, feel free to submit tickets in our support website. Our supporter are happy to help you.<br><strong>Please note that you will need Purchase code to submit the ticket</strong> - <a href="%s" target="_blank" >How to get purchased code?</a></p>', 'mediz'), 'https://help.market.envato.com/hc/en-us/articles/202822600'), array('strong'=>array(), 'br'=>array(), 'p'=> array(), 'a'=>array('href'=>array(), 'target'=>array())) ) .
						'<a class="gdlr-core-button" target="_blank" href="http://support.goodlayers.com" >' . esc_html__('Go to support website', 'mediz') . '</a>'
				);

				return array(
					'header' => array(
						'logo' => get_template_directory_uri() . '/images/getting-start/header.png',
						'title' => esc_html__('Congratulations !', 'mediz'),
						'caption' => '<strong>' . esc_html__('Mediz', 'mediz') . '</strong> ' . esc_html__('WordPress theme is now installed and ready to use. Thank you so much for choosing Goodlayers!', 'mediz')
					),
					'content' => $content
				);
			}

			return $options;
		}
	}

	// add filter for demo import
	add_filter('gdlr_core_demo_options', 'mediz_gdlr_core_demo_options');
	if( !function_exists('mediz_gdlr_core_demo_options') ){
		function mediz_gdlr_core_demo_options($demo){
			return array(
				'hospital' => array(
					'title' => esc_html__('Hospital', 'mediz'),
					'url' => 'https://demo.goodlayers.com/mediz/hospital/',
					'xml' => get_template_directory() . '/admin/function/files/hospital.xml',
					'page' => 7684,
					'menu' => array('main_menu' => 27, 'mobile_menu' => 27),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Blog","id":"gdlr-core-sidebar"},{"name":"Blog Left","id":"gdlr-core-sidebar1"},{"name":"Blog Right","id":"gdlr-core-sidebar2"},{"name":"Shop","id":"gdlr-core-sidebar3"},{"name":"Quick Links","id":"gdlr-core-sidebar4"},{"name":"Department - Lung","id":"gdlr-core-sidebar5"},{"name":"Department - Heart","id":"gdlr-core-sidebar6"},{"name":"Department - Orthopaedic","id":"gdlr-core-sidebar7"},{"name":"Department - General Surgery","id":"gdlr-core-sidebar8"},{"name":"Department - Pharmacy","id":"gdlr-core-sidebar9"},{"name":"Department - Sport Injury","id":"gdlr-core-sidebar10"},{"name":"Department - Flu & Fever","id":"gdlr-core-sidebar11"},{"name":"Department - Dental","id":"gdlr-core-sidebar12"},{"name":"Department - Eye Care","id":"gdlr-core-sidebar13"}],"sidebars_widgets":{"wp_inactive_widgets":["gdlr-core-custom-menu-widget-3","text-6","gdlr-core-custom-menu-widget-4"],"gdlr-core-sidebar-preset":["recent-posts-2"],"footer-1":["text-1"],"footer-2":["nav_menu-3"],"footer-3":["nav_menu-2"],"footer-4":["gdlr-core-opening-hour-widget-3","text-9"],"gdlr-core-sidebar":["text-5","recent-comments-3","tag_cloud-2"],"gdlr-core-sidebar1":["text-4","recent-posts-3","gdlr-core-recent-comment-widget-2"],"gdlr-core-sidebar2":["gdlr-core-recent-post-widget-1","tag_cloud-1","text-3","gdlr-core-custom-menu-widget-2"],"gdlr-core-sidebar3":["woocommerce_widget_cart-1","woocommerce_product_categories-1","woocommerce_price_filter-1","woocommerce_products-1"],"gdlr-core-sidebar4":[],"gdlr-core-sidebar5":["gdlr-core-custom-menu-widget-15","text-7","gdlr-core-opening-hour-widget-2","text-8"],"gdlr-core-sidebar6":["gdlr-core-custom-menu-widget-7","text-27","gdlr-core-opening-hour-widget-4","text-11"],"gdlr-core-sidebar7":["gdlr-core-custom-menu-widget-8","text-28","gdlr-core-opening-hour-widget-5","text-14"],"gdlr-core-sidebar8":["gdlr-core-custom-menu-widget-9","text-29","gdlr-core-opening-hour-widget-6","text-16"],"gdlr-core-sidebar9":["gdlr-core-custom-menu-widget-10","text-30","gdlr-core-opening-hour-widget-7","text-18"],"gdlr-core-sidebar10":["gdlr-core-custom-menu-widget-11","text-31","gdlr-core-opening-hour-widget-8","text-20"],"gdlr-core-sidebar11":["gdlr-core-custom-menu-widget-12","text-32","gdlr-core-opening-hour-widget-9","text-22"],"gdlr-core-sidebar12":["gdlr-core-custom-menu-widget-13","text-33","gdlr-core-opening-hour-widget-10","text-24"],"gdlr-core-sidebar13":["gdlr-core-custom-menu-widget-14","text-34","gdlr-core-opening-hour-widget-11","text-26"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Our Services","menu":"58","style":"list"},"3":{"title":"Case Study","menu":"75","style":"list"},"4":{"title":"Practice Areas","menu":"73","style":"list"},"7":{"title":"Heart Diseases","menu":"63","style":"list2"},"8":{"title":"Orthopaedic","menu":"64","style":"list2"},"9":{"title":"General Surgery","menu":"65","style":"list2"},"10":{"title":"Pharmacy","menu":"63","style":"list2"},"11":{"title":"Sport Injury","menu":"63","style":"list2"},"12":{"title":"Flu & Fever","menu":"63","style":"list2"},"13":{"title":"Dental","menu":"63","style":"list2"},"14":{"title":"Eye Care","menu":"63","style":"list2"},"15":{"title":"Lung Diseases","menu":"56","style":"list2"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"2":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"3":{"title":"Hospital Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 18:00","day3-text":"Sunday","day3-time":"09:00 - 18:00","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"4":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"5":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"6":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"7":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"8":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"9":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"10":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"11":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"2":{"title":"Recent Comments","num-fetch":"3","num-excerpt":"15"},"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"1":{"title":"Recent Articles","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"2":{"title":"Our Services","nav_menu":58},"3":{"title":"About Us","nav_menu":57},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"3":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"","text":"<img class=\"alignnone size-full wp-image-6129\" src=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/logo-1.png\" alt=\"\" width=\"170\" \/>\r\n[gdlr_core_space height=\"-27px\"]\r\nBox 3233\r\n1810 Kings Way\r\nKing Street, 5th Avenue, New York\r\n[gdlr_core_space height=\"0px\"]\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"19px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ]<span style=\"color: #17449e;\">+1-2345-3455-33<\/span>\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"19px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ]<a href=\"mailto:contact@mediztheme.co\" style=\"color: #17449E;\">contact@mediztheme.co<\/a>","filter":true,"visual":true},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_space height=\"15px\"][gdlr_widget_box title=\"Let us help you!\" title-color=\"#b1976b\" background=\"https:\/\/demo.goodlayers.com\/attorna\/wp-content\/uploads\/2019\/02\/sidebar-contact-bg.jpg\" color=\"#b8b8b8\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"50px 37px 30px 43px\" font-size=\"19px\"]If you need any helps, please feel free to contact us. We will get back to you with 1 business day. Or if in hurry, just call us now.\r\n\r\n<span style=\"font-size: 18px; color: #fff; font-weight: 500;\">Call : (1)2345-2345-54<\/span>\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"14px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Contact@Attornasite.co[gdlr_core_space height=\"7px\"][gdlr_core_icon icon=\"icon_clock_alt\" size=\"15px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Mon - Fri 09:00-17:00\r\n[\/gdlr_widget_box][gdlr_core_space height=\"20px\"]\r\n\r\n[gdlr_core_button button-text=\"Firm\u2019s Presentation\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"left\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"solid\" border-radius=\"3px\" background-color= \"#b1976b\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"7":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"8":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient-v\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"9":{"title":"","text":"[gdlr_core_space height=\"-23px\"][gdlr_core_button button-text=\"Emergency : 24 hours\" button-link=\"\/mediz\/hospital\/contact\/\" button-link-target=\"_blank\" margin-right=\"0px\" button-background=\"solid\" background-color=\"#ffffff\" text-color=\"#17449E\" border-radius=\"0px\" text-font-weight=\"700\" text-size=\"16px\" text-transform=\"none\" text-letter-spacing=\"0px\" padding=\"14px 50px 17px 50px\" button-shadow-size=\"0px 0px 30px\" button-shadow-color=\"#000\" button-shadow-opacity=\"0.1\" ]","filter":true,"visual":true},"11":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"14":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"16":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"18":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"20":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"22":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"24":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"26":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"27":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"28":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"29":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"30":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"31":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"32":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"33":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"34":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"1":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"1":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0,"max_depth":""},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"1":{"title":"Recent Products","number":4,"show":"","orderby":"date","order":"desc","hide_free":0,"show_hidden":0},"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"1":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_zeno_fr_widget":{"1":[],"_multiwidget":1}}', 
					'theme-option' => '{"mediz_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_icon icon=\"icon-clock\" size=\"18px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ]Mon - Sun  0900 - 2100\n[gdlr_core_icon icon=\"icon-phone\" size=\"19px\" color=\"#17449E\" margin-left=\"25px\" margin-right=\"10px\" ]+1-2345-3455-33[gdlr_core_icon icon=\"icon-envelope\" size=\"19px\" color=\"#17449E\" margin-left=\"25px\" margin-right=\"10px\" ]<a href=\"mailto:contact@mediztheme.co\">contact@mediztheme.co<\/a> ","top-bar-right-text":"","top-bar-top-padding":"19px","top-bar-bottom-padding":"19px","top-bar-text-size":"15px","top-bar-bottom-border":"2px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"bar","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-left-offset":"0","navigation-slide-bar":"style-2","navigation-slide-bar-top-margin":"-28px","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"40px","logo":"7442","logo-top-padding":"48px","logo-bottom-padding":"18px","logo-left-padding":"","max-logo-width":"170px","mobile-logo":"","max-tablet-logo-width":"150px","max-mobile-logo-width":"120px","mobile-logo-position":"logo-left","main-navigation-top-padding":"28px","main-navigation-bottom-padding":"33px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"enable","main-navigation-right-button-style":"round","main-navigation-right-button-text":"Contact Now","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-type":"overlay","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"disable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"17","fixed-navigation-logo-bottom-padding":"17","fixed-navigation-top-padding":"23","fixed-navigation-bottom-padding":"23","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"110px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"17px","default-title-font-transform":"none","default-title-font-size":"47px","default-title-font-weight":"600","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"17px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"0","default-title-background":"7437","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"custom","default-blog-title-top-padding":"104px","default-blog-title-bottom-padding":"105px","default-blog-feature-image":"none","default-blog-title-background-image":"7505","default-blog-top-bottom-gradient":"bottom","single-blog-title-top-gradient-size":"325px","single-blog-title-bottom-gradient-size":"346px","default-blog-title-background-overlay-opacity":"2","blog-style":"style-4","blockquote-style":"style-1","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar2","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"30","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"full","related-post-num-fetch":"2","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar2","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar3","woocommerce-archive-product-style":"grid-2","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"Personnel Square","woocommerce-related-product-column-size":"20","woocommerce-related-product-num-fetch":"3","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"45px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-text":"","copyright-left":"[gdlr_core_social_network facebook=\"#url\" twitter=\"#url\" linkedin=\"#\" skype=\"#\"  icon-size=\"17px\" icon-color=\"#17449E\" ]","copyright-right":"Copyright 2019 Mediz, All Right Reserved","enable-back-to-top":"disable","top-bar-right-button-icon-class":"fa fa-comment-o","top-bar-right-button-text":"Free consultant","top-bar-right-button-link":"\/attorna\/contact\/","top-bar-right-button-link-target":"_self","top-bar-shadow-size":"24px","top-bar-shadow-color":"#0a0a0a","header-shadow-size":"24px","header-shadow-color":"#000","enable-logo":"enable","navigation-slide-bar-width":"","navigation-slide-bar-height":"","main-navigation-search-icon":"icon-magnifier","main-navigation-search-icon-top-margin":"-4","main-navigation-cart-icon":"icon-bag","main-navigation-cart-icon-top-margin":"-4","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","enable-fixed-navigation-slide-bar":"enable","fixed-navigation-slide-bar-top-margin":"-18","blog-title-style":"","single-portfolio-navigation-middle-link":"#","logo-right-box1-icon":"icon-check","logo-right-box1-title":"Trusted By","logo-right-box1-caption":"120,000+  People","logo-right-box2-icon":"icon-check","logo-right-box2-title":"Best Hospital","logo-right-box2-caption":"U.K. News","logo-right-box3-icon":"icon-check","logo-right-box3-title":"Number #1","logo-right-box3-caption":"Clinic in London","fixed-navigation-right-top-margin":"5"},"mediz_typography":{"heading-font":"Poppins","navigation-font":"Poppins","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Montserrat","testimonial-font":"Merriweather","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"47px","h2-font-size":"41px","h3-font-size":"30px","h4-font-size":"24px","h5-font-size":"21px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"15px","navigation-font-weight":"500","navigation-font-letter-spacing":"0px","navigation-text-transform":"none","navigation-right-button-font-size":"12px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"17px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"16px","copyright-font-weight":"400","copyright-font-letter-spacing":"1","copyright-text-transform":"uppercase","font-upload":"","google-font-display":"optional","sub-navigation-font-size":""},"mediz_color":{"header-background-color":"#ffffff","top-cart-background-color":"#17449e","top-cart-checkout-color":"#ffffff","secondary-menu-icon-color":"#545454","secondary-menu-border-color":"#3f3f3f","main-menu-text-hover-color":"#17449e","sub-menu-background-color":"#f4f4f4","navigation-bar-right-icon-color":"#b0b0b0","main-menu-text-color":"#8098c9","woocommerce-theme-color":"#4d93e9","woocommerce-price-color":"#707070","woocommerce-button-background-hover-color":"#4d93e9","add-to-cart-background-color":"#4d93e9","widget-price-filter-range-color":"#abc5e8","widget-price-filter-handle-color":"#2f8cce","top-bar-social-hover-color":"#4d93e9","navigation-slide-bar-color":"#dfdfdf","woocommerce-cart-icon-number-background":"#4d93e9","woocommerce-cart-icon-number-color":"#ffffff","top-bar-background-color":"#ffffff","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#17449e","top-bar-link-color":"#17449e","top-bar-link-hover-color":"#4d93e9","top-bar-social-color":"#17449e","header-plain-bottom-border-color":"#e8e8e8","logo-background-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#323232","breadcrumbs-text-color":"#969696","breadcrumbs-text-active-color":"#17449e","navigation-bar-background-color":"#ffffff","navigation-bar-top-border-color":"#e8e8e8","sub-menu-text-color":"#7a7a7a","sub-menu-text-hover-color":"#17449e","sub-menu-text-hover-background-color":"#f4f4f4","sub-mega-menu-title-color":"#17449e","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-text-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#d3dced","navigation-right-button-background-color":"#17449e","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#17449e","navigation-right-button-border-hover-color":"#17449e","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#bbd1ff","page-title-background-overlay-color":"#000000","body-content-color":"#555555","heading-color":"#161616","link-color":"#3d3d3d","link-hover-color":"#606060","divider-color":"#e6e6e6","input-box-background-color":"#f7f7f7","input-box-border-color":"#e0e0e0","input-box-text-color":"#979797","input-box-placeholder-color":"#979797","404-content-background-color":"#17449e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#96b7e8","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#4d93e9","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#727272","search-box-border-color":"#f3f3f3","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#17449e","custom-menu-widget-list-style-link-hover":"#4d93e9","custom-menu-widget-list-style-border":"#4d93e9","footer-background-color":"#f6f6f6","footer-title-color":"#020202","footer-content-color":"#8b8b8b","footer-link-color":"#919191","footer-link-hover-color":"#17449e","footer-divider-color":"#dddddd","copyright-background-color":"#ffffff","copyright-text-color":"#afafaf","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#4d93e9","single-blog-navigation-color":"#4d93e9","single-blog-navigation2-left-overlay":"#4d93e9","single-blog-navigation2-overlay":"#4d93e9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#4d93e9","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#191919","blog-title-hover-color":"#4d93e9","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#4d93e9","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#17449e","blog-thumbnail-category-background":"#4d93e9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#4d93e9","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#4d93e9","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#828282","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#4d93e9","portfolio-badge-text-color":"#0a0a0a","portfolio-badge-background-color":"#4d93e9","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#161616","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#191919","portfolio-button-filter-background-active-color":"#4d93e9","price-table-background-color":"#ffffff","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#3e3e3e","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#c0cfe8","price-table-price-background-color":"#f6f6f6","price-table-price-color":"#323232","price-table-price-suffix-color":"#191919","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#383838","price-table-button-background-top-gradient-color":"#383838","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#4d93e9","price-table-active-head-top-gradient-color":"#4d93e9","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff3f2","price-table-active-price-background-color":"#f6f6f6","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#191919","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#4d93e9","price-table-active-button-background-top-gradient-color":"#4d93e9","accordion-normal-icon-color":"#4c4c4c","accordion-normal-title-head-color":"#4c4c4c","accordion-normal-title-color":"#4c4c4c","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#989898","accordion-title-head-color":"#191919","accordion-title-color":"#4d93e9","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#4d93e9","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#b1976b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#b1976b","blockquote-item-content-color":"#1c1c1c","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#4d93e9","button-background-hover-color":"#76a9e8","button-border-color":"#4d93e9","button-border-hover-color":"#76a9e8","button-gradient-background-color":"#4d93e9","button-top-gradient-background-color":"#207ae8","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#7d7d7d","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#4d93e9","dropdown-tab-head-text":"#252525","flipbox-background-color":"#4d93e9","flipbox-border-color":"#4d93e9","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#141414","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#17449e","personnel-grid-position-color":"#9d9d9d","personnel-grid-divider-color":"#17449e","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#d8c0b1","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#ddc5b5","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#b1976b","roadmap-number-active-text":"#b1976b","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#ddc5b5","roadmap-content-color":"#ddc5b5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#4d93e9","slider-outer-navigation-color":"#4d93e9","slider-outer-navigation-background-color":"#ffffff","slider-control-navigation-color":"#8a8a8a","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#4d93e9","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#4d93e9","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#161616","title-item-caption-color":"#747474","woocommerce-price-linethrough-color":"#949494","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#0a0a0a","add-to-cart-text-color":"#ffffff","widget-price-filter-bar-background-color":"#e6e6e6","skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#a1a1a1","content":"#ffffff","icon":"#ffffff","link":"#4d93e9","link-hover":"#94b8e8","divider":"","border":"","element-background":"#111111","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"","caption":"#5db0b8","content":"","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#5db0b8","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#373737","element-background":"#373737","element-content":"#989898","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter White","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#ffffff","element-background":"#ffffff","element-content":"#969696","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-dpment","title":"#17449e","title-hover":"","caption":"","content":"#606060","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-dpment","title":"#4d93e9","title-hover":"#4d93e9","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#4d93e9","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-doc-dpment","title":"#17449e","title-hover":"","caption":"","content":"#7c92bd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Lung Diseases","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"#4d93e9","link-hover":"","divider":"#4d93e9","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Counter","title":"#ffffff","title-hover":"","caption":"","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#17449e","link-hover":"#4d93e9","divider":"","border":"","element-background":"#17449e","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 contact form","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Accordion","title":"#93d9ff","title-hover":"","caption":"#bcdbff","content":"#bcdbff","icon":"#ffffff","link":"","link-hover":"","divider":"#5c79b3","border":"#5c79b3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Input","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A1 Column SVC","title":"#a6c4ff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVC","title":"#171717","title-hover":"","caption":"#757575","content":"#757575","icon":"#748ec4","link":"#748ec4","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVS MId","title":"#343434","title-hover":"","caption":"#797979","content":"#797979","icon":"#17449e","link":"#17449e","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blockqoute","title":"","title-hover":"","caption":"#17449e","content":"#4e4e4e","icon":"#17449e","link":"","link-hover":"#a1a1a1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-ls","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Blog Featured","title":"","title-hover":"","caption":"#a7a7a7","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Column SVC Bottom","title":"#ffffff","title-hover":"","caption":"#ccd7ec","content":"#ccd7ec","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Column SVC","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team Page","title":"#ffffff","title-hover":"","caption":"#b0c9e8","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#b2cae8","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"couter-Ourdoc","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-ourdoc","title":"#17449e","title-hover":"","caption":"","content":"#8f8f8f","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#17449e","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"col-clinic","title":"#ffffff","title-hover":"","caption":"","content":"#cbe3ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dentist Contact Form ","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personal HP Dentist","title":"","title-hover":"","caption":"#a1a1a1","content":"#a1a1a1","icon":"","link":"","link-hover":"","divider":"#4d93e9","border":"","element-background":"#5e9eeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Counter","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Accordion","title":"#4d93e9","title-hover":"","caption":"#8f8f8f","content":"#8f8f8f","icon":"#4d93e9","link":"","link-hover":"","divider":"#d9d9d9","border":"#d9d9d9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"letterbgwhite","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Clinic Contact Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f3f3f3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"blog-grid-divider-color":"#ffd115","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#4d93e9","tag-cloud-border-color":"#4d93e9","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","fixed-navigation-background-color":"","logo-bottom-border-color":"#b39a96","load-more-button-text":"#968481","load-more-button-border":"#968481","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#17449e","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#4d93e9","custom-menu-widget-box-style-text-active":"#ffffff","top-bar-right-button-background":"#b1976b","navigation-right-button-shadow-color":"#000","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#4275dc","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#2653e3","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7","testimonial-frame-background-color":"#ffffff","custom-menu-widget-list2-style-icon":"#888888","header-bar-right-text-icon":"#93b3f1","header-bar-right-text-title":"#17449e","header-bar-right-text-caption":"#9f9f9f","blog-widget-feature-background-color":"17449e","blog-widget-feature-title-color":"#ffffff","blog-widget-feature-info-color":"#9ebeff"},"mediz_plugin":{"enable-srcset":"enable","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Gallery Portrait","width":"500","height":"600","hard-crop":""},{"name":"Port Large","width":"1500","height":"590","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"7684","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font","ionicons","simpleline"],"additional-body-script":""}}'
				),
				'hospital2' => array(
					'title' => esc_html__('Hospital 2', 'mediz'),
					'url' => 'https://demo.goodlayers.com/mediz/hospital2',
					'xml' => get_template_directory() . '/admin/function/files/hospital2.xml',
					'page' => 8371,
					'menu' => array('main_menu' => 59, 'mobile_menu' => 59),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Blog","id":"gdlr-core-sidebar"},{"name":"Blog Left","id":"gdlr-core-sidebar1"},{"name":"Blog Right","id":"gdlr-core-sidebar2"},{"name":"Shop","id":"gdlr-core-sidebar3"},{"name":"Quick Links","id":"gdlr-core-sidebar4"},{"name":"Department - Lung","id":"gdlr-core-sidebar5"},{"name":"Department - Heart","id":"gdlr-core-sidebar6"},{"name":"Department - Orthopaedic","id":"gdlr-core-sidebar7"},{"name":"Department - General Surgery","id":"gdlr-core-sidebar8"},{"name":"Department - Pharmacy","id":"gdlr-core-sidebar9"},{"name":"Department - Sport Injury","id":"gdlr-core-sidebar10"},{"name":"Department - Flu & Fever","id":"gdlr-core-sidebar11"},{"name":"Department - Dental","id":"gdlr-core-sidebar12"},{"name":"Department - Eye Care","id":"gdlr-core-sidebar13"}],"sidebars_widgets":{"wp_inactive_widgets":["gdlr-core-custom-menu-widget-3","text-6","gdlr-core-custom-menu-widget-4"],"gdlr-core-sidebar-preset":["recent-posts-2"],"footer-1":["text-1"],"footer-2":["text-35"],"footer-3":["gdlr-core-custom-menu-widget-16"],"footer-4":["gdlr-core-newsletter-widget-2"],"gdlr-core-sidebar":["text-5","recent-comments-3","tag_cloud-2"],"gdlr-core-sidebar1":["text-4","recent-posts-3","gdlr-core-recent-comment-widget-2"],"gdlr-core-sidebar2":["gdlr-core-recent-post-widget-1","tag_cloud-1","text-3","gdlr-core-custom-menu-widget-2"],"gdlr-core-sidebar3":[],"gdlr-core-sidebar4":[],"gdlr-core-sidebar5":["gdlr-core-custom-menu-widget-15","text-7","gdlr-core-opening-hour-widget-2","text-8"],"gdlr-core-sidebar6":["gdlr-core-custom-menu-widget-7","text-27","gdlr-core-opening-hour-widget-4","text-11"],"gdlr-core-sidebar7":["gdlr-core-custom-menu-widget-8","text-28","gdlr-core-opening-hour-widget-5","text-14"],"gdlr-core-sidebar8":["gdlr-core-custom-menu-widget-9","text-29","gdlr-core-opening-hour-widget-6","text-16"],"gdlr-core-sidebar9":["gdlr-core-custom-menu-widget-10","text-30","gdlr-core-opening-hour-widget-7","text-18"],"gdlr-core-sidebar10":["gdlr-core-custom-menu-widget-11","text-31","gdlr-core-opening-hour-widget-8","text-20"],"gdlr-core-sidebar11":["gdlr-core-custom-menu-widget-12","text-32","gdlr-core-opening-hour-widget-9","text-22"],"gdlr-core-sidebar12":["gdlr-core-custom-menu-widget-13","text-33","gdlr-core-opening-hour-widget-10","text-24"],"gdlr-core-sidebar13":["gdlr-core-custom-menu-widget-14","text-34","gdlr-core-opening-hour-widget-11","text-26"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Our Services","menu":"58","style":"list"},"3":{"title":"Case Study","menu":"75","style":"list"},"4":{"title":"Practice Areas","menu":"73","style":"list"},"7":{"title":"Heart Diseases","menu":"63","style":"list2"},"8":{"title":"Orthopaedic","menu":"64","style":"list2"},"9":{"title":"General Surgery","menu":"65","style":"list2"},"10":{"title":"Pharmacy","menu":"63","style":"list2"},"11":{"title":"Sport Injury","menu":"63","style":"list2"},"12":{"title":"Flu & Fever","menu":"63","style":"list2"},"13":{"title":"Dental","menu":"63","style":"list2"},"14":{"title":"Eye Care","menu":"63","style":"list2"},"15":{"title":"Lung Diseases","menu":"56","style":"list2"},"16":{"title":"Member Resources","menu":"61","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"2":{"title":" Our Newsletter","style":"style-2","icon-color":"#4cd4ca"},"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"2":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"4":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"5":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"6":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"7":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"8":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"9":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"10":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"11":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"2":{"title":"Recent Comments","num-fetch":"3","num-excerpt":"15"},"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"1":{"title":"Recent Articles","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"3":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"","text":"[gdlr_core_space height=\"-6px\"]<img class=\"alignnone size-full\" src=\"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/logo-footer.png\" alt=\"\" width=\"124\" \/>\r\n[gdlr_core_space height=\"-40px\"]\r\nExceptional primary care, designed\r\nfor real life\r\n\r\n[gdlr_core_icon icon=\"fa fa-facebook\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-youtube-play\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-linkedin\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ]","filter":true,"visual":true},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_space height=\"15px\"][gdlr_widget_box title=\"Let us help you!\" title-color=\"#b1976b\" background=\"https:\/\/demo.goodlayers.com\/attorna\/wp-content\/uploads\/2019\/02\/sidebar-contact-bg.jpg\" color=\"#b8b8b8\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"50px 37px 30px 43px\" font-size=\"19px\"]If you need any helps, please feel free to contact us. We will get back to you with 1 business day. Or if in hurry, just call us now.\r\n\r\n<span style=\"font-size: 18px; color: #fff; font-weight: 500;\">Call : (1)2345-2345-54<\/span>\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"14px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Contact@Attornasite.co[gdlr_core_space height=\"7px\"][gdlr_core_icon icon=\"icon_clock_alt\" size=\"15px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Mon - Fri 09:00-17:00\r\n[\/gdlr_widget_box][gdlr_core_space height=\"20px\"]\r\n\r\n[gdlr_core_button button-text=\"Firm\u2019s Presentation\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"left\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"solid\" border-radius=\"3px\" background-color= \"#b1976b\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"7":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"8":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient-v\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"11":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"14":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"16":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"18":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"20":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"22":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"24":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"26":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"27":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"28":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"29":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"30":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"31":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"32":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"33":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"34":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"35":{"title":"Contact Centre","text":"[gdlr_core_icon icon=\"ion-ios-telephone\" size=\"19px\" color=\"#4cd4ca\" margin-left=\"\" margin-right=\"10px\"](+1) 212-946-2707\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"ion-ios-location\" size=\"19px\" color=\"#4cd4ca\" margin-left=\"3px\" margin-right=\"10px\" ]112 W 34th St, New York\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"ion-ios-clock\" size=\"19px\" color=\"#4cd4ca\" margin-left=\"\" margin-right=\"10px\" ]Mon - Fri: 8.00am 6.00pm","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"1":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"1":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0,"max_depth":""},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"1":{"title":"Recent Products","number":4,"show":"","orderby":"date","order":"desc","hide_free":0,"show_hidden":0},"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"1":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_zeno_fr_widget":{"1":[],"_multiwidget":1}}',
					'theme-option' => '{"mediz_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_icon icon=\"ion-location\" size=\"20px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ]112 W 34th St, New York\n[gdlr_core_icon icon=\"ion-ios-telephone\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]212-946-2707[gdlr_core_icon icon=\"ion-ios-clock\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]Mon - Fri:  9:00AM - 8:00PM","top-bar-right-text":"","top-bar-top-padding":"9px","top-bar-bottom-padding":"9px","top-bar-text-size":"16px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"solid","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"17px","navigation-left-offset":"0","navigation-slide-bar":"style-2","navigation-slide-bar-top-margin":"-5px","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"40px","logo":"8442","logo-top-padding":"28px","logo-bottom-padding":"20px","logo-left-padding":"","max-logo-width":"150","mobile-logo":"","max-tablet-logo-width":"125px","max-mobile-logo-width":"110px","mobile-logo-position":"logo-left","main-navigation-top-padding":"38px","main-navigation-bottom-padding":"38px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"2","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"enable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Appointment","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-type":"overlay","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"80px","fixed-navigation-logo-top-padding":"17","fixed-navigation-logo-bottom-padding":"17","fixed-navigation-top-padding":"23","fixed-navigation-bottom-padding":"23","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"110px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"17px","default-title-font-transform":"none","default-title-font-size":"47px","default-title-font-weight":"600","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"17px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"11","default-title-background":"8301","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"custom","default-blog-title-top-padding":"104px","default-blog-title-bottom-padding":"105px","default-blog-feature-image":"none","default-blog-title-background-image":"7505","default-blog-top-bottom-gradient":"bottom","single-blog-title-top-gradient-size":"325px","single-blog-title-bottom-gradient-size":"346px","default-blog-title-background-overlay-opacity":"2","blog-style":"style-4","blockquote-style":"style-1","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar2","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"30","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"full","related-post-num-fetch":"2","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar2","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar3","woocommerce-archive-product-style":"grid-2","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"Personnel Square","woocommerce-related-product-column-size":"20","woocommerce-related-product-num-fetch":"3","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"56px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"center","copyright-top-padding":"0px","copyright-bottom-padding":"22px","copyright-text":"Copyright \u00a92019 Mediz. All Rights Reserved. <a href=\"#\">Legal and Privacy<\/a>.","copyright-left":"[gdlr_core_social_network facebook=\"#url\" twitter=\"#url\" linkedin=\"#\" skype=\"#\"  icon-size=\"17px\" icon-color=\"#17449E\" ]","copyright-right":"Copyright 2019 Mediz, All Right Reserved","enable-back-to-top":"disable","top-bar-right-button-icon-class":"fa fa-comment-o","top-bar-right-button-text":"Free consultant","top-bar-right-button-link":"\/attorna\/contact\/","top-bar-right-button-link-target":"_self","top-bar-shadow-size":"0","top-bar-shadow-color":"#0a0a0a","header-shadow-size":"0px","header-shadow-color":"#000","enable-logo":"enable","navigation-slide-bar-width":"","navigation-slide-bar-height":"5","main-navigation-search-icon":"icon-magnifier","main-navigation-search-icon-top-margin":"-4","main-navigation-cart-icon":"icon-bag","main-navigation-cart-icon-top-margin":"-4","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","enable-fixed-navigation-slide-bar":"enable","fixed-navigation-slide-bar-top-margin":"-18","blog-title-style":"","single-portfolio-navigation-middle-link":"#","logo-right-box1-icon":"icon-check","logo-right-box1-title":"Trusted By","logo-right-box1-caption":"120,000+  People","logo-right-box2-icon":"icon-check","logo-right-box2-title":"Best Hospital","logo-right-box2-caption":"U.K. News","logo-right-box3-icon":"icon-check","logo-right-box3-title":"Number #1","logo-right-box3-caption":"Clinic in London","fixed-navigation-right-top-margin":"2px"},"mediz_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","testimonial-font":"Merriweather","additional-font":"Jost","additional-font2":"Georgia, serif","h1-font-size":"47px","h2-font-size":"41px","h3-font-size":"30px","h4-font-size":"24px","h5-font-size":"21px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"14px","navigation-font-weight":"500","navigation-font-letter-spacing":"1","navigation-text-transform":"uppercase","navigation-right-button-font-size":"12px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"17px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"500","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"400","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"}],"google-font-display":"optional","sub-navigation-font-size":""},"mediz_color":{"header-background-color":"#ffffff","top-cart-background-color":"#5170ca","top-cart-checkout-color":"#ffffff","secondary-menu-icon-color":"#222222","secondary-menu-border-color":"#222222","main-menu-text-hover-color":"#222222","sub-menu-background-color":"#f4f4f4","navigation-bar-right-icon-color":"#ffffff","main-menu-text-color":"#222222","woocommerce-theme-color":"#5170ca","woocommerce-price-color":"#707070","woocommerce-button-background-hover-color":"#5170ca","add-to-cart-background-color":"#5170ca","widget-price-filter-range-color":"#a3acc9","widget-price-filter-handle-color":"#5170ca","top-bar-social-hover-color":"#d0d5e8","navigation-slide-bar-color":"#4cd4ca","woocommerce-cart-icon-number-background":"#5170ca","woocommerce-cart-icon-number-color":"#ffffff","top-bar-background-color":"#5170ca","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#d0d5e8","top-bar-social-color":"#ffffff","header-plain-bottom-border-color":"#b7b7b7","logo-background-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#323232","breadcrumbs-text-color":"#969696","breadcrumbs-text-active-color":"#5170ca","navigation-bar-background-color":"#ffffff","navigation-bar-top-border-color":"#ffffff","sub-menu-text-color":"#7a7a7a","sub-menu-text-hover-color":"#5170ca","sub-menu-text-hover-background-color":"#f4f4f4","sub-mega-menu-title-color":"#5170ca","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#ffffff","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#222222","navigation-right-text-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#e1efee","navigation-right-button-background-color":"#4cd4ca","navigation-right-button-background-hover-color":"#55c6bb","navigation-right-button-border-color":"#4cd4ca","navigation-right-button-border-hover-color":"#55c6bb","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#d6d6d6","page-title-background-overlay-color":"#000000","body-content-color":"#555555","heading-color":"#161616","link-color":"#3d3d3d","link-hover-color":"#606060","divider-color":"#e6e6e6","input-box-background-color":"#f7f7f7","input-box-border-color":"#e5e5e5","input-box-text-color":"#979797","input-box-placeholder-color":"#979797","404-content-background-color":"#17449e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#96b7e8","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#5170ca","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#727272","search-box-border-color":"#f3f3f3","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#5170ca","custom-menu-widget-list-style-link-hover":"#5170ca","custom-menu-widget-list-style-border":"#5170ca","footer-background-color":"#f8faff","footer-title-color":"#020202","footer-content-color":"#373737","footer-link-color":"#373737","footer-link-hover-color":"#5170ca","footer-divider-color":"#dddddd","copyright-background-color":"#f8faff","copyright-text-color":"#6b7a90","copyright-link-color":"#5170ca","copyright-link-hover-color":"#8497c9","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#5170ca","single-blog-navigation-color":"#5170ca","single-blog-navigation2-left-overlay":"#5170ca","single-blog-navigation2-overlay":"#5170ca","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#5170ca","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#191919","blog-title-hover-color":"#5170ca","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#5170ca","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#5170ca","blog-thumbnail-category-background":"#5170ca","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#5170ca","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#5170ca","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#828282","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#5170ca","portfolio-badge-text-color":"#0a0a0a","portfolio-badge-background-color":"#5170ca","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#161616","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#191919","portfolio-button-filter-background-active-color":"#5170ca","price-table-background-color":"#ffffff","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#3e3e3e","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#c0cfe8","price-table-price-background-color":"#f6f6f6","price-table-price-color":"#323232","price-table-price-suffix-color":"#191919","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#383838","price-table-button-background-top-gradient-color":"#383838","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#5170ca","price-table-active-head-top-gradient-color":"#5170ca","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff3f2","price-table-active-price-background-color":"#f6f6f6","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#191919","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#5170ca","price-table-active-button-background-top-gradient-color":"#5170ca","accordion-normal-icon-color":"#4c4c4c","accordion-normal-title-head-color":"#4c4c4c","accordion-normal-title-color":"#4c4c4c","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#989898","accordion-title-head-color":"#191919","accordion-title-color":"#5170ca","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#5170ca","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#5170ca","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#5170ca","blockquote-item-content-color":"#1c1c1c","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#5170ca","button-background-hover-color":"#6a82c9","button-border-color":"#5170ca","button-border-hover-color":"#8095c9","button-gradient-background-color":"#5170ca","button-top-gradient-background-color":"#5170ca","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#7d7d7d","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#5170ca","dropdown-tab-head-text":"#252525","flipbox-background-color":"#5170ca","flipbox-border-color":"#5170ca","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#141414","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#5170ca","personnel-grid-position-color":"#9d9d9d","personnel-grid-divider-color":"#5170ca","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#d8c0b1","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#ddc5b5","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#b1976b","roadmap-number-active-text":"#b1976b","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#ddc5b5","roadmap-content-color":"#ddc5b5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#5170ca","slider-outer-navigation-color":"#5170ca","slider-outer-navigation-background-color":"#ffffff","slider-control-navigation-color":"#8a8a8a","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#5170ca","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#5170ca","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#161616","title-item-caption-color":"#747474","woocommerce-price-linethrough-color":"#949494","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#0a0a0a","add-to-cart-text-color":"#ffffff","widget-price-filter-bar-background-color":"#e6e6e6","skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#a1a1a1","content":"#ffffff","icon":"#ffffff","link":"#4d93e9","link-hover":"#94b8e8","divider":"","border":"","element-background":"#111111","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"","caption":"#5db0b8","content":"","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#5db0b8","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#373737","element-background":"#373737","element-content":"#989898","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter White","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#ffffff","element-background":"#ffffff","element-content":"#969696","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-dpment","title":"#17449e","title-hover":"","caption":"","content":"#606060","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-dpment","title":"#4d93e9","title-hover":"#4d93e9","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#4d93e9","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-doc-dpment","title":"#17449e","title-hover":"","caption":"","content":"#7c92bd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Lung Diseases","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"#4d93e9","link-hover":"","divider":"#4d93e9","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Counter","title":"#ffffff","title-hover":"","caption":"","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#17449e","link-hover":"#4d93e9","divider":"","border":"","element-background":"#17449e","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 contact form","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Accordion","title":"#93d9ff","title-hover":"","caption":"#bcdbff","content":"#bcdbff","icon":"#ffffff","link":"","link-hover":"","divider":"#5c79b3","border":"#5c79b3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Input","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A1 Column SVC","title":"#a6c4ff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVC","title":"#171717","title-hover":"","caption":"#757575","content":"#757575","icon":"#748ec4","link":"#748ec4","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVS MId","title":"#343434","title-hover":"","caption":"#797979","content":"#797979","icon":"#17449e","link":"#17449e","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blockqoute","title":"","title-hover":"","caption":"#17449e","content":"#4e4e4e","icon":"#17449e","link":"","link-hover":"#a1a1a1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-ls","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Blog Featured","title":"","title-hover":"","caption":"#a7a7a7","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Column SVC Bottom","title":"#ffffff","title-hover":"","caption":"#ccd7ec","content":"#ccd7ec","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Column SVC","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team Page","title":"#ffffff","title-hover":"","caption":"#b0c9e8","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#b2cae8","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"couter-Ourdoc","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-ourdoc","title":"#17449e","title-hover":"","caption":"","content":"#8f8f8f","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#17449e","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"col-clinic","title":"#ffffff","title-hover":"","caption":"","content":"#cbe3ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dentist Contact Form ","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personal HP Dentist","title":"","title-hover":"","caption":"#a1a1a1","content":"#a1a1a1","icon":"","link":"","link-hover":"","divider":"#4d93e9","border":"","element-background":"#5e9eeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Counter","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Accordion","title":"#4d93e9","title-hover":"","caption":"#8f8f8f","content":"#8f8f8f","icon":"#4d93e9","link":"","link-hover":"","divider":"#d9d9d9","border":"#d9d9d9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"letterbgwhite","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Clinic Contact Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f3f3f3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"About Dentist 2 Counter","title":"#4cd4ca","title-hover":"","caption":"#222222","content":"#222222","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"icon green","title":"","title-hover":"","caption":"","content":"#373737","icon":"#8fe2db","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"blog-grid-divider-color":"#ffd115","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#5170ca","tag-cloud-border-color":"#5170ca","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","fixed-navigation-background-color":"","logo-bottom-border-color":"#b39a96","load-more-button-text":"#968481","load-more-button-border":"#968481","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#5170ca","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#5170ca","custom-menu-widget-box-style-text-active":"#ffffff","top-bar-right-button-background":"#b1976b","navigation-right-button-shadow-color":"#000","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#5170ca","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#5170ca","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7","testimonial-frame-background-color":"#ffffff","custom-menu-widget-list2-style-icon":"#888888","header-bar-right-text-icon":"#93b3f1","header-bar-right-text-title":"#5170ca","header-bar-right-text-caption":"#9f9f9f","blog-widget-feature-background-color":"17449e","blog-widget-feature-title-color":"#ffffff","blog-widget-feature-info-color":"#6a82c9"},"mediz_plugin":{"enable-srcset":"disable","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Gallery Portrait","width":"500","height":"600","hard-crop":""},{"name":"Port Large","width":"1500","height":"590","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"7684","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font","ionicons","simpleline"],"additional-body-script":""}}'
				),
				'dentist' => array(
					'title' => esc_html__('Dentist', 'mediz'),
					'url' => 'https://demo.goodlayers.com/mediz/dentist/',
					'xml' => get_template_directory() . '/admin/function/files/dentist.xml',
					'page' => 7861,
					'menu' => array('main_menu' => 27, 'mobile_menu' => 27),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Blog","id":"gdlr-core-sidebar"},{"name":"Blog Left","id":"gdlr-core-sidebar1"},{"name":"Blog Right","id":"gdlr-core-sidebar2"},{"name":"Shop","id":"gdlr-core-sidebar3"},{"name":"Quick Links","id":"gdlr-core-sidebar4"},{"name":"Department - Lung","id":"gdlr-core-sidebar5"},{"name":"Department - Heart","id":"gdlr-core-sidebar6"},{"name":"Department - Orthopaedic","id":"gdlr-core-sidebar7"},{"name":"Department - General Surgery","id":"gdlr-core-sidebar8"},{"name":"Department - Pharmacy","id":"gdlr-core-sidebar9"},{"name":"Department - Sport Injury","id":"gdlr-core-sidebar10"},{"name":"Department - Flu & Fever","id":"gdlr-core-sidebar11"},{"name":"Department - Dental","id":"gdlr-core-sidebar12"},{"name":"Department - Eye Care","id":"gdlr-core-sidebar13"}],"sidebars_widgets":{"wp_inactive_widgets":["gdlr-core-custom-menu-widget-3","text-6","gdlr-core-custom-menu-widget-4"],"gdlr-core-sidebar-preset":["recent-posts-2"],"footer-1":["text-1"],"footer-2":["nav_menu-3"],"footer-3":["nav_menu-2"],"footer-4":["gdlr-core-opening-hour-widget-3","text-9"],"gdlr-core-sidebar":["text-5","recent-comments-3","tag_cloud-2"],"gdlr-core-sidebar1":["text-4","recent-posts-3","gdlr-core-recent-comment-widget-2"],"gdlr-core-sidebar2":["gdlr-core-recent-post-widget-1","tag_cloud-1","text-3","gdlr-core-custom-menu-widget-2"],"gdlr-core-sidebar3":["woocommerce_widget_cart-1","woocommerce_product_categories-1","woocommerce_price_filter-1","woocommerce_products-1"],"gdlr-core-sidebar4":[],"gdlr-core-sidebar5":["gdlr-core-custom-menu-widget-15","text-7","gdlr-core-opening-hour-widget-2","text-8"],"gdlr-core-sidebar6":["gdlr-core-custom-menu-widget-7","text-27","gdlr-core-opening-hour-widget-4","text-11"],"gdlr-core-sidebar7":["gdlr-core-custom-menu-widget-8","text-28","gdlr-core-opening-hour-widget-5","text-14"],"gdlr-core-sidebar8":["gdlr-core-custom-menu-widget-9","text-29","gdlr-core-opening-hour-widget-6","text-16"],"gdlr-core-sidebar9":["gdlr-core-custom-menu-widget-10","text-30","gdlr-core-opening-hour-widget-7","text-18"],"gdlr-core-sidebar10":["gdlr-core-custom-menu-widget-11","text-31","gdlr-core-opening-hour-widget-8","text-20"],"gdlr-core-sidebar11":["gdlr-core-custom-menu-widget-12","text-32","gdlr-core-opening-hour-widget-9","text-22"],"gdlr-core-sidebar12":["gdlr-core-custom-menu-widget-13","text-33","gdlr-core-opening-hour-widget-10","text-24"],"gdlr-core-sidebar13":["gdlr-core-custom-menu-widget-14","text-34","gdlr-core-opening-hour-widget-11","text-26"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Our Services","menu":"58","style":"list"},"3":{"title":"Case Study","menu":"75","style":"list"},"4":{"title":"Practice Areas","menu":"73","style":"list"},"7":{"title":"Heart Diseases","menu":"57","style":"list2"},"8":{"title":"Orthopaedic","menu":"60","style":"list2"},"9":{"title":"General Surgery","menu":"56","style":"list2"},"10":{"title":"Pharmacy","menu":"60","style":"list2"},"11":{"title":"Sport Injury","menu":"58","style":"list2"},"12":{"title":"Flu & Fever","menu":"56","style":"list2"},"13":{"title":"Dental","menu":"60","style":"list2"},"14":{"title":"Eye Care","menu":"60","style":"list2"},"15":{"title":"Lung Diseases","menu":"58","style":"list2"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"2":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"3":{"title":"Hospital Hours","color":"#4d93e9","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 18:00","day3-text":"Sunday","day3-time":"09:00 - 18:00","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"4":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"5":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"6":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"7":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"8":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"9":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"10":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"11":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"2":{"title":"Recent Comments","num-fetch":"3","num-excerpt":"15"},"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"1":{"title":"Recent Articles","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"2":{"title":"Our Services","nav_menu":61},"3":{"title":"About Us","nav_menu":55},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"3":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"","text":"<img class=\"alignnone size-full wp-image-6129\" src=\"https:\/\/demo.goodlayers.com\/mediz\/dentist\/wp-content\/uploads\/sites\/4\/2019\/12\/logo-dentist.png\" alt=\"\" width=\"170\" \/>\r\n[gdlr_core_space height=\"-27px\"]\r\nBox 3233\r\n1810 Kings Way\r\nKing Street, 5th Avenue, New York\r\n[gdlr_core_space height=\"0px\"]\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"19px\" color=\"#4D93E9\" margin-left=\"\" margin-right=\"10px\" ]<span style=\"color: #4D93E9;\">+1-2345-3455-33<\/span>\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"19px\" color=\"#4D93E9\" margin-left=\"\" margin-right=\"10px\" ]<a style=\"color: #4D93E9;\" href=\"mailto:contact@mediztheme.co\">contact@mediztheme.co<\/a>","filter":true,"visual":true},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_space height=\"15px\"][gdlr_widget_box title=\"Let us help you!\" title-color=\"#b1976b\" background=\"https:\/\/demo.goodlayers.com\/attorna\/wp-content\/uploads\/2019\/02\/sidebar-contact-bg.jpg\" color=\"#b8b8b8\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"50px 37px 30px 43px\" font-size=\"19px\"]If you need any helps, please feel free to contact us. We will get back to you with 1 business day. Or if in hurry, just call us now.\r\n\r\n<span style=\"font-size: 18px; color: #fff; font-weight: 500;\">Call : (1)2345-2345-54<\/span>\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"14px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Contact@Attornasite.co[gdlr_core_space height=\"7px\"][gdlr_core_icon icon=\"icon_clock_alt\" size=\"15px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Mon - Fri 09:00-17:00\r\n[\/gdlr_widget_box][gdlr_core_space height=\"20px\"]\r\n\r\n[gdlr_core_button button-text=\"Firm\u2019s Presentation\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"left\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"solid\" border-radius=\"3px\" background-color= \"#b1976b\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"7":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"8":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient-v\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"9":{"title":"","text":"[gdlr_core_space height=\"-23px\"][gdlr_core_button button-text=\"Emergency : 24 hours\" button-link=\"\/mediz\/hospital\/contact\/\" button-link-target=\"_blank\" margin-right=\"0px\" button-background=\"solid\" background-color=\"#ffffff\" text-color=\"#4D93E9\" border-radius=\"0px\" text-font-weight=\"700\" text-size=\"16px\" text-transform=\"none\" text-letter-spacing=\"0px\" padding=\"14px 50px 17px 50px\" button-shadow-size=\"0px 0px 30px\" button-shadow-color=\"#000\" button-shadow-opacity=\"0.1\" ]","filter":true,"visual":true},"11":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"14":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"16":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"18":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"20":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"22":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"24":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"26":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"27":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"28":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"29":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"30":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"31":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"32":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"33":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"34":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"1":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"1":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0,"max_depth":""},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"1":{"title":"Recent Products","number":4,"show":"","orderby":"date","order":"desc","hide_free":0,"show_hidden":0},"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"1":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_zeno_fr_widget":{"1":[],"_multiwidget":1}}', 
					'theme-option' => '{"mediz_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_icon icon=\"icon-clock\" size=\"18px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ]Mon - Sun  0900 - 2100\n[gdlr_core_icon icon=\"icon-phone\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]+1-2345-3455-33[gdlr_core_icon icon=\"icon-envelope\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]<a href=\"mailto:contact@mediztheme.co\">contact@mediztheme.co<\/a> ","top-bar-right-text":"","top-bar-top-padding":"17px","top-bar-bottom-padding":"17px","top-bar-text-size":"15px","top-bar-bottom-border":"2px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-left-offset":"0","navigation-slide-bar":"style-dot","navigation-slide-bar-top-margin":"-40px","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"40px","logo":"8220","logo-top-padding":"38px","logo-bottom-padding":"33px","logo-left-padding":"","max-logo-width":"190","mobile-logo":"","max-tablet-logo-width":"150px","max-mobile-logo-width":"120px","mobile-logo-position":"logo-left","main-navigation-top-padding":"44px","main-navigation-bottom-padding":"44px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"3","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"enable","main-navigation-right-button-style":"round","main-navigation-right-button-text":"Contact Now","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-type":"overlay","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"disable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"17","fixed-navigation-logo-bottom-padding":"17","fixed-navigation-top-padding":"23","fixed-navigation-bottom-padding":"23","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"110px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"17px","default-title-font-transform":"none","default-title-font-size":"47px","default-title-font-weight":"600","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"17px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"0","default-title-background":"8234","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"custom","default-blog-title-top-padding":"104px","default-blog-title-bottom-padding":"105px","default-blog-feature-image":"none","default-blog-title-background-image":"7505","default-blog-top-bottom-gradient":"bottom","single-blog-title-top-gradient-size":"325px","single-blog-title-bottom-gradient-size":"346px","default-blog-title-background-overlay-opacity":"2","blog-style":"style-4","blockquote-style":"style-1","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar2","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"30","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"full","related-post-num-fetch":"2","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar2","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar3","woocommerce-archive-product-style":"grid-2","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"20","woocommerce-related-product-num-fetch":"3","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"45px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-text":"","copyright-left":"[gdlr_core_social_network facebook=\"#url\" twitter=\"#url\" linkedin=\"#\" skype=\"#\"  icon-size=\"17px\" icon-color=\"#4D93E9\" ]","copyright-right":"Copyright 2019 Mediz, All Right Reserved","enable-back-to-top":"disable","top-bar-right-button-icon-class":"fa fa-comment-o","top-bar-right-button-text":"Free consultant","top-bar-right-button-link":"\/attorna\/contact\/","top-bar-right-button-link-target":"_self","top-bar-shadow-size":"","top-bar-shadow-color":"","header-shadow-size":"24px","header-shadow-color":"#000","enable-logo":"enable","navigation-slide-bar-width":"","navigation-slide-bar-height":"","main-navigation-search-icon":"icon-magnifier","main-navigation-search-icon-top-margin":"-2px","main-navigation-cart-icon":"icon-bag","main-navigation-cart-icon-top-margin":"-2px","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","enable-fixed-navigation-slide-bar":"enable","fixed-navigation-slide-bar-top-margin":"-18","blog-title-style":"","single-portfolio-navigation-middle-link":"#","logo-right-box1-icon":"icon-check","logo-right-box1-title":"Trusted By","logo-right-box1-caption":"120,000+  People","logo-right-box2-icon":"icon-check","logo-right-box2-title":"Best Hospital","logo-right-box2-caption":"U.K. News","logo-right-box3-icon":"icon-check","logo-right-box3-title":"Number #1","logo-right-box3-caption":"Clinic in London","fixed-navigation-right-top-margin":"5"},"mediz_typography":{"heading-font":"Poppins","navigation-font":"Poppins","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Montserrat","testimonial-font":"Merriweather","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"47px","h2-font-size":"41px","h3-font-size":"30px","h4-font-size":"24px","h5-font-size":"21px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"15px","navigation-font-weight":"500","navigation-font-letter-spacing":"0px","navigation-text-transform":"none","navigation-right-button-font-size":"12px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"17px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"16px","copyright-font-weight":"400","copyright-font-letter-spacing":"1","copyright-text-transform":"uppercase","font-upload":"","google-font-display":"optional","sub-navigation-font-size":""},"mediz_color":{"header-background-color":"#ffffff","top-cart-background-color":"#232323","top-cart-checkout-color":"#4d93e9","secondary-menu-icon-color":"#545454","secondary-menu-border-color":"#3f3f3f","main-menu-text-hover-color":"#4d93e9","sub-menu-background-color":"#f4f4f4","navigation-bar-right-icon-color":"#b0b0b0","main-menu-text-color":"#999999","woocommerce-theme-color":"#4d93e9","woocommerce-price-color":"#707070","woocommerce-button-background-hover-color":"#4d93e9","add-to-cart-background-color":"#4d93e9","widget-price-filter-range-color":"#8bb4e8","widget-price-filter-handle-color":"#4d93e9","top-bar-social-hover-color":"#d1e9fc","navigation-slide-bar-color":"#4d93e9","woocommerce-cart-icon-number-background":"#4d93e9","woocommerce-cart-icon-number-color":"#ffffff","top-bar-background-color":"#4d93e9","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#d1e9fc","top-bar-social-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","logo-background-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#323232","breadcrumbs-text-color":"#969696","breadcrumbs-text-active-color":"#4d93e9","navigation-bar-background-color":"#ffffff","navigation-bar-top-border-color":"#e8e8e8","sub-menu-text-color":"#7a7a7a","sub-menu-text-hover-color":"#4d93e9","sub-menu-text-hover-background-color":"#f4f4f4","sub-mega-menu-title-color":"#4d93e9","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-text-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#e2f1ff","navigation-right-button-background-color":"#4d93e9","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#4d93e9","navigation-right-button-border-hover-color":"#4d93e9","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#bbd1ff","page-title-background-overlay-color":"#000000","body-content-color":"#555555","heading-color":"#161616","link-color":"#3d3d3d","link-hover-color":"#606060","divider-color":"#e6e6e6","input-box-background-color":"#f7f7f7","input-box-border-color":"#e0e0e0","input-box-text-color":"#979797","input-box-placeholder-color":"#979797","404-content-background-color":"#17449e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#96b7e8","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#4d93e9","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#727272","search-box-border-color":"#f3f3f3","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#4d93e9","custom-menu-widget-list-style-link-hover":"#4d93e9","custom-menu-widget-list-style-border":"#4d93e9","footer-background-color":"#f6f6f6","footer-title-color":"#020202","footer-content-color":"#8b8b8b","footer-link-color":"#919191","footer-link-hover-color":"#4d93e9","footer-divider-color":"#dddddd","copyright-background-color":"#ffffff","copyright-text-color":"#afafaf","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#4d93e9","single-blog-navigation-color":"#4d93e9","single-blog-navigation2-left-overlay":"#4d93e9","single-blog-navigation2-overlay":"#4d93e9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#4d93e9","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#191919","blog-title-hover-color":"#4d93e9","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#4d93e9","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#4d93e9","blog-thumbnail-category-background":"#4d93e9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#4d93e9","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#4d93e9","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#828282","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#4d93e9","portfolio-badge-text-color":"#0a0a0a","portfolio-badge-background-color":"#4d93e9","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#161616","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#191919","portfolio-button-filter-background-active-color":"#4d93e9","price-table-background-color":"#ffffff","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#3e3e3e","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#c0cfe8","price-table-price-background-color":"#f6f6f6","price-table-price-color":"#323232","price-table-price-suffix-color":"#191919","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#383838","price-table-button-background-top-gradient-color":"#383838","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#4d93e9","price-table-active-head-top-gradient-color":"#4d93e9","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff3f2","price-table-active-price-background-color":"#f6f6f6","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#191919","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#4d93e9","price-table-active-button-background-top-gradient-color":"#4d93e9","accordion-normal-icon-color":"#4c4c4c","accordion-normal-title-head-color":"#4c4c4c","accordion-normal-title-color":"#4c4c4c","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#989898","accordion-title-head-color":"#191919","accordion-title-color":"#4d93e9","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#4d93e9","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#b1976b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#b1976b","blockquote-item-content-color":"#1c1c1c","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#4d93e9","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#4d93e9","button-top-gradient-background-color":"#207ae8","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#7d7d7d","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#4d93e9","dropdown-tab-head-text":"#252525","flipbox-background-color":"#4d93e9","flipbox-border-color":"#4d93e9","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#141414","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#4d93e9","personnel-grid-position-color":"#9d9d9d","personnel-grid-divider-color":"#4d93e9","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#d8c0b1","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#ddc5b5","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#b1976b","roadmap-number-active-text":"#b1976b","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#ddc5b5","roadmap-content-color":"#ddc5b5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#4d93e9","slider-outer-navigation-color":"#4d93e9","slider-outer-navigation-background-color":"#ffffff","slider-control-navigation-color":"#8a8a8a","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#4d93e9","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#4d93e9","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#161616","title-item-caption-color":"#747474","woocommerce-price-linethrough-color":"#949494","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","widget-price-filter-bar-background-color":"#e6e6e6","skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#a1a1a1","content":"#ffffff","icon":"#ffffff","link":"#4d93e9","link-hover":"#94b8e8","divider":"","border":"","element-background":"#111111","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"","caption":"#5db0b8","content":"","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#5db0b8","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#373737","element-background":"#373737","element-content":"#989898","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter White","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#ffffff","element-background":"#ffffff","element-content":"#969696","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-dpment","title":"#4d93e9","title-hover":"","caption":"","content":"#606060","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-dpment","title":"#4d93e9","title-hover":"#4d93e9","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#4d93e9","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-doc-dpment","title":"#4d93e9","title-hover":"","caption":"","content":"#a0bfe8","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Lung Diseases","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"#4d93e9","link-hover":"","divider":"#4d93e9","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Counter","title":"#ffffff","title-hover":"","caption":"","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#4d93e9","link-hover":"#4d93e9","divider":"","border":"","element-background":"#4d93e9","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 contact form","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Accordion","title":"#93d9ff","title-hover":"","caption":"#bcdbff","content":"#bcdbff","icon":"#ffffff","link":"","link-hover":"","divider":"#5c79b3","border":"#5c79b3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Input","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A1 Column SVC","title":"#a6c4ff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVC","title":"#171717","title-hover":"","caption":"#757575","content":"#757575","icon":"#748ec4","link":"#748ec4","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVS MId","title":"#343434","title-hover":"","caption":"#797979","content":"#797979","icon":"#4d93e9","link":"#4d93e9","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blockqoute","title":"","title-hover":"","caption":"#4d93e9","content":"#4e4e4e","icon":"#4d93e9","link":"","link-hover":"#a1a1a1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-ls","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Blog Featured","title":"","title-hover":"","caption":"#a7a7a7","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Column SVC Bottom","title":"#ffffff","title-hover":"","caption":"#ccd7ec","content":"#ccd7ec","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Column SVC","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team Page","title":"#ffffff","title-hover":"","caption":"#b0c9e8","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#b2cae8","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"couter-Ourdoc","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-ourdoc","title":"#4d93e9","title-hover":"","caption":"","content":"#8f8f8f","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#4d93e9","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"col-clinic","title":"#ffffff","title-hover":"","caption":"","content":"#cbe3ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dentist Contact Form ","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personal HP Dentist","title":"","title-hover":"","caption":"#a1a1a1","content":"#a1a1a1","icon":"","link":"","link-hover":"","divider":"#4d93e9","border":"","element-background":"#5e9eeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Counter","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Accordion","title":"#4d93e9","title-hover":"","caption":"#8f8f8f","content":"#8f8f8f","icon":"#4d93e9","link":"","link-hover":"","divider":"#d9d9d9","border":"#d9d9d9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"letterbgwhite","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Clinic Contact Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f3f3f3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"blog-grid-divider-color":"#ffd115","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#4d93e9","tag-cloud-border-color":"#4d93e9","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","fixed-navigation-background-color":"","logo-bottom-border-color":"#b39a96","load-more-button-text":"#968481","load-more-button-border":"#968481","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#000000","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#4d93e9","custom-menu-widget-box-style-text-active":"#ffffff","top-bar-right-button-background":"#b1976b","navigation-right-button-shadow-color":"#000","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#4275dc","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#2653e3","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7","testimonial-frame-background-color":"#ffffff","custom-menu-widget-list2-style-icon":"#888888","header-bar-right-text-icon":"#93b3f1","header-bar-right-text-title":"#4d93e9","header-bar-right-text-caption":"#9f9f9f","blog-widget-feature-background-color":"#4d93e9","blog-widget-feature-title-color":"#ffffff","blog-widget-feature-info-color":"#d7e9ff"},"mediz_plugin":{"enable-srcset":"enable","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Gallery Portrait","width":"500","height":"600","hard-crop":""},{"name":"Port Large","width":"1500","height":"590","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"7684","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font","ionicons","simpleline"],"additional-body-script":""}}'
				),
				'dentist2' => array(
					'title' => esc_html__('Dentist 2', 'mediz'),
					'url' => 'https://demo.goodlayers.com/mediz/dentist2',
					'xml' => get_template_directory() . '/admin/function/files/dentist2.xml',
					'page' => 7684,
					'menu' => array('main_menu' => 70, 'mobile_menu' => 70),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Blog","id":"gdlr-core-sidebar"},{"name":"Blog Left","id":"gdlr-core-sidebar1"},{"name":"Blog Right","id":"gdlr-core-sidebar2"},{"name":"Shop","id":"gdlr-core-sidebar3"},{"name":"Quick Links","id":"gdlr-core-sidebar4"},{"name":"Department - Lung","id":"gdlr-core-sidebar5"},{"name":"Department - Heart","id":"gdlr-core-sidebar6"},{"name":"Department - Orthopaedic","id":"gdlr-core-sidebar7"},{"name":"Department - General Surgery","id":"gdlr-core-sidebar8"},{"name":"Department - Pharmacy","id":"gdlr-core-sidebar9"},{"name":"Department - Sport Injury","id":"gdlr-core-sidebar10"},{"name":"Department - Flu & Fever","id":"gdlr-core-sidebar11"},{"name":"Department - Dental","id":"gdlr-core-sidebar12"},{"name":"Department - Eye Care","id":"gdlr-core-sidebar13"}],"sidebars_widgets":{"wp_inactive_widgets":["gdlr-core-custom-menu-widget-3","text-6","gdlr-core-custom-menu-widget-4"],"gdlr-core-sidebar-preset":["recent-posts-2"],"footer-1":["text-1"],"footer-2":["text-35"],"footer-3":["gdlr-core-custom-menu-widget-16"],"footer-4":["gdlr-core-newsletter-widget-2"],"gdlr-core-sidebar":["text-5","recent-comments-3","tag_cloud-2"],"gdlr-core-sidebar1":["text-4","recent-posts-3","gdlr-core-recent-comment-widget-2"],"gdlr-core-sidebar2":["gdlr-core-recent-post-widget-1","tag_cloud-1","text-3","gdlr-core-custom-menu-widget-2"],"gdlr-core-sidebar3":[],"gdlr-core-sidebar4":[],"gdlr-core-sidebar5":["gdlr-core-custom-menu-widget-15","text-7","gdlr-core-opening-hour-widget-2","text-8"],"gdlr-core-sidebar6":["gdlr-core-custom-menu-widget-7","text-27","gdlr-core-opening-hour-widget-4","text-11"],"gdlr-core-sidebar7":["gdlr-core-custom-menu-widget-8","text-28","gdlr-core-opening-hour-widget-5","text-14"],"gdlr-core-sidebar8":["gdlr-core-custom-menu-widget-9","text-29","gdlr-core-opening-hour-widget-6","text-16"],"gdlr-core-sidebar9":["gdlr-core-custom-menu-widget-10","text-30","gdlr-core-opening-hour-widget-7","text-18"],"gdlr-core-sidebar10":["gdlr-core-custom-menu-widget-11","text-31","gdlr-core-opening-hour-widget-8","text-20"],"gdlr-core-sidebar11":["gdlr-core-custom-menu-widget-12","text-32","gdlr-core-opening-hour-widget-9","text-22"],"gdlr-core-sidebar12":["gdlr-core-custom-menu-widget-13","text-33","gdlr-core-opening-hour-widget-10","text-24"],"gdlr-core-sidebar13":["gdlr-core-custom-menu-widget-14","text-34","gdlr-core-opening-hour-widget-11","text-26"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Our Services","menu":"58","style":"list"},"3":{"title":"Case Study","menu":"75","style":"list"},"4":{"title":"Practice Areas","menu":"73","style":"list"},"7":{"title":"Heart Diseases","menu":"63","style":"list2"},"8":{"title":"Orthopaedic","menu":"64","style":"list2"},"9":{"title":"General Surgery","menu":"65","style":"list2"},"10":{"title":"Pharmacy","menu":"63","style":"list2"},"11":{"title":"Sport Injury","menu":"63","style":"list2"},"12":{"title":"Flu & Fever","menu":"63","style":"list2"},"13":{"title":"Dental","menu":"63","style":"list2"},"14":{"title":"Eye Care","menu":"63","style":"list2"},"15":{"title":"Lung Diseases","menu":"56","style":"list2"},"16":{"title":"Member Resources","menu":"69","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"2":{"title":" Our Newsletter","style":"style-2","icon-color":"#4cd4ca"},"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"2":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"4":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"5":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"6":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"7":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"8":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"9":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"10":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"11":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"2":{"title":"Recent Comments","num-fetch":"3","num-excerpt":"15"},"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"1":{"title":"Recent Articles","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"3":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"","text":"[gdlr_core_space height=\"-6px\"]<img class=\"alignnone size-full\" src=\"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/logo-footer.png\" alt=\"\" width=\"124\" \/>\r\n[gdlr_core_space height=\"-27px\"]\r\nExceptional primary care, designed\r\nfor real life\r\n\r\n[gdlr_core_icon icon=\"fa fa-facebook\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-youtube-play\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-linkedin\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ]\r\n","filter":true,"visual":true},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_space height=\"15px\"][gdlr_widget_box title=\"Let us help you!\" title-color=\"#b1976b\" background=\"https:\/\/demo.goodlayers.com\/attorna\/wp-content\/uploads\/2019\/02\/sidebar-contact-bg.jpg\" color=\"#b8b8b8\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"50px 37px 30px 43px\" font-size=\"19px\"]If you need any helps, please feel free to contact us. We will get back to you with 1 business day. Or if in hurry, just call us now.\r\n\r\n<span style=\"font-size: 18px; color: #fff; font-weight: 500;\">Call : (1)2345-2345-54<\/span>\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"14px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Contact@Attornasite.co[gdlr_core_space height=\"7px\"][gdlr_core_icon icon=\"icon_clock_alt\" size=\"15px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Mon - Fri 09:00-17:00\r\n[\/gdlr_widget_box][gdlr_core_space height=\"20px\"]\r\n\r\n[gdlr_core_button button-text=\"Firm\u2019s Presentation\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"left\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"solid\" border-radius=\"3px\" background-color= \"#b1976b\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"7":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"8":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient-v\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"11":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"14":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"16":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"18":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"20":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"22":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"24":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"26":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"27":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"28":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"29":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"30":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"31":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"32":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"33":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"34":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"35":{"title":"Contact Centre","text":"[gdlr_core_icon icon=\"ion-ios-telephone\" size=\"19px\" color=\"#4cd4ca\" margin-left=\"\" margin-right=\"10px\"](+1) 212-946-2707\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"ion-ios-location\" size=\"19px\" color=\"#4cd4ca\" margin-left=\"3px\" margin-right=\"10px\" ]112 W 34th St, New York\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"ion-ios-clock\" size=\"19px\" color=\"#4cd4ca\" margin-left=\"\" margin-right=\"10px\" ]Mon - Fri: 8.00am 6.00pm","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"1":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"1":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0,"max_depth":""},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"1":{"title":"Recent Products","number":4,"show":"","orderby":"date","order":"desc","hide_free":0,"show_hidden":0},"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"1":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_zeno_fr_widget":{"1":[],"_multiwidget":1}}',
					'theme-option' => '{"mediz_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_icon icon=\"ion-location\" size=\"20px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ]112 W 34th St, New York\n[gdlr_core_icon icon=\"ion-ios-telephone\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]212-946-2707[gdlr_core_icon icon=\"ion-ios-clock\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]Mon - Fri:  9:00AM - 8:00PM","top-bar-right-text":"","top-bar-top-padding":"9px","top-bar-bottom-padding":"9px","top-bar-text-size":"16px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"1px","header-bar-navigation-align":"left","header-background-style":"transparent","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"16px","navigation-left-offset":"0","navigation-slide-bar":"style-2","navigation-slide-bar-top-margin":"-5px","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"40px","logo":"8293","logo-top-padding":"28px","logo-bottom-padding":"20px","logo-left-padding":"","max-logo-width":"125px","mobile-logo":"","max-tablet-logo-width":"125px","max-mobile-logo-width":"110px","mobile-logo-position":"logo-left","main-navigation-top-padding":"37px","main-navigation-bottom-padding":"39px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"2","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"enable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Contact Now","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-type":"overlay","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"80px","fixed-navigation-logo-top-padding":"17","fixed-navigation-logo-bottom-padding":"17","fixed-navigation-top-padding":"23","fixed-navigation-bottom-padding":"23","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"110px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"17px","default-title-font-transform":"none","default-title-font-size":"47px","default-title-font-weight":"600","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"17px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"11","default-title-background":"8301","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"custom","default-blog-title-top-padding":"104px","default-blog-title-bottom-padding":"105px","default-blog-feature-image":"none","default-blog-title-background-image":"7505","default-blog-top-bottom-gradient":"bottom","single-blog-title-top-gradient-size":"325px","single-blog-title-bottom-gradient-size":"346px","default-blog-title-background-overlay-opacity":"2","blog-style":"style-4","blockquote-style":"style-1","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar2","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"30","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"full","related-post-num-fetch":"2","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar2","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar3","woocommerce-archive-product-style":"grid-2","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"Personnel Square","woocommerce-related-product-column-size":"20","woocommerce-related-product-num-fetch":"3","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"56px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"center","copyright-top-padding":"0px","copyright-bottom-padding":"22px","copyright-text":"Copyright \u00a92019 Mediz. All Rights Reserved. <a href=\"#\">Legal and Privacy<\/a>.","copyright-left":"[gdlr_core_social_network facebook=\"#url\" twitter=\"#url\" linkedin=\"#\" skype=\"#\"  icon-size=\"17px\" icon-color=\"#17449E\" ]","copyright-right":"Copyright 2019 Mediz, All Right Reserved","enable-back-to-top":"disable","top-bar-right-button-icon-class":"fa fa-comment-o","top-bar-right-button-text":"Free consultant","top-bar-right-button-link":"\/attorna\/contact\/","top-bar-right-button-link-target":"_self","top-bar-shadow-size":"0","top-bar-shadow-color":"#0a0a0a","header-shadow-size":"0px","header-shadow-color":"#000","enable-logo":"enable","navigation-slide-bar-width":"","navigation-slide-bar-height":"5","main-navigation-search-icon":"icon-magnifier","main-navigation-search-icon-top-margin":"-4","main-navigation-cart-icon":"icon-bag","main-navigation-cart-icon-top-margin":"-4","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","enable-fixed-navigation-slide-bar":"enable","fixed-navigation-slide-bar-top-margin":"-18","blog-title-style":"","single-portfolio-navigation-middle-link":"#","logo-right-box1-icon":"icon-check","logo-right-box1-title":"Trusted By","logo-right-box1-caption":"120,000+  People","logo-right-box2-icon":"icon-check","logo-right-box2-title":"Best Hospital","logo-right-box2-caption":"U.K. News","logo-right-box3-icon":"icon-check","logo-right-box3-title":"Number #1","logo-right-box3-caption":"Clinic in London","fixed-navigation-right-top-margin":"2px"},"mediz_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","testimonial-font":"Merriweather","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"47px","h2-font-size":"41px","h3-font-size":"30px","h4-font-size":"24px","h5-font-size":"21px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"14px","navigation-font-weight":"500","navigation-font-letter-spacing":"1","navigation-text-transform":"uppercase","navigation-right-button-font-size":"12px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"17px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"400","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"}],"google-font-display":"optional","sub-navigation-font-size":""},"mediz_color":{"header-background-color":"#373a48","top-cart-background-color":"#5170ca","top-cart-checkout-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#f4f4f4","navigation-bar-right-icon-color":"#ffffff","main-menu-text-color":"#ffffff","woocommerce-theme-color":"#5170ca","woocommerce-price-color":"#707070","woocommerce-button-background-hover-color":"#5170ca","add-to-cart-background-color":"#5170ca","widget-price-filter-range-color":"#a3acc9","widget-price-filter-handle-color":"#5170ca","top-bar-social-hover-color":"#d0d5e8","navigation-slide-bar-color":"#ffffff","woocommerce-cart-icon-number-background":"#5170ca","woocommerce-cart-icon-number-color":"#ffffff","top-bar-background-color":"#5170ca","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#d0d5e8","top-bar-social-color":"#ffffff","header-plain-bottom-border-color":"#b7b7b7","logo-background-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#323232","breadcrumbs-text-color":"#969696","breadcrumbs-text-active-color":"#5170ca","navigation-bar-background-color":"#ffffff","navigation-bar-top-border-color":"#ffffff","sub-menu-text-color":"#7a7a7a","sub-menu-text-hover-color":"#5170ca","sub-menu-text-hover-background-color":"#f4f4f4","sub-mega-menu-title-color":"#5170ca","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-text-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#e1efee","navigation-right-button-background-color":"#4cd4ca","navigation-right-button-background-hover-color":"#55c6bb","navigation-right-button-border-color":"#4cd4ca","navigation-right-button-border-hover-color":"#55c6bb","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#d6d6d6","page-title-background-overlay-color":"#000000","body-content-color":"#555555","heading-color":"#161616","link-color":"#3d3d3d","link-hover-color":"#606060","divider-color":"#e6e6e6","input-box-background-color":"#f7f7f7","input-box-border-color":"#e5e5e5","input-box-text-color":"#979797","input-box-placeholder-color":"#979797","404-content-background-color":"#17449e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#96b7e8","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#5170ca","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#727272","search-box-border-color":"#f3f3f3","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#5170ca","custom-menu-widget-list-style-link-hover":"#5170ca","custom-menu-widget-list-style-border":"#5170ca","footer-background-color":"#f8faff","footer-title-color":"#020202","footer-content-color":"#373737","footer-link-color":"#373737","footer-link-hover-color":"#5170ca","footer-divider-color":"#dddddd","copyright-background-color":"#f8faff","copyright-text-color":"#6b7a90","copyright-link-color":"#5170ca","copyright-link-hover-color":"#8497c9","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#5170ca","single-blog-navigation-color":"#5170ca","single-blog-navigation2-left-overlay":"#5170ca","single-blog-navigation2-overlay":"#5170ca","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#5170ca","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#191919","blog-title-hover-color":"#5170ca","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#5170ca","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#5170ca","blog-thumbnail-category-background":"#5170ca","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#5170ca","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#5170ca","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#828282","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#5170ca","portfolio-badge-text-color":"#0a0a0a","portfolio-badge-background-color":"#5170ca","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#161616","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#191919","portfolio-button-filter-background-active-color":"#5170ca","price-table-background-color":"#ffffff","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#3e3e3e","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#c0cfe8","price-table-price-background-color":"#f6f6f6","price-table-price-color":"#323232","price-table-price-suffix-color":"#191919","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#383838","price-table-button-background-top-gradient-color":"#383838","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#5170ca","price-table-active-head-top-gradient-color":"#5170ca","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff3f2","price-table-active-price-background-color":"#f6f6f6","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#191919","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#5170ca","price-table-active-button-background-top-gradient-color":"#5170ca","accordion-normal-icon-color":"#4c4c4c","accordion-normal-title-head-color":"#4c4c4c","accordion-normal-title-color":"#4c4c4c","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#989898","accordion-title-head-color":"#191919","accordion-title-color":"#5170ca","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#5170ca","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#5170ca","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#5170ca","blockquote-item-content-color":"#1c1c1c","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#5170ca","button-background-hover-color":"#6a82c9","button-border-color":"#5170ca","button-border-hover-color":"#8095c9","button-gradient-background-color":"#5170ca","button-top-gradient-background-color":"#5170ca","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#7d7d7d","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#5170ca","dropdown-tab-head-text":"#252525","flipbox-background-color":"#5170ca","flipbox-border-color":"#5170ca","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#141414","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#5170ca","personnel-grid-position-color":"#9d9d9d","personnel-grid-divider-color":"#5170ca","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#d8c0b1","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#ddc5b5","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#b1976b","roadmap-number-active-text":"#b1976b","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#ddc5b5","roadmap-content-color":"#ddc5b5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#5170ca","slider-outer-navigation-color":"#5170ca","slider-outer-navigation-background-color":"#ffffff","slider-control-navigation-color":"#8a8a8a","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#5170ca","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#5170ca","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#161616","title-item-caption-color":"#747474","woocommerce-price-linethrough-color":"#949494","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#0a0a0a","add-to-cart-text-color":"#ffffff","widget-price-filter-bar-background-color":"#e6e6e6","skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#a1a1a1","content":"#ffffff","icon":"#ffffff","link":"#4d93e9","link-hover":"#94b8e8","divider":"","border":"","element-background":"#111111","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"","caption":"#5db0b8","content":"","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#5db0b8","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#373737","element-background":"#373737","element-content":"#989898","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter White","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#ffffff","element-background":"#ffffff","element-content":"#969696","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-dpment","title":"#17449e","title-hover":"","caption":"","content":"#606060","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-dpment","title":"#4d93e9","title-hover":"#4d93e9","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#4d93e9","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-doc-dpment","title":"#17449e","title-hover":"","caption":"","content":"#7c92bd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Lung Diseases","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"#4d93e9","link-hover":"","divider":"#4d93e9","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Counter","title":"#ffffff","title-hover":"","caption":"","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#17449e","link-hover":"#4d93e9","divider":"","border":"","element-background":"#17449e","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 contact form","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Accordion","title":"#93d9ff","title-hover":"","caption":"#bcdbff","content":"#bcdbff","icon":"#ffffff","link":"","link-hover":"","divider":"#5c79b3","border":"#5c79b3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Input","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A1 Column SVC","title":"#a6c4ff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVC","title":"#171717","title-hover":"","caption":"#757575","content":"#757575","icon":"#748ec4","link":"#748ec4","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVS MId","title":"#343434","title-hover":"","caption":"#797979","content":"#797979","icon":"#17449e","link":"#17449e","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blockqoute","title":"","title-hover":"","caption":"#17449e","content":"#4e4e4e","icon":"#17449e","link":"","link-hover":"#a1a1a1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-ls","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Blog Featured","title":"","title-hover":"","caption":"#a7a7a7","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Column SVC Bottom","title":"#ffffff","title-hover":"","caption":"#ccd7ec","content":"#ccd7ec","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Column SVC","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team Page","title":"#ffffff","title-hover":"","caption":"#b0c9e8","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#b2cae8","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"couter-Ourdoc","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-ourdoc","title":"#17449e","title-hover":"","caption":"","content":"#8f8f8f","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#17449e","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"col-clinic","title":"#ffffff","title-hover":"","caption":"","content":"#cbe3ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dentist Contact Form ","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personal HP Dentist","title":"","title-hover":"","caption":"#a1a1a1","content":"#a1a1a1","icon":"","link":"","link-hover":"","divider":"#4d93e9","border":"","element-background":"#5e9eeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Counter","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Accordion","title":"#4d93e9","title-hover":"","caption":"#8f8f8f","content":"#8f8f8f","icon":"#4d93e9","link":"","link-hover":"","divider":"#d9d9d9","border":"#d9d9d9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"letterbgwhite","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Clinic Contact Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f3f3f3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"About Dentist 2 Counter","title":"#4cd4ca","title-hover":"","caption":"#222222","content":"#222222","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"blog-grid-divider-color":"#ffd115","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#5170ca","tag-cloud-border-color":"#5170ca","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","fixed-navigation-background-color":"","logo-bottom-border-color":"#b39a96","load-more-button-text":"#968481","load-more-button-border":"#968481","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#5170ca","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#5170ca","custom-menu-widget-box-style-text-active":"#ffffff","top-bar-right-button-background":"#b1976b","navigation-right-button-shadow-color":"#000","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#5170ca","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#5170ca","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7","testimonial-frame-background-color":"#ffffff","custom-menu-widget-list2-style-icon":"#888888","header-bar-right-text-icon":"#93b3f1","header-bar-right-text-title":"#5170ca","header-bar-right-text-caption":"#9f9f9f","blog-widget-feature-background-color":"17449e","blog-widget-feature-title-color":"#ffffff","blog-widget-feature-info-color":"#6a82c9"},"mediz_plugin":{"enable-srcset":"disable","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Gallery Portrait","width":"500","height":"600","hard-crop":""},{"name":"Port Large","width":"1500","height":"590","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"7684","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font","ionicons","simpleline"],"additional-body-script":""}}'
				),
				'clinic' => array(
					'title' => esc_html__('Clinic', 'mediz'),
					'url' => 'https://demo.goodlayers.com/mediz/clinic/',
					'xml' => get_template_directory() . '/admin/function/files/clinic.xml',
					'page' => 8081,
					'menu' => array('main_menu' => 27, 'mobile_menu' => 27),
					'widget' => '{"mediz_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"disable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_icon icon=\"icon-clock\" size=\"18px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ]Mon - Sun  0900 - 2100\n[gdlr_core_icon icon=\"icon-phone\" size=\"19px\" color=\"#17449E\" margin-left=\"25px\" margin-right=\"10px\" ]+1-2345-3455-33[gdlr_core_icon icon=\"icon-envelope\" size=\"19px\" color=\"#17449E\" margin-left=\"25px\" margin-right=\"10px\" ]<a href=\"mailto:contact@mediztheme.co\">contact@mediztheme.co<\/a> ","top-bar-right-text":"","top-bar-top-padding":"19px","top-bar-bottom-padding":"19px","top-bar-text-size":"15px","top-bar-bottom-border":"2px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-left-offset":"0","navigation-slide-bar":"style-2","navigation-slide-bar-top-margin":"-28px","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"40px","logo":"8230","logo-top-padding":"29px","logo-bottom-padding":"18px","logo-left-padding":"","max-logo-width":"145px","mobile-logo":"","max-tablet-logo-width":"150px","max-mobile-logo-width":"120px","mobile-logo-position":"logo-left","main-navigation-top-padding":"28px","main-navigation-bottom-padding":"33px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"","enable-main-navigation-search":"disable","enable-main-navigation-cart":"disable","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"round","main-navigation-right-button-text":"Contact Now","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-type":"overlay","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"disable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"17","fixed-navigation-logo-bottom-padding":"17","fixed-navigation-top-padding":"23","fixed-navigation-bottom-padding":"23","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"110px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"17px","default-title-font-transform":"none","default-title-font-size":"47px","default-title-font-weight":"600","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"17px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"0","default-title-background":"8229","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"custom","default-blog-title-top-padding":"104px","default-blog-title-bottom-padding":"105px","default-blog-feature-image":"none","default-blog-title-background-image":"7505","default-blog-top-bottom-gradient":"bottom","single-blog-title-top-gradient-size":"325px","single-blog-title-bottom-gradient-size":"346px","default-blog-title-background-overlay-opacity":"2","blog-style":"style-4","blockquote-style":"style-1","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar2","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"30","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"full","related-post-num-fetch":"2","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar2","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar3","woocommerce-archive-product-style":"grid-2","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"20","woocommerce-related-product-num-fetch":"3","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"45px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-text":"","copyright-left":"[gdlr_core_social_network facebook=\"#url\" twitter=\"#url\" linkedin=\"#\" skype=\"#\"  icon-size=\"17px\" icon-color=\"#17449E\" ]","copyright-right":"Copyright 2019 Mediz, All Right Reserved","enable-back-to-top":"disable","top-bar-right-button-icon-class":"fa fa-comment-o","top-bar-right-button-text":"Free consultant","top-bar-right-button-link":"\/attorna\/contact\/","top-bar-right-button-link-target":"_self","top-bar-shadow-size":"24px","top-bar-shadow-color":"#0a0a0a","header-shadow-size":"","header-shadow-color":"","enable-logo":"enable","navigation-slide-bar-width":"","navigation-slide-bar-height":"","main-navigation-search-icon":"icon-magnifier","main-navigation-search-icon-top-margin":"-4","main-navigation-cart-icon":"icon-bag","main-navigation-cart-icon-top-margin":"-4","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","enable-fixed-navigation-slide-bar":"enable","fixed-navigation-slide-bar-top-margin":"-18","blog-title-style":"","single-portfolio-navigation-middle-link":"#","logo-right-box1-icon":"icon-check","logo-right-box1-title":"Trusted By","logo-right-box1-caption":"120,000+  People","logo-right-box2-icon":"icon-check","logo-right-box2-title":"Best Hospital","logo-right-box2-caption":"U.K. News","logo-right-box3-icon":"icon-check","logo-right-box3-title":"Number #1","logo-right-box3-caption":"Clinic in London","fixed-navigation-right-top-margin":"5"},"mediz_typography":{"heading-font":"Poppins","navigation-font":"Poppins","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Montserrat","testimonial-font":"Merriweather","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"47px","h2-font-size":"41px","h3-font-size":"30px","h4-font-size":"24px","h5-font-size":"21px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"15px","navigation-font-weight":"500","navigation-font-letter-spacing":"0px","navigation-text-transform":"none","navigation-right-button-font-size":"12px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"17px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"16px","copyright-font-weight":"400","copyright-font-letter-spacing":"1","copyright-text-transform":"uppercase","font-upload":"","google-font-display":"optional","sub-navigation-font-size":""},"mediz_color":{"header-background-color":"#17449e","top-cart-background-color":"#232323","top-cart-checkout-color":"#4d93e9","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","main-menu-text-hover-color":"#17449e","sub-menu-background-color":"#f4f4f4","navigation-bar-right-icon-color":"#b0b0b0","main-menu-text-color":"#8098c9","woocommerce-theme-color":"#4d93e9","woocommerce-price-color":"#707070","woocommerce-button-background-hover-color":"#4d93e9","add-to-cart-background-color":"#b1976b","widget-price-filter-range-color":"#b1976b","widget-price-filter-handle-color":"#af853b","top-bar-social-hover-color":"#4d93e9","navigation-slide-bar-color":"#dfdfdf","woocommerce-cart-icon-number-background":"#4d93e9","woocommerce-cart-icon-number-color":"#ffffff","top-bar-background-color":"#ffffff","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#17449e","top-bar-link-color":"#17449e","top-bar-link-hover-color":"#4d93e9","top-bar-social-color":"#17449e","header-plain-bottom-border-color":"#e8e8e8","logo-background-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#323232","breadcrumbs-text-color":"#969696","breadcrumbs-text-active-color":"#17449e","navigation-bar-background-color":"#ffffff","navigation-bar-top-border-color":"#e8e8e8","sub-menu-text-color":"#7a7a7a","sub-menu-text-hover-color":"#17449e","sub-menu-text-hover-background-color":"#f4f4f4","sub-mega-menu-title-color":"#17449e","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#c2d3e8","anchor-bullet-background-active-color":"#ffffff","navigation-right-text-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#d3dced","navigation-right-button-background-color":"#17449e","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#17449e","navigation-right-button-border-hover-color":"#17449e","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#bbd1ff","page-title-background-overlay-color":"#000000","body-content-color":"#555555","heading-color":"#161616","link-color":"#3d3d3d","link-hover-color":"#606060","divider-color":"#e6e6e6","input-box-background-color":"#f7f7f7","input-box-border-color":"#e0e0e0","input-box-text-color":"#979797","input-box-placeholder-color":"#979797","404-content-background-color":"#17449e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#96b7e8","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#4d93e9","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#727272","search-box-border-color":"#f3f3f3","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#17449e","custom-menu-widget-list-style-link-hover":"#4d93e9","custom-menu-widget-list-style-border":"#4d93e9","footer-background-color":"#f6f6f6","footer-title-color":"#020202","footer-content-color":"#8b8b8b","footer-link-color":"#919191","footer-link-hover-color":"#17449e","footer-divider-color":"#dddddd","copyright-background-color":"#ffffff","copyright-text-color":"#afafaf","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#4d93e9","single-blog-navigation-color":"#4d93e9","single-blog-navigation2-left-overlay":"#4d93e9","single-blog-navigation2-overlay":"#4d93e9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#4d93e9","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#191919","blog-title-hover-color":"#4d93e9","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#4d93e9","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#17449e","blog-thumbnail-category-background":"#4d93e9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#4d93e9","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#4d93e9","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#828282","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#4d93e9","portfolio-badge-text-color":"#0a0a0a","portfolio-badge-background-color":"#4d93e9","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#161616","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#191919","portfolio-button-filter-background-active-color":"#4d93e9","price-table-background-color":"#ffffff","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#3e3e3e","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#c0cfe8","price-table-price-background-color":"#f6f6f6","price-table-price-color":"#323232","price-table-price-suffix-color":"#191919","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#383838","price-table-button-background-top-gradient-color":"#383838","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#4d93e9","price-table-active-head-top-gradient-color":"#4d93e9","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff3f2","price-table-active-price-background-color":"#f6f6f6","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#191919","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#4d93e9","price-table-active-button-background-top-gradient-color":"#4d93e9","accordion-normal-icon-color":"#4c4c4c","accordion-normal-title-head-color":"#4c4c4c","accordion-normal-title-color":"#4c4c4c","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#989898","accordion-title-head-color":"#191919","accordion-title-color":"#4d93e9","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#4d93e9","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#b1976b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#b1976b","blockquote-item-content-color":"#1c1c1c","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#4d93e9","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#4d93e9","button-top-gradient-background-color":"#207ae8","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#7d7d7d","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#4d93e9","dropdown-tab-head-text":"#252525","flipbox-background-color":"#4d93e9","flipbox-border-color":"#4d93e9","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#141414","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#17449e","personnel-grid-position-color":"#9d9d9d","personnel-grid-divider-color":"#17449e","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#d8c0b1","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#ddc5b5","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#b1976b","roadmap-number-active-text":"#b1976b","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#ddc5b5","roadmap-content-color":"#ddc5b5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#4d93e9","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#ffffff","slider-control-navigation-color":"#8a8a8a","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#4d93e9","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#4d93e9","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#161616","title-item-caption-color":"#747474","woocommerce-price-linethrough-color":"#949494","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","widget-price-filter-bar-background-color":"#e6e6e6","skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#a1a1a1","content":"#ffffff","icon":"#ffffff","link":"#4d93e9","link-hover":"#94b8e8","divider":"","border":"","element-background":"#111111","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"","caption":"#5db0b8","content":"","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#5db0b8","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#373737","element-background":"#373737","element-content":"#989898","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter White","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#ffffff","element-background":"#ffffff","element-content":"#969696","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-dpment","title":"#17449e","title-hover":"","caption":"","content":"#606060","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-dpment","title":"#4d93e9","title-hover":"#4d93e9","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#4d93e9","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-doc-dpment","title":"#17449e","title-hover":"","caption":"","content":"#7c92bd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Lung Diseases","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"#4d93e9","link-hover":"","divider":"#4d93e9","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Counter","title":"#ffffff","title-hover":"","caption":"","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#17449e","link-hover":"#4d93e9","divider":"","border":"","element-background":"#17449e","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 contact form","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Accordion","title":"#93d9ff","title-hover":"","caption":"#bcdbff","content":"#bcdbff","icon":"#ffffff","link":"","link-hover":"","divider":"#5c79b3","border":"#5c79b3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Input","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A1 Column SVC","title":"#a6c4ff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVC","title":"#171717","title-hover":"","caption":"#757575","content":"#757575","icon":"#748ec4","link":"#748ec4","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVS MId","title":"#343434","title-hover":"","caption":"#797979","content":"#797979","icon":"#17449e","link":"#17449e","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blockqoute","title":"","title-hover":"","caption":"#17449e","content":"#4e4e4e","icon":"#17449e","link":"","link-hover":"#a1a1a1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-ls","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Blog Featured","title":"","title-hover":"","caption":"#a7a7a7","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Column SVC Bottom","title":"#ffffff","title-hover":"","caption":"#ccd7ec","content":"#ccd7ec","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Column SVC","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team Page","title":"#ffffff","title-hover":"","caption":"#b0c9e8","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#b2cae8","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"couter-Ourdoc","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-ourdoc","title":"#17449e","title-hover":"","caption":"","content":"#8f8f8f","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#17449e","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"col-clinic","title":"#ffffff","title-hover":"","caption":"","content":"#cbe3ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dentist Contact Form ","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personal HP Dentist","title":"","title-hover":"","caption":"#a1a1a1","content":"#a1a1a1","icon":"","link":"","link-hover":"","divider":"#4d93e9","border":"","element-background":"#5e9eeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Counter","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Accordion","title":"#4d93e9","title-hover":"","caption":"#8f8f8f","content":"#8f8f8f","icon":"#4d93e9","link":"","link-hover":"","divider":"#d9d9d9","border":"#d9d9d9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"letterbgwhite","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Clinic Contact Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f3f3f3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"blog-grid-divider-color":"#ffd115","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#4d93e9","tag-cloud-border-color":"#4d93e9","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","fixed-navigation-background-color":"","logo-bottom-border-color":"#b39a96","load-more-button-text":"#968481","load-more-button-border":"#968481","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#000000","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#4d93e9","custom-menu-widget-box-style-text-active":"#ffffff","top-bar-right-button-background":"#b1976b","navigation-right-button-shadow-color":"#000","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#4275dc","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#2653e3","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7","testimonial-frame-background-color":"#ffffff","custom-menu-widget-list2-style-icon":"#888888","header-bar-right-text-icon":"#93b3f1","header-bar-right-text-title":"#17449e","header-bar-right-text-caption":"#9f9f9f","blog-widget-feature-background-color":"17449e","blog-widget-feature-title-color":"#ffffff","blog-widget-feature-info-color":"#9ebeff"},"mediz_plugin":{"enable-srcset":"enable","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Gallery Portrait","width":"500","height":"600","hard-crop":""},{"name":"Port Large","width":"1500","height":"590","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"7684","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font","ionicons","simpleline"],"additional-body-script":""}}', 
					'theme-option' => '{"gdlrcst_sidebar_name":[{"name":"Blog","id":"gdlr-core-sidebar"},{"name":"Blog Left","id":"gdlr-core-sidebar1"},{"name":"Blog Right","id":"gdlr-core-sidebar2"},{"name":"Shop","id":"gdlr-core-sidebar3"},{"name":"Quick Links","id":"gdlr-core-sidebar4"},{"name":"Department - Lung","id":"gdlr-core-sidebar5"},{"name":"Department - Heart","id":"gdlr-core-sidebar6"},{"name":"Department - Orthopaedic","id":"gdlr-core-sidebar7"},{"name":"Department - General Surgery","id":"gdlr-core-sidebar8"},{"name":"Department - Pharmacy","id":"gdlr-core-sidebar9"},{"name":"Department - Sport Injury","id":"gdlr-core-sidebar10"},{"name":"Department - Flu & Fever","id":"gdlr-core-sidebar11"},{"name":"Department - Dental","id":"gdlr-core-sidebar12"},{"name":"Department - Eye Care","id":"gdlr-core-sidebar13"},{"name":"Chiropracitc","id":"gdlr-core-sidebar14"}],"sidebars_widgets":{"wp_inactive_widgets":["gdlr-core-custom-menu-widget-3","text-6","gdlr-core-custom-menu-widget-4"],"gdlr-core-sidebar-preset":["recent-posts-2"],"footer-1":["text-1"],"footer-2":["nav_menu-3"],"footer-3":["nav_menu-2"],"footer-4":["gdlr-core-opening-hour-widget-3","text-9"],"gdlr-core-sidebar":["text-5","recent-comments-3","tag_cloud-2"],"gdlr-core-sidebar1":["text-4","recent-posts-3","gdlr-core-recent-comment-widget-2"],"gdlr-core-sidebar2":["gdlr-core-recent-post-widget-1","tag_cloud-1","text-3","gdlr-core-custom-menu-widget-2"],"gdlr-core-sidebar3":[],"gdlr-core-sidebar4":[],"gdlr-core-sidebar5":["gdlr-core-custom-menu-widget-15","text-7","gdlr-core-opening-hour-widget-2","text-8"],"gdlr-core-sidebar6":["gdlr-core-custom-menu-widget-7","text-27","gdlr-core-opening-hour-widget-4","text-11"],"gdlr-core-sidebar7":["gdlr-core-custom-menu-widget-8","text-28","gdlr-core-opening-hour-widget-5","text-14"],"gdlr-core-sidebar8":["gdlr-core-custom-menu-widget-9","text-29","gdlr-core-opening-hour-widget-6","text-16"],"gdlr-core-sidebar9":["gdlr-core-custom-menu-widget-10","text-30","gdlr-core-opening-hour-widget-7","text-18"],"gdlr-core-sidebar10":["gdlr-core-custom-menu-widget-11","text-31","gdlr-core-opening-hour-widget-8","text-20"],"gdlr-core-sidebar11":["gdlr-core-custom-menu-widget-12","text-32","gdlr-core-opening-hour-widget-9","text-22"],"gdlr-core-sidebar12":["gdlr-core-custom-menu-widget-13","text-33","gdlr-core-opening-hour-widget-10","text-24"],"gdlr-core-sidebar13":[],"gdlr-core-sidebar14":["gdlr-core-custom-menu-widget-14","text-34","gdlr-core-opening-hour-widget-11","text-26"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Our Services","menu":"58","style":"list"},"3":{"title":"Case Study","menu":"75","style":"list"},"4":{"title":"Practice Areas","menu":"73","style":"list"},"7":{"title":"Heart Diseases","menu":"57","style":"list2"},"8":{"title":"Orthopaedic","menu":"60","style":"list2"},"9":{"title":"General Surgery","menu":"56","style":"list2"},"10":{"title":"Pharmacy","menu":"56","style":"list2"},"11":{"title":"Sport Injury","menu":"57","style":"list2"},"12":{"title":"Flu & Fever","menu":"58","style":"list2"},"13":{"title":"Dental","menu":"60","style":"list2"},"14":{"title":"Chiropractic Treatments","menu":"70","style":"list2"},"15":{"title":"Lung Diseases","menu":"58","style":"list2"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"2":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"3":{"title":"Hospital Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 18:00","day3-text":"Sunday","day3-time":"09:00 - 18:00","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"4":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"5":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"6":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"7":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"8":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"9":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"10":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"11":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"2":{"title":"Recent Comments","num-fetch":"3","num-excerpt":"15"},"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"1":{"title":"Recent Articles","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"2":{"title":"Our Services","nav_menu":61},"3":{"title":"About Us","nav_menu":55},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"3":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"","text":"<img class=\"alignnone size-full wp-image-6129\" src=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/logo-1.png\" alt=\"\" width=\"170\" \/>\r\n[gdlr_core_space height=\"-27px\"]\r\nBox 3233\r\n1810 Kings Way\r\nKing Street, 5th Avenue, New York\r\n[gdlr_core_space height=\"0px\"]\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"19px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ]<span style=\"color: #17449e;\">+1-2345-3455-33<\/span>\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"19px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ]<a href=\"mailto:contact@mediztheme.co\" style=\"color: #17449E;\">contact@mediztheme.co<\/a>","filter":true,"visual":true},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_space height=\"15px\"][gdlr_widget_box title=\"Let us help you!\" title-color=\"#b1976b\" background=\"https:\/\/demo.goodlayers.com\/attorna\/wp-content\/uploads\/2019\/02\/sidebar-contact-bg.jpg\" color=\"#b8b8b8\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"50px 37px 30px 43px\" font-size=\"19px\"]If you need any helps, please feel free to contact us. We will get back to you with 1 business day. Or if in hurry, just call us now.\r\n\r\n<span style=\"font-size: 18px; color: #fff; font-weight: 500;\">Call : (1)2345-2345-54<\/span>\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"14px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Contact@Attornasite.co[gdlr_core_space height=\"7px\"][gdlr_core_icon icon=\"icon_clock_alt\" size=\"15px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Mon - Fri 09:00-17:00\r\n[\/gdlr_widget_box][gdlr_core_space height=\"20px\"]\r\n\r\n[gdlr_core_button button-text=\"Firm\u2019s Presentation\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"left\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"solid\" border-radius=\"3px\" background-color= \"#b1976b\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"7":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"8":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient-v\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"9":{"title":"","text":"[gdlr_core_space height=\"-23px\"][gdlr_core_button button-text=\"Emergency : 24 hours\" button-link=\"\/mediz\/hospital\/contact\/\" button-link-target=\"_blank\" margin-right=\"0px\" button-background=\"solid\" background-color=\"#ffffff\" text-color=\"#17449E\" border-radius=\"0px\" text-font-weight=\"700\" text-size=\"16px\" text-transform=\"none\" text-letter-spacing=\"0px\" padding=\"14px 50px 17px 50px\" button-shadow-size=\"0px 0px 30px\" button-shadow-color=\"#000\" button-shadow-opacity=\"0.1\" ]","filter":true,"visual":true},"11":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"14":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"16":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"18":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"20":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"22":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"24":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"26":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"27":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"28":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"29":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"30":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"31":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"32":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"33":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"34":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449E;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449E;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"1":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"1":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0,"max_depth":""},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"1":{"title":"Recent Products","number":4,"show":"","orderby":"date","order":"desc","hide_free":0,"show_hidden":0},"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"1":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_zeno_fr_widget":{"1":[],"_multiwidget":1}}'
				),
				'beauty-clinic' => array(
					'title' => esc_html__('Beauty Clinic', 'mediz'),
					'url' => 'https://demo.goodlayers.com/mediz/beautyclinic',
					'xml' => get_template_directory() . '/admin/function/files/beautyclinic.xml',
					'page' => 8371,
					'menu' => array('main_menu' => 73, 'mobile_menu' => 73),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Blog","id":"gdlr-core-sidebar"},{"name":"Blog Left","id":"gdlr-core-sidebar1"},{"name":"Blog Right","id":"gdlr-core-sidebar2"},{"name":"Shop","id":"gdlr-core-sidebar3"},{"name":"Quick Links","id":"gdlr-core-sidebar4"},{"name":"Department - Lung","id":"gdlr-core-sidebar5"},{"name":"Department - Heart","id":"gdlr-core-sidebar6"},{"name":"Department - Orthopaedic","id":"gdlr-core-sidebar7"},{"name":"Department - General Surgery","id":"gdlr-core-sidebar8"},{"name":"Department - Pharmacy","id":"gdlr-core-sidebar9"},{"name":"Department - Sport Injury","id":"gdlr-core-sidebar10"},{"name":"Department - Flu & Fever","id":"gdlr-core-sidebar11"},{"name":"Department - Dental","id":"gdlr-core-sidebar12"},{"name":"Department - Eye Care","id":"gdlr-core-sidebar13"}],"sidebars_widgets":{"wp_inactive_widgets":["gdlr-core-custom-menu-widget-3","text-6","gdlr-core-custom-menu-widget-4"],"gdlr-core-sidebar-preset":["recent-posts-2"],"footer-1":["text-1"],"footer-2":["text-35"],"footer-3":["gdlr-core-custom-menu-widget-16"],"footer-4":["gdlr-core-newsletter-widget-2"],"gdlr-core-sidebar":["text-5","recent-comments-3","tag_cloud-2"],"gdlr-core-sidebar1":["text-4","recent-posts-3","gdlr-core-recent-comment-widget-2"],"gdlr-core-sidebar2":["gdlr-core-recent-post-widget-1","tag_cloud-1","text-3","gdlr-core-custom-menu-widget-2"],"gdlr-core-sidebar3":[],"gdlr-core-sidebar4":[],"gdlr-core-sidebar5":["gdlr-core-custom-menu-widget-15","text-7","gdlr-core-opening-hour-widget-2","text-8"],"gdlr-core-sidebar6":["gdlr-core-custom-menu-widget-7","text-27","gdlr-core-opening-hour-widget-4","text-11"],"gdlr-core-sidebar7":["gdlr-core-custom-menu-widget-8","text-28","gdlr-core-opening-hour-widget-5","text-14"],"gdlr-core-sidebar8":["gdlr-core-custom-menu-widget-9","text-29","gdlr-core-opening-hour-widget-6","text-16"],"gdlr-core-sidebar9":["gdlr-core-custom-menu-widget-10","text-30","gdlr-core-opening-hour-widget-7","text-18"],"gdlr-core-sidebar10":["gdlr-core-custom-menu-widget-11","text-31","gdlr-core-opening-hour-widget-8","text-20"],"gdlr-core-sidebar11":["gdlr-core-custom-menu-widget-12","text-32","gdlr-core-opening-hour-widget-9","text-22"],"gdlr-core-sidebar12":["gdlr-core-custom-menu-widget-13","text-33","gdlr-core-opening-hour-widget-10","text-24"],"gdlr-core-sidebar13":["gdlr-core-custom-menu-widget-14","text-34","gdlr-core-opening-hour-widget-11","text-26"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Our Services","menu":"58","style":"list"},"3":{"title":"Case Study","menu":"75","style":"list"},"4":{"title":"Practice Areas","menu":"73","style":"list"},"7":{"title":"Heart Diseases","menu":"63","style":"list2"},"8":{"title":"Orthopaedic","menu":"64","style":"list2"},"9":{"title":"General Surgery","menu":"65","style":"list2"},"10":{"title":"Pharmacy","menu":"63","style":"list2"},"11":{"title":"Sport Injury","menu":"63","style":"list2"},"12":{"title":"Flu & Fever","menu":"63","style":"list2"},"13":{"title":"Dental","menu":"63","style":"list2"},"14":{"title":"Eye Care","menu":"63","style":"list2"},"15":{"title":"Lung Diseases","menu":"56","style":"list2"},"16":{"title":"Member Resources","menu":"112","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"2":{"title":" Our Newsletter","style":"style-1","icon-color":"#d87290"},"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"2":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"4":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"5":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"6":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"7":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"8":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"9":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"10":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"11":{"title":"Department Hours","color":"#17449e","icon":"icon-clock","day1-text":"Monday - Friday","day1-time":"08:00 - 20:00","day2-text":"Saturday","day2-time":"09:00 - 14:00","day3-text":"Sunday","day3-time":"Close","day4-text":"","day4-time":"","day5-text":"","day5-time":"","day6-text":"","day6-time":"","day7-text":"","day7-time":""},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"2":{"title":"Recent Comments","num-fetch":"3","num-excerpt":"15"},"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"1":{"title":"Recent Articles","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"3":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"","text":"[gdlr_core_space height=\"-6px\"]<img class=\"alignnone size-full\" src=\"https:\/\/demo.goodlayers.com\/mediz\/beautyclinic\/wp-content\/uploads\/sites\/8\/2020\/03\/homepage-beauty-logo.png\" alt=\"\" width=\"124\" \/>\r\n[gdlr_core_space height=\"-27px\"]\r\nExceptional primary care, designed\r\nfor real life\r\n\r\n[gdlr_core_icon icon=\"fa fa-facebook\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-youtube-play\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-linkedin\" size=\"19px\" color=\"#8a99c0\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\" ]","filter":true,"visual":true},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_space height=\"15px\"][gdlr_widget_box title=\"Let us help you!\" title-color=\"#b1976b\" background=\"https:\/\/demo.goodlayers.com\/attorna\/wp-content\/uploads\/2019\/02\/sidebar-contact-bg.jpg\" color=\"#b8b8b8\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"50px 37px 30px 43px\" font-size=\"19px\"]If you need any helps, please feel free to contact us. We will get back to you with 1 business day. Or if in hurry, just call us now.\r\n\r\n<span style=\"font-size: 18px; color: #fff; font-weight: 500;\">Call : (1)2345-2345-54<\/span>\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"14px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Contact@Attornasite.co[gdlr_core_space height=\"7px\"][gdlr_core_icon icon=\"icon_clock_alt\" size=\"15px\" color=\"#b1976b\" margin-left=\"\" margin-right=\"10px\" ] Mon - Fri 09:00-17:00\r\n[\/gdlr_widget_box][gdlr_core_space height=\"20px\"]\r\n\r\n[gdlr_core_button button-text=\"Firm\u2019s Presentation\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"left\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"solid\" border-radius=\"3px\" background-color= \"#b1976b\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"7":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"8":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient-v\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"11":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"14":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"16":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"18":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"20":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"22":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"24":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"26":{"title":"","text":"[gdlr_core_space height=\"-15px\"][gdlr_core_button button-text=\"Download PDF File\" button-link=\"#\" button-link-target=\"_self\" margin-right=\"0px\" text-align=\"center\" full-width-button=\"enable\" icon-position=\"left\" icon-color=\"#ffffff\" icon=\"fa fa-file-pdf-o\" button-background=\"gradient\" border-radius=\"3px\" background-color=\"#4D93E9\" background-gradient-color=\"#4DA4E9\" padding=\"19px 29px 20px\" text-transform=\"none\" text-size=\"14px\" text-letter-spacing=\"0px\"]","filter":true,"visual":true},"27":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"28":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"29":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"30":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"31":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"32":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"33":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"34":{"title":"","text":"[gdlr_core_space height=\"-7px\"][gdlr_widget_box title=\"Department Address\" title-color=\"#ffffff\" background=\"https:\/\/demo.goodlayers.com\/mediz\/hospital\/wp-content\/uploads\/sites\/2\/2019\/12\/department-bg.jpg\" color=\"#C3DEFF\" border-color=\"#293b6d\" border-width=\"0px\" border-radius=\"3px\" padding=\"37px 27px 20px 35px\" font-size=\"19px\"]Box 3233 1810 Kings Way King Street, 5th Avenue, New York[\/gdlr_widget_box][gdlr_core_space height=\"25px\"]\r\n\r\n[gdlr_core_icon icon=\"icon-phone\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">+1-2345-3455-33<\/span> [gdlr_core_space height=\"-20px\"]\r\n[gdlr_core_icon icon=\"icon-envelope\" size=\"17px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"color: #17449e;\">contact@mediztheme.co<\/span>[gdlr_core_space height=\"7px\"]","filter":true,"visual":true},"35":{"title":"Contact Centre","text":"[gdlr_core_icon icon=\"ion-ios-telephone\" size=\"19px\" color=\"#d87290\" margin-left=\"\" margin-right=\"10px\"](+1) 212-946-2707\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"ion-ios-location\" size=\"19px\" color=\"#d87290\" margin-left=\"3px\" margin-right=\"10px\" ]112 W 34th St, New York\r\n[gdlr_core_space height=\"-15px\"]\r\n[gdlr_core_icon icon=\"ion-ios-clock\" size=\"19px\" color=\"#d87290\" margin-left=\"\" margin-right=\"10px\" ]Mon - Fri: 8.00am 6.00pm","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"1":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"1":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0,"max_depth":""},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"1":{"title":"Recent Products","number":4,"show":"","orderby":"date","order":"desc","hide_free":0,"show_hidden":0},"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"1":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_zeno_fr_widget":{"1":[],"_multiwidget":1}}',
					'theme-option' => '{"mediz_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"disable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_icon icon=\"ion-location\" size=\"20px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ]112 W 34th St, New York\n[gdlr_core_icon icon=\"ion-ios-telephone\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]212-946-2707[gdlr_core_icon icon=\"ion-ios-clock\" size=\"19px\" color=\"#ffffff\" margin-left=\"25px\" margin-right=\"10px\" ]Mon - Fri:  9:00AM - 8:00PM","top-bar-right-text":"","top-bar-top-padding":"9px","top-bar-bottom-padding":"9px","top-bar-text-size":"16px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"transparent","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"16px","navigation-left-offset":"0","navigation-slide-bar":"style-2","navigation-slide-bar-top-margin":"-5px","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"40px","logo":"8433","logo-top-padding":"28px","logo-bottom-padding":"20px","logo-left-padding":"","max-logo-width":"120px","mobile-logo":"","max-tablet-logo-width":"125px","max-mobile-logo-width":"90px","mobile-logo-position":"logo-left","main-navigation-top-padding":"30px","main-navigation-bottom-padding":"39px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"2","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Contact Now","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-type":"overlay","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"80px","fixed-navigation-logo-top-padding":"17","fixed-navigation-logo-bottom-padding":"17","fixed-navigation-top-padding":"23","fixed-navigation-bottom-padding":"23","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"110px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"17px","default-title-font-transform":"none","default-title-font-size":"47px","default-title-font-weight":"600","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"17px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"11","default-title-background":"8301","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"custom","default-blog-title-top-padding":"104px","default-blog-title-bottom-padding":"105px","default-blog-feature-image":"none","default-blog-title-background-image":"7505","default-blog-top-bottom-gradient":"bottom","single-blog-title-top-gradient-size":"325px","single-blog-title-bottom-gradient-size":"346px","default-blog-title-background-overlay-opacity":"2","blog-style":"style-4","blockquote-style":"style-1","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar2","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"30","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"full","related-post-num-fetch":"2","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar2","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar3","woocommerce-archive-product-style":"grid-2","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"Personnel Square","woocommerce-related-product-column-size":"20","woocommerce-related-product-num-fetch":"3","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"56px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"center","copyright-top-padding":"0px","copyright-bottom-padding":"22px","copyright-text":"Copyright \u00a92019 Mediz. All Rights Reserved. <a href=\"#\">Legal and Privacy<\/a>.","copyright-left":"[gdlr_core_social_network facebook=\"#url\" twitter=\"#url\" linkedin=\"#\" skype=\"#\"  icon-size=\"17px\" icon-color=\"#17449E\" ]","copyright-right":"Copyright 2019 Mediz, All Right Reserved","enable-back-to-top":"disable","top-bar-right-button-icon-class":"fa fa-comment-o","top-bar-right-button-text":"Free consultant","top-bar-right-button-link":"\/attorna\/contact\/","top-bar-right-button-link-target":"_self","top-bar-shadow-size":"0","top-bar-shadow-color":"#0a0a0a","header-shadow-size":"0px","header-shadow-color":"#000","enable-logo":"enable","navigation-slide-bar-width":"","navigation-slide-bar-height":"5","main-navigation-search-icon":"icon-magnifier","main-navigation-search-icon-top-margin":"-1","main-navigation-cart-icon":"icon-bag","main-navigation-cart-icon-top-margin":"-1","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","enable-fixed-navigation-slide-bar":"enable","fixed-navigation-slide-bar-top-margin":"-18","blog-title-style":"","single-portfolio-navigation-middle-link":"#","logo-right-box1-icon":"icon-check","logo-right-box1-title":"Trusted By","logo-right-box1-caption":"120,000+  People","logo-right-box2-icon":"icon-check","logo-right-box2-title":"Best Hospital","logo-right-box2-caption":"U.K. News","logo-right-box3-icon":"icon-check","logo-right-box3-title":"Number #1","logo-right-box3-caption":"Clinic in London","fixed-navigation-right-top-margin":"2px"},"mediz_typography":{"heading-font":"Prata","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","testimonial-font":"Merriweather","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"47px","h2-font-size":"41px","h3-font-size":"30px","h4-font-size":"24px","h5-font-size":"21px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"14px","navigation-font-weight":"500","navigation-font-letter-spacing":"1","navigation-text-transform":"uppercase","navigation-right-button-font-size":"12px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"17px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"400","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/mediz\/dentist2\/wp-content\/uploads\/sites\/7\/2020\/01\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"}],"google-font-display":"optional","sub-navigation-font-size":""},"mediz_color":{"header-background-color":"#ffffff","top-cart-background-color":"#5170ca","top-cart-checkout-color":"#ffffff","secondary-menu-icon-color":"#0a2f53","secondary-menu-border-color":"#0a2f53","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#f4f4f4","navigation-bar-right-icon-color":"#0a2f53","main-menu-text-color":"#ffffff","woocommerce-theme-color":"#5170ca","woocommerce-price-color":"#707070","woocommerce-button-background-hover-color":"#5170ca","add-to-cart-background-color":"#5170ca","widget-price-filter-range-color":"#a3acc9","widget-price-filter-handle-color":"#5170ca","top-bar-social-hover-color":"#d0d5e8","navigation-slide-bar-color":"#ffffff","woocommerce-cart-icon-number-background":"#28c23e","woocommerce-cart-icon-number-color":"#ffffff","top-bar-background-color":"#5170ca","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#d0d5e8","top-bar-social-color":"#ffffff","header-plain-bottom-border-color":"#b7b7b7","logo-background-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#323232","breadcrumbs-text-color":"#969696","breadcrumbs-text-active-color":"#5170ca","navigation-bar-background-color":"#ffffff","navigation-bar-top-border-color":"#ffffff","sub-menu-text-color":"#7a7a7a","sub-menu-text-hover-color":"#5170ca","sub-menu-text-hover-background-color":"#f4f4f4","sub-mega-menu-title-color":"#5170ca","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-text-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#e1efee","navigation-right-button-background-color":"#4cd4ca","navigation-right-button-background-hover-color":"#55c6bb","navigation-right-button-border-color":"#4cd4ca","navigation-right-button-border-hover-color":"#55c6bb","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#d6d6d6","page-title-background-overlay-color":"#000000","body-content-color":"#555555","heading-color":"#161616","link-color":"#3d3d3d","link-hover-color":"#606060","divider-color":"#e6e6e6","input-box-background-color":"#f2f2f2","input-box-border-color":"#f2f2f2","input-box-text-color":"#979797","input-box-placeholder-color":"#979797","404-content-background-color":"#17449e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#96b7e8","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#5170ca","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#727272","search-box-border-color":"#f3f3f3","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#5170ca","custom-menu-widget-list-style-link-hover":"#5170ca","custom-menu-widget-list-style-border":"#5170ca","footer-background-color":"#fdf5f4","footer-title-color":"#222222","footer-content-color":"#373737","footer-link-color":"#373737","footer-link-hover-color":"#373737","footer-divider-color":"#dddddd","copyright-background-color":"#fdf5f4","copyright-text-color":"#6b7a90","copyright-link-color":"#d87290","copyright-link-hover-color":"#d88fa5","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#5170ca","single-blog-navigation-color":"#5170ca","single-blog-navigation2-left-overlay":"#5170ca","single-blog-navigation2-overlay":"#5170ca","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#5170ca","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#191919","blog-title-hover-color":"#5170ca","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#5170ca","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#5170ca","blog-thumbnail-category-background":"#5170ca","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#5170ca","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#5170ca","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#828282","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#5170ca","portfolio-badge-text-color":"#0a0a0a","portfolio-badge-background-color":"#5170ca","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#161616","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#191919","portfolio-button-filter-background-active-color":"#5170ca","price-table-background-color":"#ffffff","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#3e3e3e","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#c0cfe8","price-table-price-background-color":"#f6f6f6","price-table-price-color":"#323232","price-table-price-suffix-color":"#191919","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#383838","price-table-button-background-top-gradient-color":"#383838","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#5170ca","price-table-active-head-top-gradient-color":"#5170ca","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff3f2","price-table-active-price-background-color":"#f6f6f6","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#191919","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#5170ca","price-table-active-button-background-top-gradient-color":"#5170ca","accordion-normal-icon-color":"#4c4c4c","accordion-normal-title-head-color":"#4c4c4c","accordion-normal-title-color":"#4c4c4c","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#989898","accordion-title-head-color":"#191919","accordion-title-color":"#5170ca","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#5170ca","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#5170ca","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#5170ca","blockquote-item-content-color":"#1c1c1c","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#5170ca","button-background-hover-color":"#6a82c9","button-border-color":"#5170ca","button-border-hover-color":"#8095c9","button-gradient-background-color":"#5170ca","button-top-gradient-background-color":"#5170ca","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#7d7d7d","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#5170ca","dropdown-tab-head-text":"#252525","flipbox-background-color":"#5170ca","flipbox-border-color":"#5170ca","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#141414","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#5170ca","personnel-grid-position-color":"#9d9d9d","personnel-grid-divider-color":"#5170ca","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#d8c0b1","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#ddc5b5","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#b1976b","roadmap-number-active-text":"#b1976b","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#ddc5b5","roadmap-content-color":"#ddc5b5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#5170ca","slider-outer-navigation-color":"#5170ca","slider-outer-navigation-background-color":"#ffffff","slider-control-navigation-color":"#8a8a8a","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#5170ca","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#5170ca","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#161616","title-item-caption-color":"#747474","woocommerce-price-linethrough-color":"#949494","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#0a0a0a","add-to-cart-text-color":"#ffffff","widget-price-filter-bar-background-color":"#e6e6e6","skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#a1a1a1","content":"#ffffff","icon":"#ffffff","link":"#4d93e9","link-hover":"#94b8e8","divider":"","border":"","element-background":"#111111","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"","caption":"#5db0b8","content":"","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#5db0b8","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#373737","element-background":"#373737","element-content":"#989898","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter White","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#ffffff","element-background":"#ffffff","element-content":"#969696","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-dpment","title":"#17449e","title-hover":"","caption":"","content":"#606060","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-dpment","title":"#4d93e9","title-hover":"#4d93e9","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#4d93e9","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-doc-dpment","title":"#17449e","title-hover":"","caption":"","content":"#7c92bd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Lung Diseases","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"#4d93e9","link-hover":"","divider":"#4d93e9","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Counter","title":"#ffffff","title-hover":"","caption":"","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#17449e","link-hover":"#4d93e9","divider":"","border":"","element-background":"#17449e","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 contact form","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Accordion","title":"#93d9ff","title-hover":"","caption":"#bcdbff","content":"#bcdbff","icon":"#ffffff","link":"","link-hover":"","divider":"#5c79b3","border":"#5c79b3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Input","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A1 Column SVC","title":"#a6c4ff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVC","title":"#171717","title-hover":"","caption":"#757575","content":"#757575","icon":"#748ec4","link":"#748ec4","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVS MId","title":"#343434","title-hover":"","caption":"#797979","content":"#797979","icon":"#17449e","link":"#17449e","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blockqoute","title":"","title-hover":"","caption":"#17449e","content":"#4e4e4e","icon":"#17449e","link":"","link-hover":"#a1a1a1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-ls","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Blog Featured","title":"","title-hover":"","caption":"#a7a7a7","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Column SVC Bottom","title":"#ffffff","title-hover":"","caption":"#ccd7ec","content":"#ccd7ec","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Column SVC","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team Page","title":"#ffffff","title-hover":"","caption":"#b0c9e8","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#b2cae8","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"couter-Ourdoc","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-ourdoc","title":"#17449e","title-hover":"","caption":"","content":"#8f8f8f","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#17449e","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"col-clinic","title":"#ffffff","title-hover":"","caption":"","content":"#cbe3ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dentist Contact Form ","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personal HP Dentist","title":"","title-hover":"","caption":"#a1a1a1","content":"#a1a1a1","icon":"","link":"","link-hover":"","divider":"#4d93e9","border":"","element-background":"#5e9eeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Counter","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Accordion","title":"#4d93e9","title-hover":"","caption":"#8f8f8f","content":"#8f8f8f","icon":"#4d93e9","link":"","link-hover":"","divider":"#d9d9d9","border":"#d9d9d9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"letterbgwhite","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Clinic Contact Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f3f3f3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"About Dentist 2 Counter","title":"#4cd4ca","title-hover":"","caption":"#222222","content":"#222222","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Column SVC  Skin Care","title":"#d87290","title-hover":"","caption":"","content":"#373737","icon":"","link":"#0a2f53","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Column SVCn Line","title":"#0a2f53","title-hover":"","caption":"#696969","content":"#696969","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Product Skin","title":"#0a2f53","title-hover":"#d87290","caption":"#777777","content":"","icon":"","link":"","link-hover":"#d87290","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"blog-grid-divider-color":"#ffd115","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#5170ca","tag-cloud-border-color":"#5170ca","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","fixed-navigation-background-color":"","logo-bottom-border-color":"#b39a96","load-more-button-text":"#968481","load-more-button-border":"#968481","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#5170ca","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#5170ca","custom-menu-widget-box-style-text-active":"#ffffff","top-bar-right-button-background":"#b1976b","navigation-right-button-shadow-color":"#000","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#5170ca","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#5170ca","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7","testimonial-frame-background-color":"#ffffff","custom-menu-widget-list2-style-icon":"#888888","header-bar-right-text-icon":"#93b3f1","header-bar-right-text-title":"#5170ca","header-bar-right-text-caption":"#9f9f9f","blog-widget-feature-background-color":"17449e","blog-widget-feature-title-color":"#ffffff","blog-widget-feature-info-color":"#6a82c9"},"mediz_plugin":{"enable-srcset":"disable","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Gallery Portrait","width":"500","height":"600","hard-crop":""},{"name":"Port Large","width":"1500","height":"590","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":".tnp-subscription input[type=text], .tnp-subscription input[type=email], .tnp-subscription input[type=submit], .tnp-subscription select {\n    background-color: #ffffff;\n}","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"7684","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font","ionicons","simpleline"],"additional-body-script":""}}'
				),
			);
		}
	}

	// add action when finish install plugins
	add_action('mediz_tgmpa_no_item_redirect', 'mediz_tgmpa_no_item_redirect');
	if( !function_exists('mediz_tgmpa_no_item_redirect') ){
		function mediz_tgmpa_no_item_redirect(){
			echo '<script type="text/javascript">';
			echo 'window.location = \'' . admin_url('admin.php?page=gdlr_core_getting_start') . '\';';
			echo '</script>';
		}
	}

	// install required plugin and redirect to getting start page
	add_action('after_switch_theme', 'mediz_getting_start_redirect'); 	
	if( !function_exists('mediz_getting_start_redirect') ){
		function mediz_getting_start_redirect(){

			$default_theme_option = '{"mediz_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"disable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_icon icon=\"icon-clock\" size=\"18px\" color=\"#17449E\" margin-left=\"\" margin-right=\"10px\" ]Mon - Sun  0900 - 2100\n[gdlr_core_icon icon=\"icon-phone\" size=\"19px\" color=\"#17449E\" margin-left=\"25px\" margin-right=\"10px\" ]+1-2345-3455-33[gdlr_core_icon icon=\"icon-envelope\" size=\"19px\" color=\"#17449E\" margin-left=\"25px\" margin-right=\"10px\" ]<a href=\"mailto:contact@mediztheme.co\">contact@mediztheme.co<\/a> ","top-bar-right-text":"","top-bar-top-padding":"19px","top-bar-bottom-padding":"19px","top-bar-text-size":"15px","top-bar-bottom-border":"2px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-left-offset":"0","navigation-slide-bar":"disable","navigation-slide-bar-top-margin":"-28px","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"40px","logo":"","logo-top-padding":"20px","logo-bottom-padding":"18px","logo-left-padding":"","max-logo-width":"170px","mobile-logo":"","max-tablet-logo-width":"150px","max-mobile-logo-width":"120px","mobile-logo-position":"logo-left","main-navigation-top-padding":"41px","main-navigation-bottom-padding":"33px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"5px","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"round","main-navigation-right-button-text":"Contact Now","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-type":"overlay","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"17","fixed-navigation-logo-bottom-padding":"17","fixed-navigation-top-padding":"23","fixed-navigation-bottom-padding":"23","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"110px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"17px","default-title-font-transform":"none","default-title-font-size":"47px","default-title-font-weight":"600","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"17px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"0","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"custom","default-blog-title-top-padding":"104px","default-blog-title-bottom-padding":"105px","default-blog-feature-image":"none","default-blog-title-background-image":"","default-blog-top-bottom-gradient":"bottom","single-blog-title-top-gradient-size":"325px","single-blog-title-bottom-gradient-size":"346px","default-blog-title-background-overlay-opacity":"2","blog-style":"style-4","blockquote-style":"style-1","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"30","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"full","related-post-num-fetch":"2","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar2","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar3","woocommerce-archive-product-style":"grid-2","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"20","woocommerce-related-product-num-fetch":"3","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"45px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-text":"","copyright-left":"","copyright-right":"","enable-back-to-top":"disable","top-bar-right-button-icon-class":"fa fa-comment-o","top-bar-right-button-text":"Free consultant","top-bar-right-button-link":"\/attorna\/contact\/","top-bar-right-button-link-target":"_self","top-bar-shadow-size":"24px","top-bar-shadow-color":"#0a0a0a","header-shadow-size":"24px","header-shadow-color":"#000","enable-logo":"enable","navigation-slide-bar-width":"","navigation-slide-bar-height":"","main-navigation-search-icon":"icon-magnifier","main-navigation-search-icon-top-margin":"-4","main-navigation-cart-icon":"icon-bag","main-navigation-cart-icon-top-margin":"-4","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","enable-fixed-navigation-slide-bar":"enable","fixed-navigation-slide-bar-top-margin":"-18","blog-title-style":"","single-portfolio-navigation-middle-link":"#","logo-right-box1-icon":"","logo-right-box1-title":"","logo-right-box1-caption":"","logo-right-box2-icon":"i","logo-right-box2-title":"","logo-right-box2-caption":"","logo-right-box3-icon":"","logo-right-box3-title":"","logo-right-box3-caption":"","fixed-navigation-right-top-margin":"5"},"mediz_typography":{"heading-font":"Poppins","navigation-font":"Poppins","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Montserrat","testimonial-font":"Merriweather","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"47px","h2-font-size":"41px","h3-font-size":"30px","h4-font-size":"24px","h5-font-size":"21px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"15px","navigation-font-weight":"500","navigation-font-letter-spacing":"0px","navigation-text-transform":"none","navigation-right-button-font-size":"12px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"17px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"16px","copyright-font-weight":"400","copyright-font-letter-spacing":"1","copyright-text-transform":"uppercase","font-upload":"","google-font-display":"optional","sub-navigation-font-size":""},"mediz_color":{"header-background-color":"#ffffff","top-cart-background-color":"#232323","top-cart-checkout-color":"#4d93e9","secondary-menu-icon-color":"#545454","secondary-menu-border-color":"#3f3f3f","main-menu-text-hover-color":"#17449e","sub-menu-background-color":"#f4f4f4","navigation-bar-right-icon-color":"#b0b0b0","main-menu-text-color":"#8098c9","woocommerce-theme-color":"#4d93e9","woocommerce-price-color":"#707070","woocommerce-button-background-hover-color":"#4d93e9","add-to-cart-background-color":"#b1976b","widget-price-filter-range-color":"#b1976b","widget-price-filter-handle-color":"#af853b","top-bar-social-hover-color":"#4d93e9","navigation-slide-bar-color":"#dfdfdf","woocommerce-cart-icon-number-background":"#4d93e9","woocommerce-cart-icon-number-color":"#ffffff","top-bar-background-color":"#ffffff","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#17449e","top-bar-link-color":"#17449e","top-bar-link-hover-color":"#4d93e9","top-bar-social-color":"#17449e","header-plain-bottom-border-color":"#e8e8e8","logo-background-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#323232","breadcrumbs-text-color":"#969696","breadcrumbs-text-active-color":"#17449e","navigation-bar-background-color":"#ffffff","navigation-bar-top-border-color":"#e8e8e8","sub-menu-text-color":"#7a7a7a","sub-menu-text-hover-color":"#17449e","sub-menu-text-hover-background-color":"#f4f4f4","sub-mega-menu-title-color":"#17449e","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-text-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#d3dced","navigation-right-button-background-color":"#17449e","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#17449e","navigation-right-button-border-hover-color":"#17449e","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#bbd1ff","page-title-background-overlay-color":"#000000","body-content-color":"#555555","heading-color":"#161616","link-color":"#3d3d3d","link-hover-color":"#606060","divider-color":"#e6e6e6","input-box-background-color":"#f7f7f7","input-box-border-color":"#e0e0e0","input-box-text-color":"#979797","input-box-placeholder-color":"#979797","404-content-background-color":"#17449e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#96b7e8","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#4d93e9","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#727272","search-box-border-color":"#f3f3f3","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#17449e","custom-menu-widget-list-style-link-hover":"#4d93e9","custom-menu-widget-list-style-border":"#4d93e9","footer-background-color":"#f6f6f6","footer-title-color":"#020202","footer-content-color":"#8b8b8b","footer-link-color":"#919191","footer-link-hover-color":"#17449e","footer-divider-color":"#dddddd","copyright-background-color":"#ffffff","copyright-text-color":"#afafaf","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#4d93e9","single-blog-navigation-color":"#4d93e9","single-blog-navigation2-left-overlay":"#4d93e9","single-blog-navigation2-overlay":"#4d93e9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#4d93e9","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#191919","blog-title-hover-color":"#4d93e9","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#4d93e9","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#17449e","blog-thumbnail-category-background":"#4d93e9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#4d93e9","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#4d93e9","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#828282","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#4d93e9","portfolio-badge-text-color":"#0a0a0a","portfolio-badge-background-color":"#4d93e9","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#161616","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#191919","portfolio-button-filter-background-active-color":"#4d93e9","price-table-background-color":"#ffffff","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#3e3e3e","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#c0cfe8","price-table-price-background-color":"#f6f6f6","price-table-price-color":"#323232","price-table-price-suffix-color":"#191919","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#383838","price-table-button-background-top-gradient-color":"#383838","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#4d93e9","price-table-active-head-top-gradient-color":"#4d93e9","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff3f2","price-table-active-price-background-color":"#f6f6f6","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#191919","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#4d93e9","price-table-active-button-background-top-gradient-color":"#4d93e9","accordion-normal-icon-color":"#4c4c4c","accordion-normal-title-head-color":"#4c4c4c","accordion-normal-title-color":"#4c4c4c","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#989898","accordion-title-head-color":"#191919","accordion-title-color":"#4d93e9","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#4d93e9","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#b1976b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#b1976b","blockquote-item-content-color":"#1c1c1c","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#4d93e9","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#4d93e9","button-top-gradient-background-color":"#207ae8","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#7d7d7d","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#4d93e9","dropdown-tab-head-text":"#252525","flipbox-background-color":"#4d93e9","flipbox-border-color":"#4d93e9","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#141414","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#17449e","personnel-grid-position-color":"#9d9d9d","personnel-grid-divider-color":"#17449e","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#d8c0b1","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#ddc5b5","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#b1976b","roadmap-number-active-text":"#b1976b","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#ddc5b5","roadmap-content-color":"#ddc5b5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#4d93e9","slider-outer-navigation-color":"#4d93e9","slider-outer-navigation-background-color":"#ffffff","slider-control-navigation-color":"#8a8a8a","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#4d93e9","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#4d93e9","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#161616","title-item-caption-color":"#747474","woocommerce-price-linethrough-color":"#949494","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","widget-price-filter-bar-background-color":"#e6e6e6","skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#a1a1a1","content":"#ffffff","icon":"#ffffff","link":"#4d93e9","link-hover":"#94b8e8","divider":"","border":"","element-background":"#111111","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"","caption":"#5db0b8","content":"","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#5db0b8","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#373737","element-background":"#373737","element-content":"#989898","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter White","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#ffffff","element-background":"#ffffff","element-content":"#969696","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-dpment","title":"#17449e","title-hover":"","caption":"","content":"#606060","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-dpment","title":"#4d93e9","title-hover":"#4d93e9","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#4d93e9","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-doc-dpment","title":"#17449e","title-hover":"","caption":"","content":"#7c92bd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Lung Diseases","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"#4d93e9","link-hover":"","divider":"#4d93e9","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Counter","title":"#ffffff","title-hover":"","caption":"","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#17449e","link-hover":"#4d93e9","divider":"","border":"","element-background":"#17449e","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 contact form","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A2 Accordion","title":"#93d9ff","title-hover":"","caption":"#bcdbff","content":"#bcdbff","icon":"#ffffff","link":"","link-hover":"","divider":"#5c79b3","border":"#5c79b3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Input","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz A1 Column SVC","title":"#a6c4ff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVC","title":"#171717","title-hover":"","caption":"#757575","content":"#757575","icon":"#748ec4","link":"#748ec4","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Mediz HP Column SVS MId","title":"#343434","title-hover":"","caption":"#797979","content":"#797979","icon":"#17449e","link":"#17449e","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blockqoute","title":"","title-hover":"","caption":"#17449e","content":"#4e4e4e","icon":"#17449e","link":"","link-hover":"#a1a1a1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"cl-ls","title":"#171717","title-hover":"","caption":"","content":"#757575","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Blog Featured","title":"","title-hover":"","caption":"#a7a7a7","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Column SVC Bottom","title":"#ffffff","title-hover":"","caption":"#ccd7ec","content":"#ccd7ec","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Column SVC","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team Page","title":"#ffffff","title-hover":"","caption":"#b0c9e8","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#b2cae8","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"couter-Ourdoc","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc-ourdoc","title":"#17449e","title-hover":"","caption":"","content":"#8f8f8f","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#17449e","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"col-clinic","title":"#ffffff","title-hover":"","caption":"","content":"#cbe3ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dentist Contact Form ","title":"","title-hover":"#979797","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4d93e9","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personal HP Dentist","title":"","title-hover":"","caption":"#a1a1a1","content":"#a1a1a1","icon":"","link":"","link-hover":"","divider":"#4d93e9","border":"","element-background":"#5e9eeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Counter","title":"#ffffff","title-hover":"","caption":"#a9d0ff","content":"#a9d0ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP Dentist Accordion","title":"#4d93e9","title-hover":"","caption":"#8f8f8f","content":"#8f8f8f","icon":"#4d93e9","link":"","link-hover":"","divider":"#d9d9d9","border":"#d9d9d9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"letterbgwhite","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Clinic Contact Newsletter","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f3f3f3","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"blog-grid-divider-color":"#ffd115","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#4d93e9","tag-cloud-border-color":"#4d93e9","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","fixed-navigation-background-color":"","logo-bottom-border-color":"#b39a96","load-more-button-text":"#968481","load-more-button-border":"#968481","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#000000","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#4d93e9","custom-menu-widget-box-style-text-active":"#ffffff","top-bar-right-button-background":"#b1976b","navigation-right-button-shadow-color":"#000","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#4275dc","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#2653e3","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7","testimonial-frame-background-color":"#ffffff","custom-menu-widget-list2-style-icon":"#888888","header-bar-right-text-icon":"#93b3f1","header-bar-right-text-title":"#17449e","header-bar-right-text-caption":"#9f9f9f","blog-widget-feature-background-color":"17449e","blog-widget-feature-title-color":"#ffffff","blog-widget-feature-info-color":"#9ebeff"},"mediz_plugin":{"enable-srcset":"enable","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Gallery Portrait","width":"500","height":"600","hard-crop":""},{"name":"Port Large","width":"1500","height":"590","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"7684","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font","ionicons","simpleline"],"additional-body-script":""}}';
			$default_theme_option = json_decode($default_theme_option, true);
			foreach( $default_theme_option as $option_slug => $option_value ){
				$option = get_option($option_slug, array());
				if( empty($option) ){
					update_option($option_slug, $option_value);
				}
			}

			// redirect to plugin installation
			$plugin_slug = 'goodlayers-core';
			$getting_start_url = 'admin.php?page=gdlr_core_getting_start';
			// $redirect_url = mediz_tgmpa_does_plugin_active($plugin_slug,  $getting_start_url);
			$redirect_url = mediz_tgmpa_auto_install_url($plugin_slug,  $getting_start_url);
			
			if( empty($redirect_url) ){
				wp_redirect(admin_url('themes.php?page=tgmpa-install-plugins'));
			}else{
				wp_redirect($redirect_url);
			}

		}
	}