/*!


 * Generated using the Bootstrap Customizer (https://getbootstrap.com/docs/3.4/customize/)


 */





/*!


 * Bootstrap v3.4.1 (https://getbootstrap.com/)


 * Copyright 2011-2021 Twitter, Inc.


 * Licensed under the MIT license


 */





if (typeof jQuery === 'undefined') {


  throw new Error('Bootstrap\'s JavaScript requires jQuery')


}


+function ($) {


  'use strict';


  var version = $.fn.jquery.split(' ')[0].split('.')


  if ((version[0] < 2 && version[1] < 9) || (version[0] == 1 && version[1] == 9 && version[2] < 1) || (version[0] > 3)) {


    throw new Error('Bootstrap\'s JavaScript requires jQuery version 1.9.1 or higher, but lower than version 4')


  }


}(jQuery);





/* ========================================================================


 * Bootstrap: alert.js v3.4.1


 * https://getbootstrap.com/docs/3.4/javascript/#alerts


 * ========================================================================


 * Copyright 2011-2019 Twitter, Inc.


 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)


 * ======================================================================== */








+function ($) {


  'use strict';





  // ALERT CLASS DEFINITION


  // ======================





  var dismiss = '[data-dismiss="alert"]'


  var Alert   = function (el) {


    $(el).on('click', dismiss, this.close)


  }





  Alert.VERSION = '3.4.1'





  Alert.TRANSITION_DURATION = 150





  Alert.prototype.close = function (e) {


    var $this    = $(this)


    var selector = $this.attr('data-target')





    if (!selector) {


      selector = $this.attr('href')


      selector = selector && selector.replace(/.*(?=#[^\s]*$)/, '') // strip for ie7


    }





    selector    = selector === '#' ? [] : selector


    var $parent = $(document).find(selector)





    if (e) e.preventDefault()





    if (!$parent.length) {


      $parent = $this.closest('.alert')


    }





    $parent.trigger(e = $.Event('close.bs.alert'))





    if (e.isDefaultPrevented()) return





    $parent.removeClass('in')





    function removeElement() {


      // detach from parent, fire event then clean up data


      $parent.detach().trigger('closed.bs.alert').remove()


    }





    $.support.transition && $parent.hasClass('fade') ?


      $parent


        .one('bsTransitionEnd', removeElement)


        .emulateTransitionEnd(Alert.TRANSITION_DURATION) :


      removeElement()


  }








  // ALERT PLUGIN DEFINITION


  // =======================





  function Plugin(option) {


    return this.each(function () {


      var $this = $(this)


      var data  = $this.data('bs.alert')





      if (!data) $this.data('bs.alert', (data = new Alert(this)))


      if (typeof option == 'string') data[option].call($this)


    })


  }





  var old = $.fn.alert





  $.fn.alert             = Plugin


  $.fn.alert.Constructor = Alert








  // ALERT NO CONFLICT


  // =================





  $.fn.alert.noConflict = function () {


    $.fn.alert = old


    return this


  }








  // ALERT DATA-API


  // ==============





  $(document).on('click.bs.alert.data-api', dismiss, Alert.prototype.close)





}(jQuery);





/* ========================================================================


 * Bootstrap: modal.js v3.4.1


 * https://getbootstrap.com/docs/3.4/javascript/#modals


 * ========================================================================


 * Copyright 2011-2019 Twitter, Inc.


 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)


 * ======================================================================== */








+function ($) {


  'use strict';





  // MODAL CLASS DEFINITION


  // ======================





  var Modal = function (element, options) {


    this.options = options


    this.$body = $(document.body)


    this.$element = $(element)


    this.$dialog = this.$element.find('.modal-dialog')


    this.$backdrop = null


    this.isShown = null


    this.originalBodyPad = null


    this.scrollbarWidth = 0


    this.ignoreBackdropClick = false


    this.fixedContent = '.navbar-fixed-top, .navbar-fixed-bottom'





    if (this.options.remote) {


      this.$element


        .find('.modal-content')


        .load(this.options.remote, $.proxy(function () {


          this.$element.trigger('loaded.bs.modal')


        }, this))


    }


  }





  Modal.VERSION = '3.4.1'





  Modal.TRANSITION_DURATION = 300


  Modal.BACKDROP_TRANSITION_DURATION = 150





  Modal.DEFAULTS = {


    backdrop: true,


    keyboard: true,


    show: true


  }





  Modal.prototype.toggle = function (_relatedTarget) {


    return this.isShown ? this.hide() : this.show(_relatedTarget)


  }





  Modal.prototype.show = function (_relatedTarget) {


    var that = this


    var e = $.Event('show.bs.modal', { relatedTarget: _relatedTarget })





    this.$element.trigger(e)





    if (this.isShown || e.isDefaultPrevented()) return





    this.isShown = true





    this.checkScrollbar()


    this.setScrollbar()


    this.$body.addClass('modal-open')





    this.escape()


    this.resize()





    this.$element.on('click.dismiss.bs.modal', '[data-dismiss="modal"]', $.proxy(this.hide, this))





    this.$dialog.on('mousedown.dismiss.bs.modal', function () {


      that.$element.one('mouseup.dismiss.bs.modal', function (e) {


        if ($(e.target).is(that.$element)) that.ignoreBackdropClick = true


      })


    })





    this.backdrop(function () {


      var transition = $.support.transition && that.$element.hasClass('fade')





      if (!that.$element.parent().length) {


        that.$element.appendTo(that.$body) // don't move modals dom position


      }





      that.$element


        .show()


        .scrollTop(0)





      that.adjustDialog()





      if (transition) {


        that.$element[0].offsetWidth // force reflow


      }





      that.$element.addClass('in')





      that.enforceFocus()





      var e = $.Event('shown.bs.modal', { relatedTarget: _relatedTarget })





      transition ?


        that.$dialog // wait for modal to slide in


          .one('bsTransitionEnd', function () {


            that.$element.trigger('focus').trigger(e)


          })


          .emulateTransitionEnd(Modal.TRANSITION_DURATION) :


        that.$element.trigger('focus').trigger(e)


    })


  }





  Modal.prototype.hide = function (e) {


    if (e) e.preventDefault()





    e = $.Event('hide.bs.modal')





    this.$element.trigger(e)





    if (!this.isShown || e.isDefaultPrevented()) return





    this.isShown = false





    this.escape()


    this.resize()





    $(document).off('focusin.bs.modal')





    this.$element


      .removeClass('in')


      .off('click.dismiss.bs.modal')


      .off('mouseup.dismiss.bs.modal')





    this.$dialog.off('mousedown.dismiss.bs.modal')





    $.support.transition && this.$element.hasClass('fade') ?


      this.$element


        .one('bsTransitionEnd', $.proxy(this.hideModal, this))


        .emulateTransitionEnd(Modal.TRANSITION_DURATION) :


      this.hideModal()


  }





  Modal.prototype.enforceFocus = function () {


    $(document)


      .off('focusin.bs.modal') // guard against infinite focus loop


      .on('focusin.bs.modal', $.proxy(function (e) {


        if (document !== e.target &&


          this.$element[0] !== e.target &&


          !this.$element.has(e.target).length) {


          this.$element.trigger('focus')


        }


      }, this))


  }





  Modal.prototype.escape = function () {


    if (this.isShown && this.options.keyboard) {


      this.$element.on('keydown.dismiss.bs.modal', $.proxy(function (e) {


        e.which == 27 && this.hide()


      }, this))


    } else if (!this.isShown) {


      this.$element.off('keydown.dismiss.bs.modal')


    }


  }





  Modal.prototype.resize = function () {


    if (this.isShown) {


      $(window).on('resize.bs.modal', $.proxy(this.handleUpdate, this))


    } else {


      $(window).off('resize.bs.modal')


    }


  }





  Modal.prototype.hideModal = function () {


    var that = this


    this.$element.hide()


    this.backdrop(function () {


      that.$body.removeClass('modal-open')


      that.resetAdjustments()


      that.resetScrollbar()


      that.$element.trigger('hidden.bs.modal')


    })


  }





  Modal.prototype.removeBackdrop = function () {


    this.$backdrop && this.$backdrop.remove()


    this.$backdrop = null


  }





  Modal.prototype.backdrop = function (callback) {


    var that = this


    var animate = this.$element.hasClass('fade') ? 'fade' : ''





    if (this.isShown && this.options.backdrop) {


      var doAnimate = $.support.transition && animate





      this.$backdrop = $(document.createElement('div'))


        .addClass('modal-backdrop ' + animate)


        .appendTo(this.$body)





      this.$element.on('click.dismiss.bs.modal', $.proxy(function (e) {


        if (this.ignoreBackdropClick) {


          this.ignoreBackdropClick = false


          return


        }


        if (e.target !== e.currentTarget) return


        this.options.backdrop == 'static'


          ? this.$element[0].focus()


          : this.hide()


      }, this))





      if (doAnimate) this.$backdrop[0].offsetWidth // force reflow





      this.$backdrop.addClass('in')





      if (!callback) return





      doAnimate ?


        this.$backdrop


          .one('bsTransitionEnd', callback)


          .emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :


        callback()





    } else if (!this.isShown && this.$backdrop) {


      this.$backdrop.removeClass('in')





      var callbackRemove = function () {


        that.removeBackdrop()


        callback && callback()


      }


      $.support.transition && this.$element.hasClass('fade') ?


        this.$backdrop


          .one('bsTransitionEnd', callbackRemove)


          .emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :


        callbackRemove()





    } else if (callback) {


      callback()


    }


  }





  // these following methods are used to handle overflowing modals





  Modal.prototype.handleUpdate = function () {


    this.adjustDialog()


  }





  Modal.prototype.adjustDialog = function () {


    var modalIsOverflowing = this.$element[0].scrollHeight > document.documentElement.clientHeight





    this.$element.css({


      paddingLeft: !this.bodyIsOverflowing && modalIsOverflowing ? this.scrollbarWidth : '',


      paddingRight: this.bodyIsOverflowing && !modalIsOverflowing ? this.scrollbarWidth : ''


    })


  }





  Modal.prototype.resetAdjustments = function () {


    this.$element.css({


      paddingLeft: '',


      paddingRight: ''


    })


  }





  Modal.prototype.checkScrollbar = function () {


    var fullWindowWidth = window.innerWidth


    if (!fullWindowWidth) { // workaround for missing window.innerWidth in IE8


      var documentElementRect = document.documentElement.getBoundingClientRect()


      fullWindowWidth = documentElementRect.right - Math.abs(documentElementRect.left)


    }


    this.bodyIsOverflowing = document.body.clientWidth < fullWindowWidth


    this.scrollbarWidth = this.measureScrollbar()


  }





  Modal.prototype.setScrollbar = function () {


    var bodyPad = parseInt((this.$body.css('padding-right') || 0), 10)


    this.originalBodyPad = document.body.style.paddingRight || ''


    var scrollbarWidth = this.scrollbarWidth


    if (this.bodyIsOverflowing) {


      this.$body.css('padding-right', bodyPad + scrollbarWidth)


      $(this.fixedContent).each(function (index, element) {


        var actualPadding = element.style.paddingRight


        var calculatedPadding = $(element).css('padding-right')


        $(element)


          .data('padding-right', actualPadding)


          .css('padding-right', parseFloat(calculatedPadding) + scrollbarWidth + 'px')


      })


    }


  }





  Modal.prototype.resetScrollbar = function () {


    this.$body.css('padding-right', this.originalBodyPad)


    $(this.fixedContent).each(function (index, element) {


      var padding = $(element).data('padding-right')


      $(element).removeData('padding-right')


      element.style.paddingRight = padding ? padding : ''


    })


  }





  Modal.prototype.measureScrollbar = function () { // thx walsh


    var scrollDiv = document.createElement('div')


    scrollDiv.className = 'modal-scrollbar-measure'


    this.$body.append(scrollDiv)


    var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth


    this.$body[0].removeChild(scrollDiv)


    return scrollbarWidth


  }








  // MODAL PLUGIN DEFINITION


  // =======================





  function Plugin(option, _relatedTarget) {


    return this.each(function () {


      var $this = $(this)


      var data = $this.data('bs.modal')


      var options = $.extend({}, Modal.DEFAULTS, $this.data(), typeof option == 'object' && option)





      if (!data) $this.data('bs.modal', (data = new Modal(this, options)))


      if (typeof option == 'string') data[option](_relatedTarget)


      else if (options.show) data.show(_relatedTarget)


    })


  }





  var old = $.fn.modal





  $.fn.modal = Plugin


  $.fn.modal.Constructor = Modal








  // MODAL NO CONFLICT


  // =================





  $.fn.modal.noConflict = function () {


    $.fn.modal = old


    return this


  }








  // MODAL DATA-API


  // ==============





  $(document).on('click.bs.modal.data-api', '[data-toggle="modal"]', function (e) {


    var $this = $(this)


    var href = $this.attr('href')


    var target = $this.attr('data-target') ||


      (href && href.replace(/.*(?=#[^\s]+$)/, '')) // strip for ie7





    var $target = $(document).find(target)


    var option = $target.data('bs.modal') ? 'toggle' : $.extend({ remote: !/#/.test(href) && href }, $target.data(), $this.data())





    if ($this.is('a')) e.preventDefault()





    $target.one('show.bs.modal', function (showEvent) {


      if (showEvent.isDefaultPrevented()) return // only register focus restorer if modal will actually get shown


      $target.one('hidden.bs.modal', function () {


        $this.is(':visible') && $this.trigger('focus')


      })


    })


    Plugin.call($target, option, this)


  })





}(jQuery);





/* ========================================================================


 * Bootstrap: tab.js v3.4.1


 * https://getbootstrap.com/docs/3.4/javascript/#tabs


 * ========================================================================


 * Copyright 2011-2019 Twitter, Inc.


 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)


 * ======================================================================== */








+function ($) {


  'use strict';





  // TAB CLASS DEFINITION


  // ====================





  var Tab = function (element) {


    // jscs:disable requireDollarBeforejQueryAssignment


    this.element = $(element)


    // jscs:enable requireDollarBeforejQueryAssignment


  }





  Tab.VERSION = '3.4.1'





  Tab.TRANSITION_DURATION = 150





  Tab.prototype.show = function () {


    var $this    = this.element


    var $ul      = $this.closest('ul:not(.dropdown-menu)')


    var selector = $this.data('target')





    if (!selector) {


      selector = $this.attr('href')


      selector = selector && selector.replace(/.*(?=#[^\s]*$)/, '') // strip for ie7


    }





    if ($this.parent('li').hasClass('active')) return





    var $previous = $ul.find('.active:last a')


    var hideEvent = $.Event('hide.bs.tab', {


      relatedTarget: $this[0]


    })


    var showEvent = $.Event('show.bs.tab', {


      relatedTarget: $previous[0]


    })





    $previous.trigger(hideEvent)


    $this.trigger(showEvent)





    if (showEvent.isDefaultPrevented() || hideEvent.isDefaultPrevented()) return





    var $target = $(document).find(selector)





    this.activate($this.closest('li'), $ul)


    this.activate($target, $target.parent(), function () {


      $previous.trigger({


        type: 'hidden.bs.tab',


        relatedTarget: $this[0]


      })


      $this.trigger({


        type: 'shown.bs.tab',


        relatedTarget: $previous[0]


      })


    })


  }





  Tab.prototype.activate = function (element, container, callback) {


    var $active    = container.find('> .active')


    var transition = callback


      && $.support.transition


      && ($active.length && $active.hasClass('fade') || !!container.find('> .fade').length)





    function next() {


      $active


        .removeClass('active')


        .find('> .dropdown-menu > .active')


        .removeClass('active')


        .end()


        .find('[data-toggle="tab"]')


        .attr('aria-expanded', false)





      element


        .addClass('active')


        .find('[data-toggle="tab"]')


        .attr('aria-expanded', true)





      if (transition) {


        element[0].offsetWidth // reflow for transition


        element.addClass('in')


      } else {


        element.removeClass('fade')


      }





      if (element.parent('.dropdown-menu').length) {


        element


          .closest('li.dropdown')


          .addClass('active')


          .end()


          .find('[data-toggle="tab"]')


          .attr('aria-expanded', true)


      }





      callback && callback()


    }





    $active.length && transition ?


      $active


        .one('bsTransitionEnd', next)


        .emulateTransitionEnd(Tab.TRANSITION_DURATION) :


      next()





    $active.removeClass('in')


  }








  // TAB PLUGIN DEFINITION


  // =====================





  function Plugin(option) {


    return this.each(function () {


      var $this = $(this)


      var data  = $this.data('bs.tab')





      if (!data) $this.data('bs.tab', (data = new Tab(this)))


      if (typeof option == 'string') data[option]()


    })


  }





  var old = $.fn.tab





  $.fn.tab             = Plugin


  $.fn.tab.Constructor = Tab








  // TAB NO CONFLICT


  // ===============





  $.fn.tab.noConflict = function () {


    $.fn.tab = old


    return this


  }








  // TAB DATA-API


  // ============





  var clickHandler = function (e) {


    e.preventDefault()


    Plugin.call($(this), 'show')


  }





  $(document)


    .on('click.bs.tab.data-api', '[data-toggle="tab"]', clickHandler)


    .on('click.bs.tab.data-api', '[data-toggle="pill"]', clickHandler)





}(jQuery);





/* ========================================================================


 * Bootstrap: collapse.js v3.4.1


 * https://getbootstrap.com/docs/3.4/javascript/#collapse


 * ========================================================================


 * Copyright 2011-2019 Twitter, Inc.


 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)


 * ======================================================================== */





/* jshint latedef: false */





+function ($) {


  'use strict';





  // COLLAPSE PUBLIC CLASS DEFINITION


  // ================================





  var Collapse = function (element, options) {


    this.$element      = $(element)


    this.options       = $.extend({}, Collapse.DEFAULTS, options)


    this.$trigger      = $('[data-toggle="collapse"][href="#' + element.id + '"],' +


                           '[data-toggle="collapse"][data-target="#' + element.id + '"]')


    this.transitioning = null





    if (this.options.parent) {


      this.$parent = this.getParent()


    } else {


      this.addAriaAndCollapsedClass(this.$element, this.$trigger)


    }





    if (this.options.toggle) this.toggle()


  }





  Collapse.VERSION  = '3.4.1'





  Collapse.TRANSITION_DURATION = 350





  Collapse.DEFAULTS = {


    toggle: true


  }





  Collapse.prototype.dimension = function () {


    var hasWidth = this.$element.hasClass('width')


    return hasWidth ? 'width' : 'height'


  }





  Collapse.prototype.show = function () {


    if (this.transitioning || this.$element.hasClass('in')) return





    var activesData


    var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing')





    if (actives && actives.length) {


      activesData = actives.data('bs.collapse')


      if (activesData && activesData.transitioning) return


    }





    var startEvent = $.Event('show.bs.collapse')


    this.$element.trigger(startEvent)


    if (startEvent.isDefaultPrevented()) return





    if (actives && actives.length) {


      Plugin.call(actives, 'hide')


      activesData || actives.data('bs.collapse', null)


    }





    var dimension = this.dimension()





    this.$element


      .removeClass('collapse')


      .addClass('collapsing')[dimension](0)


      .attr('aria-expanded', true)





    this.$trigger


      .removeClass('collapsed')


      .attr('aria-expanded', true)





    this.transitioning = 1





    var complete = function () {


      this.$element


        .removeClass('collapsing')


        .addClass('collapse in')[dimension]('')


      this.transitioning = 0


      this.$element


        .trigger('shown.bs.collapse')


    }





    if (!$.support.transition) return complete.call(this)





    var scrollSize = $.camelCase(['scroll', dimension].join('-'))





    this.$element


      .one('bsTransitionEnd', $.proxy(complete, this))


      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])


  }





  Collapse.prototype.hide = function () {


    if (this.transitioning || !this.$element.hasClass('in')) return





    var startEvent = $.Event('hide.bs.collapse')


    this.$element.trigger(startEvent)


    if (startEvent.isDefaultPrevented()) return





    var dimension = this.dimension()





    this.$element[dimension](this.$element[dimension]())[0].offsetHeight





    this.$element


      .addClass('collapsing')


      .removeClass('collapse in')


      .attr('aria-expanded', false)





    this.$trigger


      .addClass('collapsed')


      .attr('aria-expanded', false)





    this.transitioning = 1





    var complete = function () {


      this.transitioning = 0


      this.$element


        .removeClass('collapsing')


        .addClass('collapse')


        .trigger('hidden.bs.collapse')


    }





    if (!$.support.transition) return complete.call(this)





    this.$element


      [dimension](0)


      .one('bsTransitionEnd', $.proxy(complete, this))


      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)


  }





  Collapse.prototype.toggle = function () {


    this[this.$element.hasClass('in') ? 'hide' : 'show']()


  }





  Collapse.prototype.getParent = function () {


    return $(document).find(this.options.parent)


      .find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]')


      .each($.proxy(function (i, element) {


        var $element = $(element)


        this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element)


      }, this))


      .end()


  }





  Collapse.prototype.addAriaAndCollapsedClass = function ($element, $trigger) {


    var isOpen = $element.hasClass('in')





    $element.attr('aria-expanded', isOpen)


    $trigger


      .toggleClass('collapsed', !isOpen)


      .attr('aria-expanded', isOpen)


  }





  function getTargetFromTrigger($trigger) {


    var href


    var target = $trigger.attr('data-target')


      || (href = $trigger.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, '') // strip for ie7





    return $(document).find(target)


  }








  // COLLAPSE PLUGIN DEFINITION


  // ==========================





  function Plugin(option) {


    return this.each(function () {


      var $this   = $(this)


      var data    = $this.data('bs.collapse')


      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)





      if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false


      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))


      if (typeof option == 'string') data[option]()


    })


  }





  var old = $.fn.collapse





  $.fn.collapse             = Plugin


  $.fn.collapse.Constructor = Collapse








  // COLLAPSE NO CONFLICT


  // ====================





  $.fn.collapse.noConflict = function () {


    $.fn.collapse = old


    return this


  }








  // COLLAPSE DATA-API


  // =================





  $(document).on('click.bs.collapse.data-api', '[data-toggle="collapse"]', function (e) {


    var $this   = $(this)





    if (!$this.attr('data-target')) e.preventDefault()





    var $target = getTargetFromTrigger($this)


    var data    = $target.data('bs.collapse')


    var option  = data ? 'toggle' : $this.data()





    Plugin.call($target, option)


  })





}(jQuery);





/* ========================================================================


 * Bootstrap: scrollspy.js v3.4.1


 * https://getbootstrap.com/docs/3.4/javascript/#scrollspy


 * ========================================================================


 * Copyright 2011-2019 Twitter, Inc.


 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)


 * ======================================================================== */








+function ($) {


  'use strict';





  // SCROLLSPY CLASS DEFINITION


  // ==========================





  function ScrollSpy(element, options) {


    this.$body          = $(document.body)


    this.$scrollElement = $(element).is(document.body) ? $(window) : $(element)


    this.options        = $.extend({}, ScrollSpy.DEFAULTS, options)


    this.selector       = (this.options.target || '') + ' .nav li > a'


    this.offsets        = []


    this.targets        = []


    this.activeTarget   = null


    this.scrollHeight   = 0





    this.$scrollElement.on('scroll.bs.scrollspy', $.proxy(this.process, this))


    this.refresh()


    this.process()


  }





  ScrollSpy.VERSION  = '3.4.1'





  ScrollSpy.DEFAULTS = {


    offset: 10


  }





  ScrollSpy.prototype.getScrollHeight = function () {


    return this.$scrollElement[0].scrollHeight || Math.max(this.$body[0].scrollHeight, document.documentElement.scrollHeight)


  }





  ScrollSpy.prototype.refresh = function () {


    var that          = this


    var offsetMethod  = 'offset'


    var offsetBase    = 0





    this.offsets      = []


    this.targets      = []


    this.scrollHeight = this.getScrollHeight()





    if (!$.isWindow(this.$scrollElement[0])) {


      offsetMethod = 'position'


      offsetBase   = this.$scrollElement.scrollTop()


    }





    this.$body


      .find(this.selector)


      .map(function () {


        var $el   = $(this)


        var href  = $el.data('target') || $el.attr('href')


        var $href = /^#./.test(href) && $(href)





        return ($href


          && $href.length


          && $href.is(':visible')


          && [[$href[offsetMethod]().top + offsetBase, href]]) || null


      })


      .sort(function (a, b) { return a[0] - b[0] })


      .each(function () {


        that.offsets.push(this[0])


        that.targets.push(this[1])


      })


  }





  ScrollSpy.prototype.process = function () {


    var scrollTop    = this.$scrollElement.scrollTop() + this.options.offset


    var scrollHeight = this.getScrollHeight()


    var maxScroll    = this.options.offset + scrollHeight - this.$scrollElement.height()


    var offsets      = this.offsets


    var targets      = this.targets


    var activeTarget = this.activeTarget


    var i





    if (this.scrollHeight != scrollHeight) {


      this.refresh()


    }





    if (scrollTop >= maxScroll) {


      return activeTarget != (i = targets[targets.length - 1]) && this.activate(i)


    }





    if (activeTarget && scrollTop < offsets[0]) {


      this.activeTarget = null


      return this.clear()


    }





    for (i = offsets.length; i--;) {


      activeTarget != targets[i]


        && scrollTop >= offsets[i]


        && (offsets[i + 1] === undefined || scrollTop < offsets[i + 1])


        && this.activate(targets[i])


    }


  }





  ScrollSpy.prototype.activate = function (target) {


    this.activeTarget = target





    this.clear()





    var selector = this.selector +


      '[data-target="' + target + '"],' +


      this.selector + '[href="' + target + '"]'





    var active = $(selector)


      .parents('li')


      .addClass('active')





    if (active.parent('.dropdown-menu').length) {


      active = active


        .closest('li.dropdown')


        .addClass('active')


    }





    active.trigger('activate.bs.scrollspy')


  }





  ScrollSpy.prototype.clear = function () {


    $(this.selector)


      .parentsUntil(this.options.target, '.active')


      .removeClass('active')


  }








  // SCROLLSPY PLUGIN DEFINITION


  // ===========================





  function Plugin(option) {


    return this.each(function () {


      var $this   = $(this)


      var data    = $this.data('bs.scrollspy')


      var options = typeof option == 'object' && option





      if (!data) $this.data('bs.scrollspy', (data = new ScrollSpy(this, options)))


      if (typeof option == 'string') data[option]()


    })


  }





  var old = $.fn.scrollspy





  $.fn.scrollspy             = Plugin


  $.fn.scrollspy.Constructor = ScrollSpy








  // SCROLLSPY NO CONFLICT


  // =====================





  $.fn.scrollspy.noConflict = function () {


    $.fn.scrollspy = old


    return this


  }








  // SCROLLSPY DATA-API


  // ==================





  $(window).on('load.bs.scrollspy.data-api', function () {


    $('[data-spy="scroll"]').each(function () {


      var $spy = $(this)


      Plugin.call($spy, $spy.data())


    })


  })





}(jQuery);





/* ========================================================================


 * Bootstrap: transition.js v3.4.1


 * https://getbootstrap.com/docs/3.4/javascript/#transitions


 * ========================================================================


 * Copyright 2011-2019 Twitter, Inc.


 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)


 * ======================================================================== */








+function ($) {


  'use strict';





  // CSS TRANSITION SUPPORT (Shoutout: https://modernizr.com/)


  // ============================================================





  function transitionEnd() {


    var el = document.createElement('bootstrap')





    var transEndEventNames = {


      WebkitTransition : 'webkitTransitionEnd',


      MozTransition    : 'transitionend',


      OTransition      : 'oTransitionEnd otransitionend',


      transition       : 'transitionend'


    }





    for (var name in transEndEventNames) {


      if (el.style[name] !== undefined) {


        return { end: transEndEventNames[name] }


      }


    }





    return false // explicit for ie8 (  ._.)


  }





  // https://blog.alexmaccaw.com/css-transitions


  $.fn.emulateTransitionEnd = function (duration) {


    var called = false


    var $el = this


    $(this).one('bsTransitionEnd', function () { called = true })


    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }


    setTimeout(callback, duration)


    return this


  }





  $(function () {


    $.support.transition = transitionEnd()





    if (!$.support.transition) return





    $.event.special.bsTransitionEnd = {


      bindType: $.support.transition.end,


      delegateType: $.support.transition.end,


      handle: function (e) {


        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments)


      }


    }


  })





}(jQuery);


