<?php defined('ABSPATH') || exit; ?>

<div class="ultp-dashboard-container">

    <!-- getting start content -->
    <div class="ultp-dashboard-body ultp-card ultp-getstart-body">

        <div class="ultp-container-grid">

            <div class="ultp-getstart-content">
                <div class="ultp-card ultp-p25">
                    <iframe width="650" height="395" src="https://www.youtube.com/embed/_GfXTvSdJTk" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        <div class="ultp-feature-btn">
                            <a class="ultp-btn ultp-btn-primary" target="_blank" href="<?php echo esc_url(ultimate_post()->get_premium_link('https://www.wpxpo.com/postx/', 'postx_dashboard_started_details')); ?>"><?php esc_html_e('Plugin Details', 'ultimate-post'); ?></a>    
                            <a class="ultp-btn ultp-btn-transparent" href="<?php echo esc_url(ultimate_post()->get_premium_link('https://www.wpxpo.com/postx/starter-packs/', 'postx_dashboard_go_library')); ?>"><?php esc_html_e('Go to Templates Library', 'ultimate-post'); ?></a>
                        </div>
                </div>
                    <div class="ultp-features"> 
                        <div class="ultp-text-center"><h2 class="ultp-lg-heading"><?php esc_html_e('Why Choose PostX?', 'ultimate-post'); ?></h2></div> 
                        <div class="ultp-feature-items">    
                            <div class="ultp-feature-item ultp-card ultp-p25">    
                                <div class="ultp-feature-image">    
                                    <img loading="lazy" src="<?php echo esc_url(ULTP_URL.'assets/img/admin/dashboard/advanced_query.jpg'); ?>" alt="Advanced Query Builder">        
                                </div>
                                <div class="ultp-feature-content">    
                                    <h4 class="ultp-xs-heading"><?php esc_html_e('Advanced Query Builder', 'ultimate-post'); ?></h4> 
                                    <div><?php esc_html_e('Sort the posts and pages based on multiple criteria that include categories, tags, popular, recent, related, most commented, and much more.', 'ultimate-post'); ?></div>
                                </div>
                            </div>
                            <div class="ultp-feature-item ultp-card ultp-p25"> 
                                <div class="ultp-feature-image">    
                                    <img loading="lazy" src="<?php echo esc_url(ULTP_URL.'assets/img/admin/dashboard/starter_packs.jpg'); ?>" alt="Ready-made Starter Packs">        
                                </div>   
                                <div class="ultp-feature-content">    
                                    <h4 class="ultp-xs-heading"><?php esc_html_e('Ready-made Starter Packs', 'ultimate-post'); ?></h4> 
                                    <div><?php esc_html_e('PostX comes with lots of Starter Packs (Premade Templates) and numerous design variations for the post blocks.', 'ultimate-post'); ?></div>
                                </div>
                            </div>  
                            <div class="ultp-feature-item ultp-card ultp-p25"> 
                                <div class="ultp-feature-image">    
                                    <img loading="lazy" src="<?php echo esc_url(ULTP_URL.'assets/img/admin/dashboard/archive_builder.jpg'); ?>" alt="Archive Page Builder">        
                                </div>   
                                <div class="ultp-feature-content">    
                                    <h4 class="ultp-xs-heading"><?php esc_html_e('Archive Page Builder', 'ultimate-post'); ?></h4> 
                                    <div><?php esc_html_e('The Archive Page Builder helps you to create dynamic categories, taxonomies, tags, author, date, and search result pages.', 'ultimate-post'); ?></div>
                                </div>
                            </div>
                            <div class="ultp-feature-item ultp-card ultp-p25">    
                                <div class="ultp-feature-image">    
                                    <img loading="lazy" src="<?php echo esc_url(ULTP_URL.'assets/img/admin/dashboard/post_slider.jpg'); ?>" alt="Dynamic Post Slider">        
                                </div>
                                <div class="ultp-feature-content">    
                                    <h4 class="ultp-xs-heading"><?php esc_html_e('Dynamic Post Slider', 'ultimate-post'); ?></h4> 
                                    <div><?php esc_html_e('Post Sliders are now easier to build using our post slider blocks. It is fully dynamic and can be used with any custom query to display your posts.', 'ultimate-post'); ?></div>
                                </div>
                            </div>
                            <div class="ultp-feature-item ultp-card ultp-p25"> 
                                <div class="ultp-feature-image">    
                                    <img loading="lazy" src="<?php echo esc_url(ULTP_URL.'assets/img/admin/dashboard/ajax_filter.jpg'); ?>" alt="AJAX Powered Post Filter">        
                                </div>   
                                <div class="ultp-feature-content">    
                                    <h4 class="ultp-xs-heading"><?php esc_html_e('AJAX Powered Post Filter', 'ultimate-post'); ?></h4> 
                                    <div><?php esc_html_e('The Ajax filtering feature helps to let the visitors filter posts by specific or multiple categories and tags without reloading the whole page.', 'ultimate-post'); ?></div>
                                </div>
                            </div>  
                            <div class="ultp-feature-item ultp-card ultp-p25"> 
                                <div class="ultp-feature-image">    
                                    <img loading="lazy" src="<?php echo esc_url(ULTP_URL.'assets/img/admin/dashboard/posts_pagination.jpg'); ?>" alt="Advanced Posts Pagination">        
                                </div>   
                                <div class="ultp-feature-content">    
                                    <h4 class="ultp-xs-heading"><?php esc_html_e('Advanced Posts Pagination', 'ultimate-post'); ?></h4> 
                                    <div><?php esc_html_e('PostX offers three types of dynamic and customizable paginations including Navigation, Numeric Pagination, and Load More.', 'ultimate-post'); ?></div>
                                </div>
                            </div>  
                        </div>
                        <div class="ultp-text-center">
                            <a class="ultp-btn ultp-btn-primary" target="_blank" href="<?php echo esc_url(ultimate_post()->get_premium_link('https://www.wpxpo.com/postx/all-features/', 'postx_dashboard_started_feature')); ?>"><?php esc_html_e('More Features', 'ultimate-post'); ?><span class="dashicons dashicons-arrow-right-alt"></span></a>
                        </div>  
                    </div>  

                    <div class="ultp-getstart-documentation">
                        <div>
                            <h4 class="ultp-md-heading">
                                <?php esc_html_e('Easy Documentation', 'ultimate-post'); ?>
                            </h4>
                            <div class="ultp-documentation-desc">
                                <?php esc_html_e('Get step-by-step guides on the best ways to use PostX.', 'ultimate-post'); ?>
                            </div>
                        </div>
                        <a href="https://docs.wpxpo.com/docs/postx/" target="_blank"><?php esc_html_e('Documentation', 'ultimate-post'); ?></a>
                    </div>
            </div>

            <!-- # Right Sidebar Content -->
            <div>
                <?php
                    require_once ULTP_PATH.'classes/options/Banner.php';
                    $obj = new \ULTP\Banner();
                    $obj->premium_feature_sidebar();
                ?>
                <div class="ultp-aside-image ultp-mb40">
                    <a href="<?php echo esc_url(ultimate_post()->get_premium_link('https://www.wpxpo.com/postx/patterns/', 'postx_dashboard_go_patterns')); ?>">
                        <img loading="lazy" src="<?php echo esc_url(ULTP_URL.'assets/img/admin/dashboard/postx-sidebar-design.jpg'); ?>" alt="Filter Category">
                    </a>
                </div>
                <div class="ultp-aside-content ultp-card ultp-p25">
                    <div class="ultp-aside-heading ultp-sm-heading">
                        <span class="dashicons dashicons-facebook"></span>
                        <?php esc_html_e('Join Facebook Group', 'ultimate-post'); ?>
                    </div>
                    <p class="ultp-support-desc">
                        <?php esc_html_e('You can discuss anything related to PostX. You can share your issues, tips, and idea with the group member.', 'ultimate-post'); ?>
                    </p>
                    <a href="https://www.facebook.com/groups/gutenbergpostx" class="ultp-btn ultp-btn-transparent" target="_blank">
                        <?php esc_html_e('Join Facebook Group', 'ultimate-post'); ?>
                    </a>
                </div>
                <div class="ultp-aside-content ultp-card ultp-p25">
                    <div class="ultp-aside-heading ultp-sm-heading">
                        <span class="dashicons dashicons-media-document"></span>
                        <?php esc_html_e('Changelog', 'ultimate-post'); ?>
                    </div>
                    <p class="ultp-support-desc">
                        <?php esc_html_e('Be up to date with all the latest features, bug, and error fixing updates of PostX.', 'ultimate-post'); ?>
                    </p>
                    <a href="<?php echo esc_url(ultimate_post()->get_premium_link("https://www.wpxpo.com/postx/changelog/", 'postx_dashboard_started_changelog')); ?>" class="ultp-btn ultp-btn-transparent" target="_blank">
                        <?php esc_html_e('View Changelog', 'ultimate-post'); ?>
                    </a>
                </div>
                <div class="ultp-aside-content ultp-card ultp-p25 ultp-aside-content-rate">
                    <div class="ultp-aside-heading ultp-sm-heading">
                    <span class="dashicons dashicons-star-filled"></span>
                        <?php esc_html_e('Show your love', 'ultimate-post'); ?>
                    </div>
                    <p class="ultp-support-desc">
                        <?php esc_html_e('Enjoying PostX? Give us a review to support our endless work.', 'ultimate-post'); ?>
                    </p>
                    <a href="https://wordpress.org/plugins/ultimate-post/#reviews" class="ultp-btn ultp-btn-warning" target="_blank">
                        <?php esc_html_e('Rate it now', 'ultimate-post'); ?>
                    </a>
                </div>
            </div>

        </div>
    </div>
</div>
